/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.submit;

import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.SparkApplication;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.SparkKubernetesClientFactory$;
import org.apache.spark.deploy.k8s.submit.Client;
import org.apache.spark.deploy.k8s.submit.ClientArguments;
import org.apache.spark.deploy.k8s.submit.ClientArguments$;
import org.apache.spark.deploy.k8s.submit.KubernetesClientApplication$;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder;
import org.apache.spark.deploy.k8s.submit.KubernetesDriverBuilder$;
import org.apache.spark.deploy.k8s.submit.LoggingPodStatusWatcherImpl;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001U3Q!\u0001\u0002\u0001\u00119\u00111dS;cKJtW\r^3t\u00072LWM\u001c;BaBd\u0017nY1uS>t'BA\u0002\u0005\u0003\u0019\u0019XOY7ji*\u0011QAB\u0001\u0004Wb\u001a(BA\u0004\t\u0003\u0019!W\r\u001d7ps*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xmE\u0002\u0001\u001fU\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u00051\u0011B\u0001\r\u0007\u0005A\u0019\u0006/\u0019:l\u0003B\u0004H.[2bi&|g\u000eC\u0003\u001b\u0001\u0011\u0005A$\u0001\u0004=S:LGOP\u0002\u0001)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"\u0002\u0011\u0001\t\u0003\n\u0013!B:uCJ$Hc\u0001\u0012&kA\u0011\u0001cI\u0005\u0003IE\u0011A!\u00168ji\")ae\ba\u0001O\u0005!\u0011M]4t!\r\u0001\u0002FK\u0005\u0003SE\u0011Q!\u0011:sCf\u0004\"a\u000b\u001a\u000f\u00051\u0002\u0004CA\u0017\u0012\u001b\u0005q#BA\u0018\u001c\u0003\u0019a$o\\8u}%\u0011\u0011'E\u0001\u0007!J,G-\u001a4\n\u0005M\"$AB*ue&twM\u0003\u00022#!)ag\ba\u0001o\u0005!1m\u001c8g!\tA\u0014(D\u0001\t\u0013\tQ\u0004BA\u0005Ta\u0006\u00148nQ8oM\")A\b\u0001C\u0005{\u0005\u0019!/\u001e8\u0015\u0007\tr4\tC\u0003@w\u0001\u0007\u0001)A\bdY&,g\u000e^!sOVlWM\u001c;t!\tq\u0012)\u0003\u0002C\u0005\ty1\t\\5f]R\f%oZ;nK:$8\u000fC\u0003Ew\u0001\u0007q'A\u0005ta\u0006\u00148nQ8oM\u001e1aI\u0001E\u0001\u0011\u001d\u000b1dS;cKJtW\r^3t\u00072LWM\u001c;BaBd\u0017nY1uS>t\u0007C\u0001\u0010I\r\u0019\t!\u0001#\u0001\t\u0013N\u0011\u0001j\u0004\u0005\u00065!#\ta\u0013\u000b\u0002\u000f\")Q\n\u0013C\u0001\u001d\u0006Qq-\u001a;BaBt\u0015-\\3\u0015\u0005)z\u0005\"\u0002\u001cM\u0001\u00049\u0004\"B)I\t\u0003\u0011\u0016!F4fiJ+7o\\;sG\u0016t\u0015-\\3Qe\u00164\u0017\u000e\u001f\u000b\u0003UMCQ\u0001\u0016)A\u0002)\nq!\u00199q\u001d\u0006lW\r")
public class KubernetesClientApplication
implements SparkApplication {
    public static String getResourceNamePrefix(String string) {
        return KubernetesClientApplication$.MODULE$.getResourceNamePrefix(string);
    }

    public static String getAppName(SparkConf sparkConf) {
        return KubernetesClientApplication$.MODULE$.getAppName(sparkConf);
    }

    public void start(String[] args, SparkConf conf) {
        ClientArguments parsedArguments = ClientArguments$.MODULE$.fromCommandLineArgs(args);
        this.run(parsedArguments, conf);
    }

    private void run(ClientArguments clientArguments, SparkConf sparkConf) {
        String appName = (String)sparkConf.getOption("spark.app.name").getOrElse((Function0 & Serializable & scala.Serializable)() -> "spark");
        String kubernetesAppId = new StringBuilder(6).append("spark-").append(UUID.randomUUID().toString().replaceAll("-", "")).toString();
        boolean waitForAppCompletion = BoxesRunTime.unboxToBoolean((Object)sparkConf.get(Config$.MODULE$.WAIT_FOR_APP_COMPLETION()));
        String kubernetesResourceNamePrefix = KubernetesClientApplication$.MODULE$.getResourceNamePrefix(appName);
        sparkConf.set(Config$.MODULE$.KUBERNETES_PYSPARK_PY_FILES(), clientArguments.maybePyFiles().getOrElse((Function0 & Serializable & scala.Serializable)() -> ""));
        KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf = KubernetesConf$.MODULE$.createDriverConf(sparkConf, appName, kubernetesResourceNamePrefix, kubernetesAppId, clientArguments.mainAppResource(), clientArguments.mainClass(), clientArguments.driverArgs(), clientArguments.maybePyFiles());
        KubernetesDriverBuilder builder = new KubernetesDriverBuilder(KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$1(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$2(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$3(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$4(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$5(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$6(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$7(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$8(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$9(), KubernetesDriverBuilder$.MODULE$.$lessinit$greater$default$10());
        String namespace = kubernetesConf.namespace();
        String master = KubernetesUtils$.MODULE$.parseMasterUrl(sparkConf.get("spark.master"));
        None$ loggingInterval = waitForAppCompletion ? new Some(sparkConf.get(Config$.MODULE$.REPORT_INTERVAL())) : None$.MODULE$;
        LoggingPodStatusWatcherImpl watcher = new LoggingPodStatusWatcherImpl(kubernetesAppId, (Option<Object>)loggingInterval);
        Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> SparkKubernetesClientFactory$.MODULE$.createKubernetesClient(master, (Option<String>)new Some((Object)namespace), Config$.MODULE$.KUBERNETES_AUTH_SUBMISSION_CONF_PREFIX(), sparkConf, (Option<File>)None$.MODULE$, (Option<File>)None$.MODULE$), (Function1 & Serializable & scala.Serializable)kubernetesClient -> {
            KubernetesClientApplication.$anonfun$run$9(appName, waitForAppCompletion, kubernetesResourceNamePrefix, kubernetesConf, builder, watcher, kubernetesClient);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$run$9(String appName$1, boolean waitForAppCompletion$1, String kubernetesResourceNamePrefix$1, KubernetesConf kubernetesConf$1, KubernetesDriverBuilder builder$1, LoggingPodStatusWatcherImpl watcher$1, KubernetesClient kubernetesClient) {
        Client client = new Client(builder$1, kubernetesConf$1, kubernetesClient, waitForAppCompletion$1, appName$1, watcher$1, kubernetesResourceNamePrefix$1);
        client.run();
    }
}

