/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s.features;

import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServiceFluentImpl;
import io.fabric8.kubernetes.api.model.ServiceSpecFluent;
import java.io.Serializable;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.SparkPod;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep$;
import org.apache.spark.deploy.k8s.features.KubernetesFeatureConfigStep;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.util.Clock;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c!B\u0001\u0003\u0001!q!\u0001\u0007#sSZ,'oU3sm&\u001cWMR3biV\u0014Xm\u0015;fa*\u00111\u0001B\u0001\tM\u0016\fG/\u001e:fg*\u0011QAB\u0001\u0004Wb\u001a(BA\u0004\t\u0003\u0019!W\r\u001d7ps*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0005\u0003\u0001\u001fUI\u0002C\u0001\t\u0014\u001b\u0005\t\"\"\u0001\n\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\t\"AB!osJ+g\r\u0005\u0002\u0017/5\t!!\u0003\u0002\u0019\u0005\tY2*\u001e2fe:,G/Z:GK\u0006$XO]3D_:4\u0017nZ*uKB\u0004\"AG\u000f\u000e\u0003mQ!\u0001\b\u0005\u0002\u0011%tG/\u001a:oC2L!AH\u000e\u0003\u000f1{wmZ5oO\"A\u0001\u0005\u0001B\u0001B\u0003%!%\u0001\blk\n,'O\\3uKN\u001cuN\u001c4\u0004\u0001A\u00191\u0005\n\u0014\u000e\u0003\u0011I!!\n\u0003\u0003\u001d-+(-\u001a:oKR,7oQ8oMB\u00111eJ\u0005\u0003Q\u0011\u0011AdS;cKJtW\r^3t\tJLg/\u001a:Ta\u0016\u001c\u0017NZ5d\u0007>tg\r\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003\u0015\u0019Gn\\2l!\tas&D\u0001.\u0015\tq\u0003\"\u0001\u0003vi&d\u0017B\u0001\u0019.\u0005\u0015\u0019En\\2l\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0019a\u0014N\\5u}Q\u0019A'\u000e\u001c\u0011\u0005Y\u0001\u0001\"\u0002\u00112\u0001\u0004\u0011\u0003b\u0002\u00162!\u0003\u0005\ra\u000b\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0003Q\u0001(/\u001a4feJ,GmU3sm&\u001cWMT1nKV\t!\b\u0005\u0002<\u0005:\u0011A\b\u0011\t\u0003{Ei\u0011A\u0010\u0006\u0003\u007f\u0005\na\u0001\u0010:p_Rt\u0014BA!\u0012\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005\u000b\u0002B\u0002$\u0001A\u0003%!(A\u000bqe\u00164WM\u001d:fIN+'O^5dK:\u000bW.\u001a\u0011\t\u000f!\u0003!\u0019!C\u0005s\u0005\u0019\"/Z:pYZ,GmU3sm&\u001cWMT1nK\"1!\n\u0001Q\u0001\ni\nAC]3t_24X\rZ*feZL7-\u001a(b[\u0016\u0004\u0003b\u0002'\u0001\u0005\u0004%I!T\u0001\u000bIJLg/\u001a:Q_J$X#\u0001(\u0011\u0005Ay\u0015B\u0001)\u0012\u0005\rIe\u000e\u001e\u0005\u0007%\u0002\u0001\u000b\u0011\u0002(\u0002\u0017\u0011\u0014\u0018N^3s!>\u0014H\u000f\t\u0005\b)\u0002\u0011\r\u0011\"\u0003N\u0003Y!'/\u001b<fe\ncwnY6NC:\fw-\u001a:Q_J$\bB\u0002,\u0001A\u0003%a*A\fee&4XM\u001d\"m_\u000e\\W*\u00198bO\u0016\u0014\bk\u001c:uA!)\u0001\f\u0001C!3\u0006a1m\u001c8gS\u001e,(/\u001a)pIR\u0011!,\u0018\t\u0003GmK!\u0001\u0018\u0003\u0003\u0011M\u0003\u0018M]6Q_\u0012DQAX,A\u0002i\u000b1\u0001]8e\u0011\u0015\u0001\u0007\u0001\"\u0011b\u0003\u0001:W\r^!eI&$\u0018n\u001c8bYB{GmU=ti\u0016l\u0007K]8qKJ$\u0018.Z:\u0015\u0003\t\u0004BaO2;u%\u0011A\r\u0012\u0002\u0004\u001b\u0006\u0004\b\"\u00024\u0001\t\u0003:\u0017\u0001I4fi\u0006#G-\u001b;j_:\fGnS;cKJtW\r^3t%\u0016\u001cx.\u001e:dKN$\u0012\u0001\u001b\t\u0004S:\fhB\u00016m\u001d\ti4.C\u0001\u0013\u0013\ti\u0017#A\u0004qC\u000e\\\u0017mZ3\n\u0005=\u0004(aA*fc*\u0011Q.\u0005\t\u0003evl\u0011a\u001d\u0006\u0003iV\fQ!\\8eK2T!A^<\u0002\u0007\u0005\u0004\u0018N\u0003\u0002ys\u0006Q1.\u001e2fe:,G/Z:\u000b\u0005i\\\u0018a\u00024bEJL7\r\u000f\u0006\u0002y\u0006\u0011\u0011n\\\u0005\u0003}N\u00141\u0002S1t\u001b\u0016$\u0018\rZ1uC\u001eA\u0011\u0011\u0001\u0002\t\u0002!\t\u0019!\u0001\rEe&4XM]*feZL7-\u001a$fCR,(/Z*uKB\u00042AFA\u0003\r\u001d\t!\u0001#\u0001\t\u0003\u000f\u00192!!\u0002\u0010\u0011\u001d\u0011\u0014Q\u0001C\u0001\u0003\u0017!\"!a\u0001\t\u0013\u0005=\u0011Q\u0001b\u0001\n\u0003I\u0014a\u0006#S\u0013Z+%k\u0018\"J\u001d\u0012{\u0016\t\u0012#S\u000bN\u001bvlS#Z\u0011!\t\u0019\"!\u0002!\u0002\u0013Q\u0014\u0001\u0007#S\u0013Z+%k\u0018\"J\u001d\u0012{\u0016\t\u0012#S\u000bN\u001bvlS#ZA!I\u0011qCA\u0003\u0005\u0004%\t!O\u0001\u0010\tJKe+\u0012*`\u0011>\u001bFkX&F3\"A\u00111DA\u0003A\u0003%!(\u0001\tE%&3VIU0I\u001fN#vlS#ZA!Q\u0011qDA\u0003\u0005\u0004%\t!!\t\u0002%\u0011\u0013\u0016JV#S?N36i\u0018)P'R3\u0015\nW\u000b\u0003\u0003G\u0001B!!\n\u000205\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0003mC:<'BAA\u0017\u0003\u0011Q\u0017M^1\n\u0007\r\u000b9\u0003C\u0005\u00024\u0005\u0015\u0001\u0015!\u0003\u0002$\u0005\u0019BIU%W\u000bJ{6KV\"`!>\u001bFKR%YA!I\u0011qGA\u0003\u0005\u0004%\t!T\u0001\u0018\u001b\u0006CvlU#S-&\u001bUi\u0018(B\u001b\u0016{F*\u0012(H)\"C\u0001\"a\u000f\u0002\u0006\u0001\u0006IAT\u0001\u0019\u001b\u0006CvlU#S-&\u001bUi\u0018(B\u001b\u0016{F*\u0012(H)\"\u0003\u0003BCA \u0003\u000b\t\n\u0011\"\u0001\u0002B\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uII*\"!a\u0011+\u0007-\n)e\u000b\u0002\u0002HA!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013!C;oG\",7m[3e\u0015\r\t\t&E\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA+\u0003\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class DriverServiceFeatureStep
implements KubernetesFeatureConfigStep,
Logging {
    private final KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf;
    private final String preferredServiceName;
    private final String resolvedServiceName;
    private final int driverPort;
    private final int driverBlockManagerPort;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Clock $lessinit$greater$default$2() {
        return DriverServiceFeatureStep$.MODULE$.$lessinit$greater$default$2();
    }

    public static int MAX_SERVICE_NAME_LENGTH() {
        return DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH();
    }

    public static String DRIVER_SVC_POSTFIX() {
        return DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX();
    }

    public static String DRIVER_HOST_KEY() {
        return DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY();
    }

    public static String DRIVER_BIND_ADDRESS_KEY() {
        return DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private String preferredServiceName() {
        return this.preferredServiceName;
    }

    private String resolvedServiceName() {
        return this.resolvedServiceName;
    }

    private int driverPort() {
        return this.driverPort;
    }

    private int driverBlockManagerPort() {
        return this.driverBlockManagerPort;
    }

    @Override
    public SparkPod configurePod(SparkPod pod) {
        return pod;
    }

    @Override
    public Map<String, String> getAdditionalPodSystemProperties() {
        String driverHostname = new StringBuilder(5).append(this.resolvedServiceName()).append(".").append(this.kubernetesConf.namespace()).append(".svc").toString();
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()), (Object)driverHostname), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.driver.port"), (Object)((Object)BoxesRunTime.boxToInteger((int)this.driverPort())).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key()), (Object)((Object)BoxesRunTime.boxToInteger((int)this.driverBlockManagerPort())).toString())}));
    }

    @Override
    public Seq<HasMetadata> getAdditionalKubernetesResources() {
        Service driverService = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceSpecFluent.PortsNested)((ServiceSpecFluent)((ServiceSpecFluent.PortsNested)((ServiceFluentImpl)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(this.resolvedServiceName())).endMetadata()).withNewSpec().withClusterIP("None").withSelector((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(this.kubernetesConf.roleLabels()).asJava()).addNewPort().withName(Constants$.MODULE$.DRIVER_PORT_NAME()).withPort(Predef$.MODULE$.int2Integer(this.driverPort())).withNewTargetPort(Predef$.MODULE$.int2Integer(this.driverPort()))).endPort()).addNewPort().withName(Constants$.MODULE$.BLOCK_MANAGER_PORT_NAME()).withPort(Predef$.MODULE$.int2Integer(this.driverBlockManagerPort())).withNewTargetPort(Predef$.MODULE$.int2Integer(this.driverBlockManagerPort()))).endPort()).endSpec()).build();
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Service[]{driverService}));
    }

    public DriverServiceFeatureStep(KubernetesConf<KubernetesDriverSpecificConf> kubernetesConf, Clock clock) {
        String string;
        this.kubernetesConf = kubernetesConf;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(kubernetesConf.getOption(DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(117).append(DriverServiceFeatureStep$.MODULE$.DRIVER_BIND_ADDRESS_KEY()).append(" is not supported in Kubernetes mode, as the driver's bind ").append("address is managed and set to the driver pod's IP address.").toString());
        Predef$.MODULE$.require(kubernetesConf.getOption(DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()).isEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(104).append(DriverServiceFeatureStep$.MODULE$.DRIVER_HOST_KEY()).append(" is not supported in Kubernetes mode, as the driver's hostname will be ").append("managed via a Kubernetes service.").toString());
        this.preferredServiceName = new StringBuilder(0).append(kubernetesConf.appResourceNamePrefix()).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString();
        if (this.preferredServiceName().length() <= DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()) {
            string = this.preferredServiceName();
        } else {
            long randomServiceId = clock.getTimeMillis();
            String shorterServiceName = new StringBuilder(6).append("spark-").append(randomServiceId).append(DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX()).toString();
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Driver's hostname would preferably be ").append(this.preferredServiceName()).append(", but this is ").append(new StringBuilder(55).append("too long (must be <= ").append(DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()).append(" characters). Falling back to use ").toString()).append(new StringBuilder(30).append(shorterServiceName).append(" as the driver service's name.").toString()).toString());
            string = shorterServiceName;
        }
        this.resolvedServiceName = string;
        this.driverPort = kubernetesConf.sparkConf().getInt("spark.driver.port", Constants$.MODULE$.DEFAULT_DRIVER_PORT());
        this.driverBlockManagerPort = kubernetesConf.sparkConf().getInt(package$.MODULE$.DRIVER_BLOCK_MANAGER_PORT().key(), Constants$.MODULE$.DEFAULT_BLOCKMANAGER_PORT());
    }
}

