/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesDriverSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesExecutorSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesRoleSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpecificConf;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$;
import org.apache.spark.deploy.k8s.submit.JavaMainAppResource;
import org.apache.spark.deploy.k8s.submit.KubernetesClientApplication$;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.deploy.k8s.submit.NonJVMResource;
import org.apache.spark.deploy.k8s.submit.PythonMainAppResource;
import org.apache.spark.deploy.k8s.submit.RMainAppResource;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple11;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class KubernetesConf$
implements scala.Serializable {
    public static KubernetesConf$ MODULE$;

    static {
        new KubernetesConf$();
    }

    public KubernetesConf<KubernetesDriverSpecificConf> createDriverConf(SparkConf sparkConf, String appName, String appResourceNamePrefix, String appId, Option<MainAppResource> mainAppResource, String mainClass, String[] appArgs, Option<String> maybePyFiles) {
        SparkConf sparkConfWithMainAppJar = sparkConf.clone();
        ArrayBuffer additionalFiles = (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
        mainAppResource.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoxedUnit boxedUnit;
            MainAppResource mainAppResource = x0$1;
            if (mainAppResource instanceof JavaMainAppResource) {
                JavaMainAppResource javaMainAppResource = (JavaMainAppResource)mainAppResource;
                String res = javaMainAppResource.primaryResource();
                String[] previousJars = (String[])sparkConf.getOption("spark.jars").map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.split(",")).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
                boxedUnit = !new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])previousJars)).contains((Object)res) ? sparkConfWithMainAppJar.setJars((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])previousJars)).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{res})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))) : BoxedUnit.UNIT;
            } else if (mainAppResource instanceof NonJVMResource) {
                SparkConf sparkConf;
                MainAppResource mainAppResource2 = mainAppResource;
                MainAppResource mainAppResource3 = mainAppResource2;
                if (mainAppResource3 instanceof PythonMainAppResource) {
                    PythonMainAppResource pythonMainAppResource = (PythonMainAppResource)mainAppResource3;
                    String res = pythonMainAppResource.primaryResource();
                    additionalFiles.$plus$eq((Object)res);
                    maybePyFiles.foreach((Function1 & Serializable & scala.Serializable)maybePyFiles -> {
                        additionalFiles.appendAll((TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])maybePyFiles.split(","))));
                        return BoxedUnit.UNIT;
                    });
                    sparkConf = sparkConfWithMainAppJar.set(Config$.MODULE$.KUBERNETES_PYSPARK_MAIN_APP_RESOURCE(), (Object)res);
                } else if (mainAppResource3 instanceof RMainAppResource) {
                    RMainAppResource rMainAppResource = (RMainAppResource)mainAppResource3;
                    String res = rMainAppResource.primaryResource();
                    additionalFiles.$plus$eq((Object)res);
                    sparkConf = sparkConfWithMainAppJar.set(Config$.MODULE$.KUBERNETES_R_MAIN_APP_RESOURCE(), (Object)res);
                } else {
                    throw new MatchError((Object)mainAppResource3);
                }
                boxedUnit = sparkConfWithMainAppJar.setIfMissing(Config$.MODULE$.MEMORY_OVERHEAD_FACTOR(), (Object)BoxesRunTime.boxToDouble((double)0.4));
            } else {
                throw new MatchError((Object)mainAppResource);
            }
            return boxedUnit;
        });
        Map<String, String> driverCustomLabels = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_DRIVER_LABEL_PREFIX());
        Predef$.MODULE$.require(!driverCustomLabels.contains((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Label with key ").append(new StringBuilder(56).append(Constants$.MODULE$.SPARK_APP_ID_LABEL()).append(" is not allowed as it is reserved for Spark bookkeeping ").toString()).append("operations.").toString());
        Predef$.MODULE$.require(!driverCustomLabels.contains((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Label with key ").append(new StringBuilder(56).append(Constants$.MODULE$.SPARK_ROLE_LABEL()).append(" is not allowed as it is reserved for Spark bookkeeping ").toString()).append("operations.").toString());
        Map driverLabels = driverCustomLabels.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)appId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_DRIVER_ROLE())})));
        Map<String, String> driverAnnotations = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_DRIVER_ANNOTATION_PREFIX());
        Map<String, String> driverSecretNamesToMountPaths = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_DRIVER_SECRETS_PREFIX());
        Map<String, String> driverSecretEnvNamesToKeyRefs = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_DRIVER_SECRET_KEY_REF_PREFIX());
        Map<String, String> driverEnvs = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_DRIVER_ENV_PREFIX());
        Iterable driverVolumes = (Iterable)KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(sparkConf, Config$.MODULE$.KUBERNETES_DRIVER_VOLUMES_PREFIX()).map((Function1 & Serializable & scala.Serializable)x$4 -> (KubernetesVolumeSpec)x$4.get(), Iterable$.MODULE$.canBuildFrom());
        KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_VOLUMES_PREFIX()).map((Function1 & Serializable & scala.Serializable)x$5 -> (KubernetesVolumeSpec)x$5.get(), Iterable$.MODULE$.canBuildFrom());
        Seq sparkFiles = (Seq)((TraversableLike)sparkConf.getOption("spark.files").map((Function1 & Serializable & scala.Serializable)str -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])str.split(","))).toSeq()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Seq)Seq$.MODULE$.empty())).$plus$plus((GenTraversableOnce)additionalFiles, Seq$.MODULE$.canBuildFrom());
        return new KubernetesConf<KubernetesDriverSpecificConf>(sparkConfWithMainAppJar, new KubernetesDriverSpecificConf(mainAppResource, mainClass, appName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])appArgs)), appResourceNamePrefix, appId, (Map<String, String>)driverLabels, driverAnnotations, driverSecretNamesToMountPaths, driverSecretEnvNamesToKeyRefs, driverEnvs, (Iterable<KubernetesVolumeSpec<? extends KubernetesVolumeSpecificConf>>)driverVolumes, (Seq<String>)sparkFiles);
    }

    public KubernetesConf<KubernetesExecutorSpecificConf> createExecutorConf(SparkConf sparkConf, String executorId, String appId, Option<Pod> driverPod) {
        Map<String, String> executorCustomLabels = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_LABEL_PREFIX());
        Predef$.MODULE$.require(!executorCustomLabels.contains((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Custom executor labels cannot contain ").append(Constants$.MODULE$.SPARK_APP_ID_LABEL()).append(" as it is reserved for Spark.").toString());
        Predef$.MODULE$.require(!executorCustomLabels.contains((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Custom executor labels cannot contain ").append(Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()).append(" as it is reserved for").append(" Spark.").toString());
        Predef$.MODULE$.require(!executorCustomLabels.contains((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Custom executor labels cannot contain ").append(Constants$.MODULE$.SPARK_ROLE_LABEL()).append(" as it is reserved for Spark.").toString());
        Map executorLabels = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_EXECUTOR_ID_LABEL()), (Object)executorId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)appId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_EXECUTOR_ROLE())}))).$plus$plus(executorCustomLabels);
        Map<String, String> executorAnnotations = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_ANNOTATION_PREFIX());
        Map<String, String> executorMountSecrets = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_SECRETS_PREFIX());
        Map<String, String> executorEnvSecrets = KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_SECRET_KEY_REF_PREFIX());
        Map executorEnv = sparkConf.getExecutorEnv().toMap(Predef$.MODULE$.$conforms());
        Iterable executorVolumes = (Iterable)KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_VOLUMES_PREFIX()).map((Function1 & Serializable & scala.Serializable)x$6 -> (KubernetesVolumeSpec)x$6.get(), Iterable$.MODULE$.canBuildFrom());
        String appResourceNamePrefix = sparkConf.getOption(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX().key()).isEmpty() ? KubernetesClientApplication$.MODULE$.getResourceNamePrefix(KubernetesClientApplication$.MODULE$.getAppName(sparkConf)) : (String)sparkConf.get(Config$.MODULE$.KUBERNETES_EXECUTOR_POD_NAME_PREFIX());
        return new KubernetesConf<KubernetesExecutorSpecificConf>(sparkConf.clone(), new KubernetesExecutorSpecificConf(executorId, driverPod), appResourceNamePrefix, appId, (Map<String, String>)executorLabels, executorAnnotations, executorMountSecrets, executorEnvSecrets, (Map<String, String>)executorEnv, (Iterable<KubernetesVolumeSpec<? extends KubernetesVolumeSpecificConf>>)executorVolumes, (Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public <T extends KubernetesRoleSpecificConf> KubernetesConf<T> apply(SparkConf sparkConf, T roleSpecificConf, String appResourceNamePrefix, String appId, Map<String, String> roleLabels, Map<String, String> roleAnnotations, Map<String, String> roleSecretNamesToMountPaths, Map<String, String> roleSecretEnvNamesToKeyRefs, Map<String, String> roleEnvs, Iterable<KubernetesVolumeSpec<? extends KubernetesVolumeSpecificConf>> roleVolumes, Seq<String> sparkFiles) {
        return new KubernetesConf<T>(sparkConf, roleSpecificConf, appResourceNamePrefix, appId, roleLabels, roleAnnotations, roleSecretNamesToMountPaths, roleSecretEnvNamesToKeyRefs, roleEnvs, roleVolumes, sparkFiles);
    }

    public <T extends KubernetesRoleSpecificConf> Option<Tuple11<SparkConf, T, String, String, Map<String, String>, Map<String, String>, Map<String, String>, Map<String, String>, Map<String, String>, Iterable<KubernetesVolumeSpec<? extends KubernetesVolumeSpecificConf>>, Seq<String>>> unapply(KubernetesConf<T> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple11((Object)x$0.sparkConf(), x$0.roleSpecificConf(), (Object)x$0.appResourceNamePrefix(), (Object)x$0.appId(), x$0.roleLabels(), x$0.roleAnnotations(), x$0.roleSecretNamesToMountPaths(), x$0.roleSecretEnvNamesToKeyRefs(), x$0.roleEnvs(), x$0.roleVolumes(), x$0.sparkFiles()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private KubernetesConf$() {
        MODULE$ = this;
    }
}

