/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.service.cli.operation;

import java.io.CharArrayWriter;
import java.io.Writer;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.session.OperationLog;
import org.apache.hive.service.cli.CLIServiceUtils;
import org.apache.hive.service.cli.operation.OperationManager;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.StringLayout;
import org.apache.logging.log4j.core.appender.AbstractWriterAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.appender.WriterManager;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.message.Message;

public class LogDivertAppender
extends AbstractWriterAppender<WriterManager> {
    private static final Logger LOG = LogManager.getLogger((String)LogDivertAppender.class.getName());
    private final OperationManager operationManager;
    private boolean isVerbose;
    private final CharArrayWriter writer;

    private static StringLayout getLayout(boolean isVerbose, StringLayout lo) {
        if (isVerbose) {
            if (lo == null) {
                lo = CLIServiceUtils.verboseLayout;
                LOG.info("Cannot find a Layout from a ConsoleAppender. Using default Layout pattern.");
            }
        } else {
            lo = CLIServiceUtils.nonVerboseLayout;
        }
        return lo;
    }

    private static StringLayout initLayout(OperationLog.LoggingLevel loggingMode) {
        boolean isVerbose = loggingMode == OperationLog.LoggingLevel.VERBOSE;
        org.apache.logging.log4j.core.Logger root = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        StringLayout layout = null;
        Map appenders = root.getAppenders();
        for (Appender ap : appenders.values()) {
            Layout l;
            if (!ap.getClass().equals(ConsoleAppender.class) || !((l = ap.getLayout()) instanceof StringLayout)) continue;
            layout = (StringLayout)l;
            break;
        }
        return LogDivertAppender.getLayout(isVerbose, layout);
    }

    public static LogDivertAppender create(OperationManager operationManager, OperationLog.LoggingLevel loggingMode) {
        CharArrayWriter writer = new CharArrayWriter();
        return new LogDivertAppender(operationManager, loggingMode, writer);
    }

    private LogDivertAppender(OperationManager operationManager, OperationLog.LoggingLevel loggingMode, CharArrayWriter writer) {
        super("LogDivertAppender", LogDivertAppender.initLayout(loggingMode), null, false, true, Property.EMPTY_ARRAY, new WriterManager((Writer)writer, "LogDivertAppender", LogDivertAppender.initLayout(loggingMode), true));
        this.writer = writer;
        this.isVerbose = loggingMode == OperationLog.LoggingLevel.VERBOSE;
        this.operationManager = operationManager;
        this.addFilter(new NameFilter(loggingMode, operationManager));
    }

    public void append(LogEvent event) {
        OperationLog log = this.operationManager.getOperationLogByThread();
        if (log != null) {
            boolean isCurrModeVerbose;
            boolean bl = isCurrModeVerbose = log.getOpLoggingLevel() == OperationLog.LoggingLevel.VERBOSE;
            if (isCurrModeVerbose != this.isVerbose) {
                this.isVerbose = isCurrModeVerbose;
            }
        }
        super.append(event);
        String logOutput = this.writer.toString();
        this.writer.reset();
        if (log == null) {
            LOG.debug(" ---+++=== Dropped log event from thread " + event.getThreadName());
            return;
        }
        log.writeOperationLog(logOutput);
    }

    private static class NameFilter
    implements Filter {
        private Pattern namePattern;
        private OperationLog.LoggingLevel loggingMode;
        private OperationManager operationManager;
        private LifeCycle.State state;
        private static final Pattern verboseExcludeNamePattern = Pattern.compile(String.join((CharSequence)"|", LOG.getName(), OperationLog.class.getName(), OperationManager.class.getName()));
        private static final Pattern executionIncludeNamePattern = Pattern.compile(String.join((CharSequence)"|", "org.apache.hadoop.mapreduce.JobSubmitter", "org.apache.hadoop.mapreduce.Job", "SessionState", Task.class.getName(), "org.apache.hadoop.hive.ql.exec.spark.status.SparkJobMonitor"));
        private static final Pattern performanceIncludeNamePattern = Pattern.compile(executionIncludeNamePattern.pattern() + "|" + PerfLogger.class.getName());

        private void setCurrentNamePattern(OperationLog.LoggingLevel mode) {
            if (mode == OperationLog.LoggingLevel.VERBOSE) {
                this.namePattern = verboseExcludeNamePattern;
            } else if (mode == OperationLog.LoggingLevel.EXECUTION) {
                this.namePattern = executionIncludeNamePattern;
            } else if (mode == OperationLog.LoggingLevel.PERFORMANCE) {
                this.namePattern = performanceIncludeNamePattern;
            }
        }

        NameFilter(OperationLog.LoggingLevel loggingMode, OperationManager op) {
            this.operationManager = op;
            this.loggingMode = loggingMode;
            this.state = LifeCycle.State.INITIALIZING;
            this.setCurrentNamePattern(loggingMode);
        }

        public Filter.Result getOnMismatch() {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result getOnMatch() {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String s, Object ... objects) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String s, Object o) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String s, Object o, Object o1) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, String s, Object o, Object o1, Object o2, Object o3, Object o4, Object o5, Object o6, Object o7, Object o8, Object o9) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Object o, Throwable throwable) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(org.apache.logging.log4j.core.Logger logger, Level level, Marker marker, Message message, Throwable throwable) {
            return Filter.Result.NEUTRAL;
        }

        public Filter.Result filter(LogEvent logEvent) {
            boolean isMatch;
            boolean excludeMatches;
            OperationLog log = this.operationManager.getOperationLogByThread();
            boolean bl = excludeMatches = this.loggingMode == OperationLog.LoggingLevel.VERBOSE;
            if (log == null) {
                return Filter.Result.DENY;
            }
            OperationLog.LoggingLevel currentLoggingMode = log.getOpLoggingLevel();
            if (currentLoggingMode == OperationLog.LoggingLevel.NONE) {
                return Filter.Result.DENY;
            }
            if (currentLoggingMode != this.loggingMode) {
                this.loggingMode = currentLoggingMode;
                this.setCurrentNamePattern(this.loggingMode);
            }
            if (excludeMatches == (isMatch = this.namePattern.matcher(logEvent.getLoggerName()).matches())) {
                return Filter.Result.DENY;
            }
            return Filter.Result.NEUTRAL;
        }

        public LifeCycle.State getState() {
            return this.state;
        }

        public void initialize() {
            this.state = LifeCycle.State.INITIALIZED;
        }

        public void start() {
            this.state = LifeCycle.State.STARTED;
        }

        public void stop() {
            this.state = LifeCycle.State.STOPPED;
        }

        public boolean isStarted() {
            return this.state == LifeCycle.State.STARTED;
        }

        public boolean isStopped() {
            return this.state == LifeCycle.State.STOPPED;
        }
    }
}

