/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.planner;

import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.common.LiteralValueProtoConverter$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class LiteralExpressionProtoConverter$ {
    public static final LiteralExpressionProtoConverter$ MODULE$ = new LiteralExpressionProtoConverter$();

    public Literal toCatalystExpression(Expression.Literal lit) {
        Expression.Literal.LiteralTypeCase literalTypeCase = lit.getLiteralTypeCase();
        if (Expression.Literal.LiteralTypeCase.NULL.equals(literalTypeCase)) {
            return new Literal(null, DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getNull()));
        }
        if (Expression.Literal.LiteralTypeCase.BINARY.equals(literalTypeCase)) {
            return new Literal((Object)lit.getBinary().toByteArray(), (DataType)BinaryType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.BOOLEAN.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToBoolean((boolean)lit.getBoolean()), (DataType)BooleanType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.BYTE.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToByte((byte)((byte)lit.getByte())), (DataType)ByteType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.SHORT.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToShort((short)((short)lit.getShort())), (DataType)ShortType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.INTEGER.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToInteger((int)lit.getInteger()), (DataType)IntegerType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.LONG.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToLong((long)lit.getLong()), (DataType)LongType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.FLOAT.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToFloat((float)lit.getFloat()), (DataType)FloatType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.DOUBLE.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToDouble((double)lit.getDouble()), (DataType)DoubleType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.DECIMAL.equals(literalTypeCase)) {
            Decimal decimal = Decimal$.MODULE$.apply(lit.getDecimal().getValue());
            int precision = decimal.precision();
            if (lit.getDecimal().hasPrecision()) {
                precision = package$.MODULE$.max(precision, lit.getDecimal().getPrecision());
            }
            int scale = decimal.scale();
            if (lit.getDecimal().hasScale()) {
                scale = package$.MODULE$.max(scale, lit.getDecimal().getScale());
            }
            return new Literal((Object)decimal, (DataType)new DecimalType(package$.MODULE$.max(precision, scale), scale));
        }
        if (Expression.Literal.LiteralTypeCase.STRING.equals(literalTypeCase)) {
            return new Literal((Object)UTF8String.fromString((String)lit.getString()), (DataType)StringType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.DATE.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToInteger((int)lit.getDate()), (DataType)DateType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.TIMESTAMP.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToLong((long)lit.getTimestamp()), (DataType)TimestampType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.TIMESTAMP_NTZ.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToLong((long)lit.getTimestampNtz()), (DataType)TimestampNTZType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.CALENDAR_INTERVAL.equals(literalTypeCase)) {
            CalendarInterval interval = new CalendarInterval(lit.getCalendarInterval().getMonths(), lit.getCalendarInterval().getDays(), lit.getCalendarInterval().getMicroseconds());
            return new Literal((Object)interval, (DataType)CalendarIntervalType$.MODULE$);
        }
        if (Expression.Literal.LiteralTypeCase.YEAR_MONTH_INTERVAL.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToInteger((int)lit.getYearMonthInterval()), (DataType)YearMonthIntervalType$.MODULE$.apply());
        }
        if (Expression.Literal.LiteralTypeCase.DAY_TIME_INTERVAL.equals(literalTypeCase)) {
            return new Literal((Object)BoxesRunTime.boxToLong((long)lit.getDayTimeInterval()), (DataType)DayTimeIntervalType$.MODULE$.apply());
        }
        if (Expression.Literal.LiteralTypeCase.ARRAY.equals(literalTypeCase)) {
            return Literal$.MODULE$.create(LiteralValueProtoConverter$.MODULE$.toCatalystArray(lit.getArray()), (DataType)ArrayType$.MODULE$.apply(DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getArray().getElementType())));
        }
        if (Expression.Literal.LiteralTypeCase.MAP.equals(literalTypeCase)) {
            return Literal$.MODULE$.create(LiteralValueProtoConverter$.MODULE$.toCatalystMap(lit.getMap()), (DataType)MapType$.MODULE$.apply(DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getMap().getKeyType()), DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getMap().getValueType())));
        }
        if (Expression.Literal.LiteralTypeCase.STRUCT.equals(literalTypeCase)) {
            DataType dataType = DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getStruct().getStructType());
            Object structData = LiteralValueProtoConverter$.MODULE$.toCatalystStruct(lit.getStruct());
            Function1 convert = CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType);
            return new Literal(convert.apply(structData), dataType);
        }
        throw InvalidPlanInput$.MODULE$.apply("Unsupported Literal Type: " + lit.getLiteralTypeCase().getNumber() + "(" + lit.getLiteralTypeCase().name() + ")");
    }

    private LiteralExpressionProtoConverter$() {
    }
}

