/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.config;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.OptionalConfigEntry;
import org.apache.spark.network.util.ByteUnit;
import org.apache.spark.sql.connect.common.config.ConnectCommon$;
import org.apache.spark.sql.internal.SQLConf$;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;

public final class Connect$ {
    public static final Connect$ MODULE$ = new Connect$();
    private static final OptionalConfigEntry<String> CONNECT_GRPC_BINDING_ADDRESS = SQLConf$.MODULE$.buildStaticConf("spark.connect.grpc.binding.address").doc("The address for Spark Connect server to bind.").version("4.0.0").stringConf().createOptional();
    private static final ConfigEntry<Object> CONNECT_GRPC_BINDING_PORT = SQLConf$.MODULE$.buildStaticConf("spark.connect.grpc.binding.port").doc("The port for Spark Connect server to bind.").version("3.4.0").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)ConnectCommon$.MODULE$.CONNECT_GRPC_BINDING_PORT()));
    private static final ConfigEntry<Object> CONNECT_GRPC_PORT_MAX_RETRIES = SQLConf$.MODULE$.buildStaticConf("spark.connect.grpc.port.maxRetries").doc("The max port retry attempts for the gRPC server binding.By default, it's set to 0, and the server will fail fast in case of port conflicts.").version("4.0.0").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)ConnectCommon$.MODULE$.CONNECT_GRPC_PORT_MAX_RETRIES()));
    private static final OptionalConfigEntry<String> CONNECT_GRPC_INTERCEPTOR_CLASSES = SQLConf$.MODULE$.buildStaticConf("spark.connect.grpc.interceptor.classes").doc("Comma separated list of class names that must implement the io.grpc.ServerInterceptor interface.").version("3.4.0").stringConf().createOptional();
    private static final ConfigEntry<Object> CONNECT_GRPC_ARROW_MAX_BATCH_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.connect.grpc.arrow.maxBatchSize").doc("When using Apache Arrow, limit the maximum size of one arrow batch, in bytes unless otherwise specified, that can be sent from server side to client side. Currently, we conservatively use 70% of it because the size is not accurate but estimated.").version("3.4.0").bytesConf(ByteUnit.BYTE).createWithDefault((Object)BoxesRunTime.boxToLong((long)ConnectCommon$.MODULE$.CONNECT_GRPC_MAX_MESSAGE_SIZE()));
    private static final ConfigEntry<Object> CONNECT_GRPC_MAX_INBOUND_MESSAGE_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.connect.grpc.maxInboundMessageSize").doc("Sets the maximum inbound message in bytes size for the gRPC requests.Requests with a larger payload will fail.").version("3.4.0").bytesConf(ByteUnit.BYTE).createWithDefault((Object)BoxesRunTime.boxToLong((long)ConnectCommon$.MODULE$.CONNECT_GRPC_MAX_MESSAGE_SIZE()));
    private static final ConfigEntry<Object> CONNECT_GRPC_MARSHALLER_RECURSION_LIMIT = SQLConf$.MODULE$.buildStaticConf("spark.connect.grpc.marshallerRecursionLimit").internal().doc(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |Sets the recursion limit to grpc protobuf messages.\n          |"))).version("3.5.0").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)ConnectCommon$.MODULE$.CONNECT_GRPC_MARSHALLER_RECURSION_LIMIT()));
    private static final ConfigEntry<Object> CONNECT_SESSION_MANAGER_DEFAULT_SESSION_TIMEOUT = SQLConf$.MODULE$.buildStaticConf("spark.connect.session.manager.defaultSessionTimeout").internal().doc("Timeout after which sessions without any new incoming RPC will be removed. Setting it to -1 indicates that sessions should be kept forever.").version("4.0.0").timeConf(TimeUnit.MILLISECONDS).createWithDefaultString("60m");
    private static final ConfigEntry<Object> CONNECT_SESSION_MANAGER_CLOSED_SESSIONS_TOMBSTONES_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.connect.session.manager.closedSessionsTombstonesSize").internal().doc("Maximum size of the cache of sessions after which sessions that did not receive any requests will be removed.").version("4.0.0").intConf().createWithDefaultString("1000");
    private static final ConfigEntry<Object> CONNECT_SESSION_MANAGER_MAINTENANCE_INTERVAL = SQLConf$.MODULE$.buildStaticConf("spark.connect.session.manager.maintenanceInterval").internal().doc("Interval at which session manager will search for expired sessions to remove.").version("4.0.0").timeConf(TimeUnit.MILLISECONDS).createWithDefaultString("30s");
    private static final ConfigEntry<Object> CONNECT_EXECUTE_MANAGER_DETACHED_TIMEOUT = SQLConf$.MODULE$.buildStaticConf("spark.connect.execute.manager.detachedTimeout").internal().doc("Timeout after which executions without an attached RPC will be removed.").version("3.5.0").timeConf(TimeUnit.MILLISECONDS).createWithDefaultString("5m");
    private static final ConfigEntry<Object> CONNECT_EXECUTE_MANAGER_MAINTENANCE_INTERVAL = SQLConf$.MODULE$.buildStaticConf("spark.connect.execute.manager.maintenanceInterval").internal().doc("Interval at which execution manager will search for abandoned executions to remove.").version("3.5.0").timeConf(TimeUnit.MILLISECONDS).createWithDefaultString("30s");
    private static final ConfigEntry<Object> CONNECT_EXECUTE_MANAGER_ABANDONED_TOMBSTONES_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.connect.execute.manager.abandonedTombstonesSize").internal().doc("Maximum size of the cache of abandoned executions.").version("3.5.0").intConf().createWithDefaultString("10000");
    private static final ConfigEntry<Object> CONNECT_EXECUTE_REATTACHABLE_ENABLED = SQLConf$.MODULE$.buildStaticConf("spark.connect.execute.reattachable.enabled").internal().doc("Enables reattachable execution on the server. If disabled and a client requests it, non-reattachable execution will follow and should run until query completion. This will work, unless there is a GRPC stream error, in which case the client will discover that execution is not reattachable when trying to reattach fails.").version("3.5.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
    private static final ConfigEntry<Object> CONNECT_EXECUTE_REATTACHABLE_SENDER_MAX_STREAM_DURATION = SQLConf$.MODULE$.buildStaticConf("spark.connect.execute.reattachable.senderMaxStreamDuration").internal().doc("For reattachable execution, after this amount of time the response stream will be automatically completed and client needs to send a new ReattachExecute RPC to continue. Set to 0 for unlimited.").version("3.5.0").timeConf(TimeUnit.MILLISECONDS).createWithDefaultString("2m");
    private static final ConfigEntry<Object> CONNECT_EXECUTE_REATTACHABLE_SENDER_MAX_STREAM_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.connect.execute.reattachable.senderMaxStreamSize").internal().doc("For reattachable execution, after total responses size exceeds this value, the response stream will be automatically completed and client needs to send a new ReattachExecute RPC to continue. Set to 0 for unlimited.").version("3.5.0").bytesConf(ByteUnit.BYTE).createWithDefaultString("1g");
    private static final ConfigEntry<Object> CONNECT_EXECUTE_REATTACHABLE_OBSERVER_RETRY_BUFFER_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.connect.execute.reattachable.observerRetryBufferSize").internal().doc("For reattachable execution, the total size of responses that were already sent to be kept in the buffer in case of connection error and client needing to retry. Set 0 to don't buffer anything (even last sent response).With any value greater than 0, the last sent response will always be buffered.").version("3.5.0").bytesConf(ByteUnit.BYTE).createWithDefaultString("10m");
    private static final ConfigEntry<Seq<String>> CONNECT_EXTENSIONS_RELATION_CLASSES = SQLConf$.MODULE$.buildStaticConf("spark.connect.extensions.relation.classes").doc(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |Comma separated list of classes that implement the trait\n          |org.apache.spark.sql.connect.plugin.RelationPlugin to support custom\n          |Relation types in proto.\n          |"))).version("3.4.0").stringConf().toSequence().createWithDefault((Object)Nil$.MODULE$);
    private static final ConfigEntry<Seq<String>> CONNECT_EXTENSIONS_EXPRESSION_CLASSES = SQLConf$.MODULE$.buildStaticConf("spark.connect.extensions.expression.classes").doc(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |Comma separated list of classes that implement the trait\n          |org.apache.spark.sql.connect.plugin.ExpressionPlugin to support custom\n          |Expression types in proto.\n          |"))).version("3.4.0").stringConf().toSequence().createWithDefault((Object)Nil$.MODULE$);
    private static final ConfigEntry<Seq<String>> CONNECT_EXTENSIONS_COMMAND_CLASSES = SQLConf$.MODULE$.buildStaticConf("spark.connect.extensions.command.classes").doc(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |Comma separated list of classes that implement the trait\n             |org.apache.spark.sql.connect.plugin.CommandPlugin to support custom\n             |Command types in proto.\n             |"))).version("3.4.0").stringConf().toSequence().createWithDefault((Object)Nil$.MODULE$);
    private static final ConfigEntry<Seq<String>> CONNECT_ML_BACKEND_CLASSES = SQLConf$.MODULE$.buildConf("spark.connect.ml.backend.classes").doc(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |Comma separated list of classes that implement the trait\n             |org.apache.spark.sql.connect.plugin.MLBackendPlugin to replace the\n             |specified Spark ML operators with a backend-specific implementation.\n             |"))).version("4.0.0").stringConf().toSequence().createWithDefault((Object)Nil$.MODULE$);
    private static final ConfigEntry<Object> CONNECT_JVM_STACK_TRACE_MAX_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.connect.jvmStacktrace.maxSize").doc(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |Sets the maximum stack trace size to display when\n          |`spark.sql.pyspark.jvmStacktrace.enabled` is true.\n          |"))).version("3.5.0").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)1024));
    private static final ConfigEntry<Object> CONNECT_UI_STATEMENT_LIMIT = SQLConf$.MODULE$.buildStaticConf("spark.sql.connect.ui.retainedStatements").doc("The number of statements kept in the Spark Connect UI history.").version("3.5.0").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)200));
    private static final ConfigEntry<Object> CONNECT_COPY_FROM_LOCAL_TO_FS_ALLOW_DEST_LOCAL = SQLConf$.MODULE$.buildStaticConf("spark.connect.copyFromLocalToFs.allowDestLocal").internal().doc(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n             |(Deprecated since Spark 4.0, please set\n             |'" + SQLConf$.MODULE$.ARTIFACT_COPY_FROM_LOCAL_TO_FS_ALLOW_DEST_LOCAL().key() + "' instead.\n             |"))).version("3.5.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)false));
    private static final ConfigEntry<Object> CONNECT_UI_SESSION_LIMIT = SQLConf$.MODULE$.buildStaticConf("spark.sql.connect.ui.retainedSessions").doc("The number of client sessions kept in the Spark Connect UI history.").version("3.5.0").intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)200));
    private static final ConfigEntry<Object> CONNECT_ENRICH_ERROR_ENABLED = SQLConf$.MODULE$.buildConf("spark.sql.connect.enrichError.enabled").doc(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |When true, it enriches errors with full exception messages and optionally server-side\n          |stacktrace on the client side via an additional RPC.\n          |"))).version("4.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
    private static final ConfigEntry<Object> CONNECT_SERVER_STACKTRACE_ENABLED = SQLConf$.MODULE$.buildConf("spark.sql.connect.serverStacktrace.enabled").doc("When true, it sets the server-side stacktrace in the user-facing Spark exception.").version("4.0.0").booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
    private static final ConfigEntry<Object> CONNECT_GRPC_MAX_METADATA_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.connect.grpc.maxMetadataSize").doc("Sets the maximum size of metadata fields. For instance, it restricts metadata fields in `ErrorInfo`.").version("4.0.0").bytesConf(ByteUnit.BYTE).createWithDefault((Object)BoxesRunTime.boxToLong((long)1024L));
    private static final ConfigEntry<Object> CONNECT_PROGRESS_REPORT_INTERVAL = SQLConf$.MODULE$.buildConf("spark.connect.progress.reportInterval").doc("The interval at which the progress of a query is reported to the client. If the value is set to a negative value the progress reports will be disabled.").version("4.0.0").timeConf(TimeUnit.MILLISECONDS).createWithDefaultString("2s");
    private static final ConfigEntry<Object> CONNECT_SESSION_PLAN_CACHE_SIZE = SQLConf$.MODULE$.buildStaticConf("spark.connect.session.planCache.maxSize").doc("Sets the maximum number of cached resolved logical plans in Spark Connect Session. If set to a value less or equal than zero will disable the plan cache.").version("4.0.0").internal().intConf().createWithDefault((Object)BoxesRunTime.boxToInteger((int)16));
    private static final ConfigEntry<Object> CONNECT_SESSION_PLAN_CACHE_ENABLED = SQLConf$.MODULE$.buildConf("spark.connect.session.planCache.enabled").doc("When true, the cache of resolved logical plans is enabled if '" + MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE().key() + "' is greater than zero. When false, the cache is disabled even if '" + MODULE$.CONNECT_SESSION_PLAN_CACHE_SIZE().key() + "' is greater than zero. The caching is best-effort and not guaranteed.").version("4.0.0").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
    private static final OptionalConfigEntry<String> CONNECT_AUTHENTICATE_TOKEN = SQLConf$.MODULE$.buildStaticConf("spark.connect.authenticate.token").doc("A pre-shared token that will be used to authenticate clients. This secret must be passed as a bearer token by for clients to connect.").version("4.0.0").internal().stringConf().createOptional();
    private static final String CONNECT_AUTHENTICATE_TOKEN_ENV = "SPARK_CONNECT_AUTHENTICATE_TOKEN";
    private static final ConfigEntry<Object> CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_ENABLED = SQLConf$.MODULE$.buildConf("spark.connect.session.connectML.mlCache.memoryControl.enabled").doc("Enables ML cache memory control, it includes offloading model to disk, limiting model size, and limiting per-session ML cache size.").version("4.1.0").internal().booleanConf().createWithDefault((Object)BoxesRunTime.boxToBoolean((boolean)true));
    private static final ConfigEntry<Object> CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_IN_MEMORY_SIZE = SQLConf$.MODULE$.buildConf("spark.connect.session.connectML.mlCache.memoryControl.maxInMemorySize").doc("Maximum in-memory size of the MLCache per session. The cache will offload the least recently used models to Spark driver local disk if the size exceeds this limit. The size is in bytes.").version("4.1.0").internal().bytesConf(ByteUnit.BYTE).createWithDefault((Object)BoxesRunTime.boxToLong((long)(Runtime.getRuntime().maxMemory() / 4L)));
    private static final ConfigEntry<Object> CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_OFFLOADING_TIMEOUT = SQLConf$.MODULE$.buildConf("spark.connect.session.connectML.mlCache.memoryControl.offloadingTimeout").doc("Timeout of model offloading in MLCache. Models will be offloaded to Spark driver local disk if they are not used for this amount of time. The timeout is in minutes.").version("4.1.0").internal().timeConf(TimeUnit.MINUTES).createWithDefault((Object)BoxesRunTime.boxToLong((long)15L));
    private static final ConfigEntry<Object> CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_MODEL_SIZE = SQLConf$.MODULE$.buildConf("spark.connect.session.connectML.mlCache.memoryControl.maxModelSize").doc("Maximum size of a single SparkML model. The size is in bytes.").version("4.1.0").internal().bytesConf(ByteUnit.BYTE).createWithDefaultString("1g");
    private static final ConfigEntry<Object> CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_STORAGE_SIZE = SQLConf$.MODULE$.buildConf("spark.connect.session.connectML.mlCache.memoryControl.maxStorageSize").doc("Maximum total size (including in-memory and offloaded data) of the ml cache. The size is in bytes.").version("4.1.0").internal().bytesConf(ByteUnit.BYTE).createWithDefaultString("10g");

    public OptionalConfigEntry<String> CONNECT_GRPC_BINDING_ADDRESS() {
        return CONNECT_GRPC_BINDING_ADDRESS;
    }

    public ConfigEntry<Object> CONNECT_GRPC_BINDING_PORT() {
        return CONNECT_GRPC_BINDING_PORT;
    }

    public ConfigEntry<Object> CONNECT_GRPC_PORT_MAX_RETRIES() {
        return CONNECT_GRPC_PORT_MAX_RETRIES;
    }

    public OptionalConfigEntry<String> CONNECT_GRPC_INTERCEPTOR_CLASSES() {
        return CONNECT_GRPC_INTERCEPTOR_CLASSES;
    }

    public ConfigEntry<Object> CONNECT_GRPC_ARROW_MAX_BATCH_SIZE() {
        return CONNECT_GRPC_ARROW_MAX_BATCH_SIZE;
    }

    public ConfigEntry<Object> CONNECT_GRPC_MAX_INBOUND_MESSAGE_SIZE() {
        return CONNECT_GRPC_MAX_INBOUND_MESSAGE_SIZE;
    }

    public ConfigEntry<Object> CONNECT_GRPC_MARSHALLER_RECURSION_LIMIT() {
        return CONNECT_GRPC_MARSHALLER_RECURSION_LIMIT;
    }

    public ConfigEntry<Object> CONNECT_SESSION_MANAGER_DEFAULT_SESSION_TIMEOUT() {
        return CONNECT_SESSION_MANAGER_DEFAULT_SESSION_TIMEOUT;
    }

    public ConfigEntry<Object> CONNECT_SESSION_MANAGER_CLOSED_SESSIONS_TOMBSTONES_SIZE() {
        return CONNECT_SESSION_MANAGER_CLOSED_SESSIONS_TOMBSTONES_SIZE;
    }

    public ConfigEntry<Object> CONNECT_SESSION_MANAGER_MAINTENANCE_INTERVAL() {
        return CONNECT_SESSION_MANAGER_MAINTENANCE_INTERVAL;
    }

    public ConfigEntry<Object> CONNECT_EXECUTE_MANAGER_DETACHED_TIMEOUT() {
        return CONNECT_EXECUTE_MANAGER_DETACHED_TIMEOUT;
    }

    public ConfigEntry<Object> CONNECT_EXECUTE_MANAGER_MAINTENANCE_INTERVAL() {
        return CONNECT_EXECUTE_MANAGER_MAINTENANCE_INTERVAL;
    }

    public ConfigEntry<Object> CONNECT_EXECUTE_MANAGER_ABANDONED_TOMBSTONES_SIZE() {
        return CONNECT_EXECUTE_MANAGER_ABANDONED_TOMBSTONES_SIZE;
    }

    public ConfigEntry<Object> CONNECT_EXECUTE_REATTACHABLE_ENABLED() {
        return CONNECT_EXECUTE_REATTACHABLE_ENABLED;
    }

    public ConfigEntry<Object> CONNECT_EXECUTE_REATTACHABLE_SENDER_MAX_STREAM_DURATION() {
        return CONNECT_EXECUTE_REATTACHABLE_SENDER_MAX_STREAM_DURATION;
    }

    public ConfigEntry<Object> CONNECT_EXECUTE_REATTACHABLE_SENDER_MAX_STREAM_SIZE() {
        return CONNECT_EXECUTE_REATTACHABLE_SENDER_MAX_STREAM_SIZE;
    }

    public ConfigEntry<Object> CONNECT_EXECUTE_REATTACHABLE_OBSERVER_RETRY_BUFFER_SIZE() {
        return CONNECT_EXECUTE_REATTACHABLE_OBSERVER_RETRY_BUFFER_SIZE;
    }

    public ConfigEntry<Seq<String>> CONNECT_EXTENSIONS_RELATION_CLASSES() {
        return CONNECT_EXTENSIONS_RELATION_CLASSES;
    }

    public ConfigEntry<Seq<String>> CONNECT_EXTENSIONS_EXPRESSION_CLASSES() {
        return CONNECT_EXTENSIONS_EXPRESSION_CLASSES;
    }

    public ConfigEntry<Seq<String>> CONNECT_EXTENSIONS_COMMAND_CLASSES() {
        return CONNECT_EXTENSIONS_COMMAND_CLASSES;
    }

    public ConfigEntry<Seq<String>> CONNECT_ML_BACKEND_CLASSES() {
        return CONNECT_ML_BACKEND_CLASSES;
    }

    public ConfigEntry<Object> CONNECT_JVM_STACK_TRACE_MAX_SIZE() {
        return CONNECT_JVM_STACK_TRACE_MAX_SIZE;
    }

    public ConfigEntry<Object> CONNECT_UI_STATEMENT_LIMIT() {
        return CONNECT_UI_STATEMENT_LIMIT;
    }

    public ConfigEntry<Object> CONNECT_COPY_FROM_LOCAL_TO_FS_ALLOW_DEST_LOCAL() {
        return CONNECT_COPY_FROM_LOCAL_TO_FS_ALLOW_DEST_LOCAL;
    }

    public ConfigEntry<Object> CONNECT_UI_SESSION_LIMIT() {
        return CONNECT_UI_SESSION_LIMIT;
    }

    public ConfigEntry<Object> CONNECT_ENRICH_ERROR_ENABLED() {
        return CONNECT_ENRICH_ERROR_ENABLED;
    }

    public ConfigEntry<Object> CONNECT_SERVER_STACKTRACE_ENABLED() {
        return CONNECT_SERVER_STACKTRACE_ENABLED;
    }

    public ConfigEntry<Object> CONNECT_GRPC_MAX_METADATA_SIZE() {
        return CONNECT_GRPC_MAX_METADATA_SIZE;
    }

    public ConfigEntry<Object> CONNECT_PROGRESS_REPORT_INTERVAL() {
        return CONNECT_PROGRESS_REPORT_INTERVAL;
    }

    public ConfigEntry<Object> CONNECT_SESSION_PLAN_CACHE_SIZE() {
        return CONNECT_SESSION_PLAN_CACHE_SIZE;
    }

    public ConfigEntry<Object> CONNECT_SESSION_PLAN_CACHE_ENABLED() {
        return CONNECT_SESSION_PLAN_CACHE_ENABLED;
    }

    public OptionalConfigEntry<String> CONNECT_AUTHENTICATE_TOKEN() {
        return CONNECT_AUTHENTICATE_TOKEN;
    }

    public String CONNECT_AUTHENTICATE_TOKEN_ENV() {
        return CONNECT_AUTHENTICATE_TOKEN_ENV;
    }

    public Option<String> getAuthenticateToken() {
        return ((Option)SparkEnv$.MODULE$.get().conf().get(this.CONNECT_AUTHENTICATE_TOKEN())).orElse((Function0 & Serializable)() -> Option$.MODULE$.apply((Object)System.getenv().get(MODULE$.CONNECT_AUTHENTICATE_TOKEN_ENV())));
    }

    public ConfigEntry<Object> CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_ENABLED() {
        return CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_ENABLED;
    }

    public ConfigEntry<Object> CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_IN_MEMORY_SIZE() {
        return CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_IN_MEMORY_SIZE;
    }

    public ConfigEntry<Object> CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_OFFLOADING_TIMEOUT() {
        return CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_OFFLOADING_TIMEOUT;
    }

    public ConfigEntry<Object> CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_MODEL_SIZE() {
        return CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_MODEL_SIZE;
    }

    public ConfigEntry<Object> CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_STORAGE_SIZE() {
        return CONNECT_SESSION_CONNECT_ML_CACHE_MEMORY_CONTROL_MAX_STORAGE_SIZE;
    }

    private Connect$() {
    }
}

