/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.gson.internal.sql;

import java.io.IOException;
import java.sql.Time;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.sparkproject.connect.gson.Gson;
import org.sparkproject.connect.gson.JsonSyntaxException;
import org.sparkproject.connect.gson.TypeAdapter;
import org.sparkproject.connect.gson.TypeAdapterFactory;
import org.sparkproject.connect.gson.reflect.TypeToken;
import org.sparkproject.connect.gson.stream.JsonReader;
import org.sparkproject.connect.gson.stream.JsonToken;
import org.sparkproject.connect.gson.stream.JsonWriter;

final class SqlTimeTypeAdapter
extends TypeAdapter<Time> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == Time.class ? new SqlTimeTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("hh:mm:ss a");

    private SqlTimeTypeAdapter() {
    }

    @Override
    public synchronized Time read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        try {
            Date date = this.format.parse(in.nextString());
            return new Time(date.getTime());
        }
        catch (ParseException e) {
            throw new JsonSyntaxException(e);
        }
    }

    @Override
    public synchronized void write(JsonWriter out, Time value) throws IOException {
        out.value(value == null ? null : this.format.format(value));
    }
}

