/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.ui;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.Status$;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerJobStart;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.ExecuteJobTag$;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationAnalyzed;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationCanceled;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationClosed;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationFailed;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationFinished;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationReadyForExecution;
import org.apache.spark.sql.connect.service.SparkListenerConnectOperationStarted;
import org.apache.spark.sql.connect.service.SparkListenerConnectSessionClosed;
import org.apache.spark.sql.connect.service.SparkListenerConnectSessionStarted;
import org.apache.spark.sql.connect.ui.ExecutionInfo;
import org.apache.spark.sql.connect.ui.ExecutionState$;
import org.apache.spark.sql.connect.ui.LiveExecutionData;
import org.apache.spark.sql.connect.ui.LiveSessionData;
import org.apache.spark.sql.connect.ui.SessionInfo;
import org.apache.spark.sql.connect.ui.SparkConnectServerListener$;
import org.apache.spark.sql.execution.ui.SparkListenerSQLExecutionStart;
import org.apache.spark.status.ElementTrackingStore;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.status.LiveEntity;
import org.apache.spark.util.kvstore.KVStoreView;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.LinkedHashMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\rd!B\u0015+\u000112\u0004\u0002C\"\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011-\u0003!\u0011!Q\u0001\n1C\u0001\u0002\u0015\u0001\u0003\u0002\u0003\u0006I!\u0015\u0005\u0006/\u0002!\t\u0001\u0017\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0011\u00191\b\u0001)A\u0005A\"9q\u000f\u0001b\u0001\n\u0013A\bBB?\u0001A\u0003%\u0011\u0010\u0003\u0006\u007f\u0001A\u0005\t1!Q\u0001\n}D\u0011\"a\u0003\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u000bA\u0011\"!\u0005\u0001\u0005\u0004%I!!\u0004\t\u0011\u0005M\u0001\u0001)A\u0005\u0003\u000bA\u0011\"!\u0006\u0001\u0005\u0004%I!a\u0006\t\u0011\u0005}\u0001\u0001)A\u0005\u00033A\u0001\"!\t\u0001\t\u0003a\u00131\u0005\u0005\b\u0003K\u0001A\u0011IA\u0014\u0011\u001d\tI\u0004\u0001C!\u0003wAq!a\u0012\u0001\t\u0003\tI\u0005C\u0004\u0002^\u0001!I!a\u0018\t\u000f\u0005=\u0004\u0001\"\u0003\u0002r!9\u00111\u0010\u0001\u0005\n\u0005u\u0004bBAD\u0001\u0011%\u0011\u0011\u0012\u0005\b\u0003'\u0003A\u0011BAK\u0011\u001d\ty\n\u0001C\u0005\u0003CCq!a+\u0001\t\u0013\ti\u000bC\u0004\u0002>\u0002!I!a0\t\u000f\u0005%\u0007\u0001\"\u0003\u0002L\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0007bBAr\u0001\u0011\u0005\u0011Q\u001d\u0005\n\u0003[\u0004\u0011\u0013!C\u0001\u0003_DqA!\u0002\u0001\t\u0013\u00119\u0001C\u0004\u0003\u0016\u0001!IAa\u0006\t\u000f\te\u0002\u0001\"\u0003\u0003<!9!\u0011\t\u0001\u0005\n\t\r\u0003b\u0002B$\u0001\u0011%!\u0011J\u0004\u000b\u0005'R\u0013\u0011!E\u0001Y\tUc!C\u0015+\u0003\u0003E\t\u0001\fB,\u0011\u00199f\u0005\"\u0001\u0003`!I!\u0011\r\u0014\u0012\u0002\u0013\u0005\u0011q\u001e\u0002\u001b'B\f'o[\"p]:,7\r^*feZ,'\u000fT5ti\u0016tWM\u001d\u0006\u0003W1\n!!^5\u000b\u00055r\u0013aB2p]:,7\r\u001e\u0006\u0003_A\n1a]9m\u0015\t\t$'A\u0003ta\u0006\u00148N\u0003\u00024i\u00051\u0011\r]1dQ\u0016T\u0011!N\u0001\u0004_J<7c\u0001\u00018{A\u0011\u0001hO\u0007\u0002s)\u0011!\bM\u0001\ng\u000eDW\rZ;mKJL!\u0001P\u001d\u0003\u001bM\u0003\u0018M]6MSN$XM\\3s!\tq\u0014)D\u0001@\u0015\t\u0001\u0005'\u0001\u0005j]R,'O\\1m\u0013\t\u0011uHA\u0004M_\u001e<\u0017N\\4\u0002\u000f-48\u000f^8sK\u000e\u0001\u0001C\u0001$J\u001b\u00059%B\u0001%1\u0003\u0019\u0019H/\u0019;vg&\u0011!j\u0012\u0002\u0015\u000b2,W.\u001a8u)J\f7m[5oON#xN]3\u0002\u0013M\u0004\u0018M]6D_:4\u0007CA'O\u001b\u0005\u0001\u0014BA(1\u0005%\u0019\u0006/\u0019:l\u0007>tg-\u0001\u0003mSZ,\u0007C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\te[F,\u0018\t\u00035\u0002i\u0011A\u000b\u0005\u0006\u0007\u0012\u0001\r!\u0012\u0005\u0006\u0017\u0012\u0001\r\u0001\u0014\u0005\b!\u0012\u0001\n\u00111\u0001R\u0003-\u0019Xm]:j_:d\u0015n\u001d;\u0016\u0003\u0001\u0004B!\u00194ig6\t!M\u0003\u0002dI\u00069Q.\u001e;bE2,'BA3T\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003O\n\u0014Q\u0002T5oW\u0016$\u0007*Y:i\u001b\u0006\u0004\bCA5q\u001d\tQg\u000e\u0005\u0002l'6\tAN\u0003\u0002n\t\u00061AH]8pizJ!a\\*\u0002\rA\u0013X\rZ3g\u0013\t\t(O\u0001\u0004TiJLgn\u001a\u0006\u0003_N\u0003\"A\u0017;\n\u0005UT#a\u0004'jm\u0016\u001cVm]:j_:$\u0015\r^1\u0002\u0019M,7o]5p]2K7\u000f\u001e\u0011\u0002\u001b\u0015DXmY;uS>tG*[:u+\u0005I\b\u0003B1gQj\u0004\"AW>\n\u0005qT#!\u0005'jm\u0016,\u00050Z2vi&|g\u000eR1uC\u0006qQ\r_3dkRLwN\u001c'jgR\u0004\u0013a\u0001=%cA9!+!\u0001\u0002\u0006\u0005\u0015\u0011bAA\u0002'\n1A+\u001e9mKJ\u00022AUA\u0004\u0013\r\tIa\u0015\u0002\u0004\u0013:$\u0018A\u0005:fi\u0006Lg.\u001a3Ti\u0006$X-\\3oiN,\"!!\u0002\u0002'I,G/Y5oK\u0012\u001cF/\u0019;f[\u0016tGo\u001d\u0011\u0002!I,G/Y5oK\u0012\u001cVm]:j_:\u001c\u0018!\u0005:fi\u0006Lg.\u001a3TKN\u001c\u0018n\u001c8tA\u0005\u0011B.\u001b<f+B$\u0017\r^3QKJLw\u000e\u001a(t+\t\tI\u0002E\u0002S\u00037I1!!\bT\u0005\u0011auN\\4\u0002'1Lg/Z+qI\u0006$X\rU3sS>$gj\u001d\u0011\u0002\u00159|G*\u001b<f\t\u0006$\u0018\rF\u0001R\u0003)ygNS8c'R\f'\u000f\u001e\u000b\u0005\u0003S\ty\u0003E\u0002S\u0003WI1!!\fT\u0005\u0011)f.\u001b;\t\u000f\u0005E\u0012\u00031\u0001\u00024\u0005A!n\u001c2Ti\u0006\u0014H\u000fE\u00029\u0003kI1!a\u000e:\u0005U\u0019\u0006/\u0019:l\u0019&\u001cH/\u001a8fe*{'m\u0015;beR\fAb\u001c8Pi\",'/\u0012<f]R$B!!\u000b\u0002>!9\u0011q\b\nA\u0002\u0005\u0005\u0013!B3wK:$\bc\u0001\u001d\u0002D%\u0019\u0011QI\u001d\u0003%M\u0003\u0018M]6MSN$XM\\3s\u000bZ,g\u000e^\u0001\u0014_:\u001c\u0016\u000bT#yK\u000e,H/[8o'R\f'\u000f\u001e\u000b\u0005\u0003S\tY\u0005C\u0004\u0002NM\u0001\r!a\u0014\u0002\u0003\u0015\u0004B!!\u0015\u0002Z5\u0011\u00111\u000b\u0006\u0004W\u0005U#bAA,]\u0005IQ\r_3dkRLwN\\\u0005\u0005\u00037\n\u0019F\u0001\u0010Ta\u0006\u00148\u000eT5ti\u0016tWM]*R\u0019\u0016CXmY;uS>t7\u000b^1si\u0006\u0011rN\\(qKJ\fG/[8o'R\f'\u000f^3e)\u0011\tI#!\u0019\t\u000f\u00055C\u00031\u0001\u0002dA!\u0011QMA6\u001b\t\t9GC\u0002\u0002j1\nqa]3sm&\u001cW-\u0003\u0003\u0002n\u0005\u001d$\u0001J*qCJ\\G*[:uK:,'oQ8o]\u0016\u001cGo\u00149fe\u0006$\u0018n\u001c8Ti\u0006\u0014H/\u001a3\u0002'=tw\n]3sCRLwN\\!oC2L(0\u001a3\u0015\t\u0005%\u00121\u000f\u0005\b\u0003\u001b*\u0002\u0019AA;!\u0011\t)'a\u001e\n\t\u0005e\u0014q\r\u0002&'B\f'o\u001b'jgR,g.\u001a:D_:tWm\u0019;Pa\u0016\u0014\u0018\r^5p]\u0006s\u0017\r\\={K\u0012\fAd\u001c8Pa\u0016\u0014\u0018\r^5p]J+\u0017\rZ=G_J,\u00050Z2vi&|g\u000e\u0006\u0003\u0002*\u0005}\u0004bBA'-\u0001\u0007\u0011\u0011\u0011\t\u0005\u0003K\n\u0019)\u0003\u0003\u0002\u0006\u0006\u001d$AL*qCJ\\G*[:uK:,'oQ8o]\u0016\u001cGo\u00149fe\u0006$\u0018n\u001c8SK\u0006$\u0017PR8s\u000bb,7-\u001e;j_:\f1c\u001c8Pa\u0016\u0014\u0018\r^5p]\u000e\u000bgnY3mK\u0012$B!!\u000b\u0002\f\"9\u0011QJ\fA\u0002\u00055\u0005\u0003BA3\u0003\u001fKA!!%\u0002h\t)3\u000b]1sW2K7\u000f^3oKJ\u001cuN\u001c8fGR|\u0005/\u001a:bi&|gnQ1oG\u0016dW\rZ\u0001\u0012_:|\u0005/\u001a:bi&|gNR1jY\u0016$G\u0003BA\u0015\u0003/Cq!!\u0014\u0019\u0001\u0004\tI\n\u0005\u0003\u0002f\u0005m\u0015\u0002BAO\u0003O\u00121e\u00159be.d\u0015n\u001d;f]\u0016\u00148i\u001c8oK\u000e$x\n]3sCRLwN\u001c$bS2,G-A\np]>\u0003XM]1uS>tg)\u001b8jg\",G\r\u0006\u0003\u0002*\u0005\r\u0006bBA'3\u0001\u0007\u0011Q\u0015\t\u0005\u0003K\n9+\u0003\u0003\u0002*\u0006\u001d$!J*qCJ\\G*[:uK:,'oQ8o]\u0016\u001cGo\u00149fe\u0006$\u0018n\u001c8GS:L7\u000f[3e\u0003Eygn\u00149fe\u0006$\u0018n\u001c8DY>\u001cX\r\u001a\u000b\u0005\u0003_\u000b)\fE\u0002S\u0003cK1!a-T\u0005\r\te.\u001f\u0005\b\u0003\u001bR\u0002\u0019AA\\!\u0011\t)'!/\n\t\u0005m\u0016q\r\u0002$'B\f'o\u001b'jgR,g.\u001a:D_:tWm\u0019;Pa\u0016\u0014\u0018\r^5p]\u000ecwn]3e\u0003AygnU3tg&|gn\u0015;beR,G\r\u0006\u0003\u0002*\u0005\u0005\u0007bBA'7\u0001\u0007\u00111\u0019\t\u0005\u0003K\n)-\u0003\u0003\u0002H\u0006\u001d$AI*qCJ\\G*[:uK:,'oQ8o]\u0016\u001cGoU3tg&|gn\u0015;beR,G-A\bp]N+7o]5p]\u000ecwn]3e)\u0011\ty+!4\t\u000f\u00055C\u00041\u0001\u0002PB!\u0011QMAi\u0013\u0011\t\u0019.a\u001a\u0003CM\u0003\u0018M]6MSN$XM\\3s\u0007>tg.Z2u'\u0016\u001c8/[8o\u00072|7/\u001a3\u0002;U\u0004H-\u0019;f'R|'/Z,ji\"$&/[4hKJ,e.\u00192mK\u0012$B!!\u000b\u0002Z\"9\u00111\\\u000fA\u0002\u0005u\u0017AB3oi&$\u0018\u0010E\u0002G\u0003?L1!!9H\u0005)a\u0015N^3F]RLG/_\u0001\u0010kB$\u0017\r^3MSZ,7\u000b^8sKR1\u0011\u0011FAt\u0003SDq!a7\u001f\u0001\u0004\ti\u000e\u0003\u0005\u0002lz\u0001\n\u00111\u0001R\u0003\u001d!(/[4hKJ\f\u0011$\u001e9eCR,G*\u001b<f'R|'/\u001a\u0013eK\u001a\fW\u000f\u001c;%eU\u0011\u0011\u0011\u001f\u0016\u0004#\u0006M8FAA{!\u0011\t9P!\u0001\u000e\u0005\u0005e(\u0002BA~\u0003{\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}8+\u0001\u0006b]:|G/\u0019;j_:LAAa\u0001\u0002z\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%\u001d,Go\u0014:De\u0016\fG/Z*fgNLwN\u001c\u000b\bg\n%!Q\u0002B\t\u0011\u0019\u0011Y\u0001\ta\u0001Q\u0006I1/Z:tS>t\u0017\n\u001a\u0005\u0007\u0005\u001f\u0001\u0003\u0019\u00015\u0002\u0011U\u001cXM\u001d(b[\u0016DqAa\u0005!\u0001\u0004\tI\"A\u0005ti\u0006\u0014H\u000fV5nK\u0006!r-\u001a;Pe\u000e\u0013X-\u0019;f\u000bb,7-\u001e;j_:$rB\u001fB\r\u0005;\u0011\tCa\t\u0003(\t-\"q\u0006\u0005\u0007\u00057\t\u0003\u0019\u00015\u0002\r)|'\rV1h\u0011\u0019\u0011y\"\ta\u0001Q\u0006I1\u000f^1uK6,g\u000e\u001e\u0005\u0007\u0005\u0017\t\u0003\u0019\u00015\t\u000f\t\u0015\u0012\u00051\u0001\u0002\u001a\u0005q1\u000f^1siRKW.Z:uC6\u0004\bB\u0002B\u0015C\u0001\u0007\u0001.\u0001\u0004vg\u0016\u0014\u0018\n\u001a\u0005\u0007\u0005[\t\u0003\u0019\u00015\u0002\u0017=\u0004XM]1uS>t\u0017\n\u001a\u0005\b\u0005c\t\u0003\u0019\u0001B\u001a\u0003A\u0019\b/\u0019:l'\u0016\u001c8/[8o)\u0006<7\u000f\u0005\u0003j\u0005kA\u0017b\u0001B\u001ce\n\u00191+\u001a;\u0002#\rdW-\u00198va\u0016CXmY;uS>t7\u000f\u0006\u0003\u0002*\tu\u0002b\u0002B E\u0001\u0007\u0011\u0011D\u0001\u0006G>,h\u000e^\u0001\u000fG2,\u0017M\\;q'\u0016\u001c8/[8o)\u0011\tIC!\u0012\t\u000f\t}2\u00051\u0001\u0002\u001a\u000592-\u00197dk2\fG/\u001a(v[\n,'\u000fV8SK6|g/\u001a\u000b\u0007\u00033\u0011YEa\u0014\t\u000f\t5C\u00051\u0001\u0002\u001a\u0005AA-\u0019;b'&TX\rC\u0004\u0003R\u0011\u0002\r!!\u0007\u0002\u0019I,G/Y5oK\u0012\u001c\u0016N_3\u00025M\u0003\u0018M]6D_:tWm\u0019;TKJ4XM\u001d'jgR,g.\u001a:\u0011\u0005i33c\u0001\u0014\u0003ZA\u0019!Ka\u0017\n\u0007\tu3K\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005+\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001a\u0004")
public class SparkConnectServerListener
extends SparkListener
implements Logging {
    private final ElementTrackingStore kvstore;
    private final boolean live;
    private final LinkedHashMap<String, LiveSessionData> sessionList;
    private final LinkedHashMap<String, LiveExecutionData> executionList;
    private final /* synthetic */ Tuple2 x$1;
    private final int retainedStatements;
    private final int retainedSessions;
    private final long liveUpdatePeriodNs;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static boolean $lessinit$greater$default$3() {
        return SparkConnectServerListener$.MODULE$.$lessinit$greater$default$3();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private LinkedHashMap<String, LiveSessionData> sessionList() {
        return this.sessionList;
    }

    private LinkedHashMap<String, LiveExecutionData> executionList() {
        return this.executionList;
    }

    private int retainedStatements() {
        return this.retainedStatements;
    }

    private int retainedSessions() {
        return this.retainedSessions;
    }

    private long liveUpdatePeriodNs() {
        return this.liveUpdatePeriodNs;
    }

    public synchronized boolean noLiveData() {
        return this.sessionList().isEmpty() && this.executionList().isEmpty();
    }

    public void onJobStart(SparkListenerJobStart jobStart) {
        Seq jobTags = (Seq)((SeqOps)((IterableOnceOps)Option$.MODULE$.apply((Object)jobStart.properties()).flatMap((Function1 & Serializable)p -> Option$.MODULE$.apply((Object)p.getProperty(SparkContext$.MODULE$.SPARK_JOB_TAGS()))).map((Function1 & Serializable)x$2 -> Predef$.MODULE$.wrapRefArray((Object[])x$2.split(SparkContext$.MODULE$.SPARK_JOB_TAGS_SEP())).toSet()).getOrElse((Function0 & Serializable)() -> (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))).toSeq().filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$onJobStart$4(x$3)))).sorted((Ordering)Ordering.String$.MODULE$);
        Option executeJobTagOpt = jobTags.find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$onJobStart$5(x0$1)));
        if (executeJobTagOpt.isEmpty()) {
            return;
        }
        String executeJobTag = (String)executeJobTagOpt.get();
        Option exec2 = this.executionList().get((Object)executeJobTag);
        if (exec2.nonEmpty()) {
            exec2.foreach((Function1 & Serializable)exec -> {
                SparkConnectServerListener.$anonfun$onJobStart$6(this, jobStart, exec);
                return BoxedUnit.UNIT;
            });
        } else {
            Seq storeExecInfo = KVUtils$.MODULE$.viewToSeq(this.kvstore.view(ExecutionInfo.class), Integer.MAX_VALUE, (Function1 & Serializable)exec -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$onJobStart$7(executeJobTag, exec)));
            storeExecInfo.foreach((Function1 & Serializable)exec -> {
                LiveExecutionData liveExec = this.getOrCreateExecution(exec.jobTag(), exec.statement(), exec.sessionId(), exec.startTimestamp(), exec.userId(), exec.operationId(), exec.sparkSessionTags());
                liveExec.sqlExecId_$eq(exec.sqlExecId());
                liveExec.jobId().$plus$eq((Object)Integer.toString(jobStart.jobId()));
                this.updateStoreWithTriggerEnabled(liveExec);
                return this.executionList().remove((Object)liveExec.jobTag());
            });
        }
    }

    public void onOtherEvent(SparkListenerEvent event) {
        SparkListenerEvent sparkListenerEvent = event;
        if (sparkListenerEvent instanceof SparkListenerSQLExecutionStart) {
            SparkListenerSQLExecutionStart sparkListenerSQLExecutionStart = (SparkListenerSQLExecutionStart)sparkListenerEvent;
            this.onSQLExecutionStart(sparkListenerSQLExecutionStart);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerConnectOperationStarted) {
            SparkListenerConnectOperationStarted sparkListenerConnectOperationStarted = (SparkListenerConnectOperationStarted)sparkListenerEvent;
            this.onOperationStarted(sparkListenerConnectOperationStarted);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerConnectOperationAnalyzed) {
            SparkListenerConnectOperationAnalyzed sparkListenerConnectOperationAnalyzed = (SparkListenerConnectOperationAnalyzed)sparkListenerEvent;
            this.onOperationAnalyzed(sparkListenerConnectOperationAnalyzed);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerConnectOperationReadyForExecution) {
            SparkListenerConnectOperationReadyForExecution sparkListenerConnectOperationReadyForExecution = (SparkListenerConnectOperationReadyForExecution)sparkListenerEvent;
            this.onOperationReadyForExecution(sparkListenerConnectOperationReadyForExecution);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerConnectOperationCanceled) {
            SparkListenerConnectOperationCanceled sparkListenerConnectOperationCanceled = (SparkListenerConnectOperationCanceled)sparkListenerEvent;
            this.onOperationCanceled(sparkListenerConnectOperationCanceled);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerConnectOperationFailed) {
            SparkListenerConnectOperationFailed sparkListenerConnectOperationFailed = (SparkListenerConnectOperationFailed)sparkListenerEvent;
            this.onOperationFailed(sparkListenerConnectOperationFailed);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerConnectOperationFinished) {
            SparkListenerConnectOperationFinished sparkListenerConnectOperationFinished = (SparkListenerConnectOperationFinished)sparkListenerEvent;
            this.onOperationFinished(sparkListenerConnectOperationFinished);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerConnectOperationClosed) {
            SparkListenerConnectOperationClosed sparkListenerConnectOperationClosed = (SparkListenerConnectOperationClosed)sparkListenerEvent;
            this.onOperationClosed(sparkListenerConnectOperationClosed);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerConnectSessionStarted) {
            SparkListenerConnectSessionStarted sparkListenerConnectSessionStarted = (SparkListenerConnectSessionStarted)sparkListenerEvent;
            this.onSessionStarted(sparkListenerConnectSessionStarted);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkListenerEvent instanceof SparkListenerConnectSessionClosed) {
            SparkListenerConnectSessionClosed sparkListenerConnectSessionClosed = (SparkListenerConnectSessionClosed)sparkListenerEvent;
            this.onSessionClosed(sparkListenerConnectSessionClosed);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void onSQLExecutionStart(SparkListenerSQLExecutionStart e) {
        Option executeJobTagOpt = e.jobTags().find((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$onSQLExecutionStart$1(x0$1)));
        if (executeJobTagOpt.isEmpty()) {
            return;
        }
        String executeJobTag = (String)executeJobTagOpt.get();
        Option exec2 = this.executionList().get((Object)executeJobTag);
        if (exec2.nonEmpty()) {
            exec2.foreach((Function1 & Serializable)exec -> {
                SparkConnectServerListener.$anonfun$onSQLExecutionStart$2(this, e, exec);
                return BoxedUnit.UNIT;
            });
        } else {
            Seq storeExecInfo = KVUtils$.MODULE$.viewToSeq(this.kvstore.view(ExecutionInfo.class), Integer.MAX_VALUE, (Function1 & Serializable)exec -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$onSQLExecutionStart$3(executeJobTag, exec)));
            storeExecInfo.foreach((Function1 & Serializable)exec -> {
                LiveExecutionData liveExec = this.getOrCreateExecution(exec.jobTag(), exec.statement(), exec.sessionId(), exec.startTimestamp(), exec.userId(), exec.operationId(), exec.sparkSessionTags());
                liveExec.jobId_$eq(exec.jobId());
                liveExec.sqlExecId().$plus$eq((Object)Long.toString(e.executionId()));
                this.updateStoreWithTriggerEnabled(liveExec);
                return this.executionList().remove((Object)liveExec.jobTag());
            });
        }
    }

    private synchronized void onOperationStarted(SparkListenerConnectOperationStarted e) {
        LiveExecutionData executionData = this.getOrCreateExecution(e.jobTag(), e.statementText(), e.sessionId(), e.eventTime(), e.userId(), e.operationId(), e.sparkSessionTags());
        executionData.state_$eq(ExecutionState$.MODULE$.STARTED());
        this.executionList().put((Object)e.jobTag(), (Object)executionData);
        this.updateLiveStore(executionData, this.updateLiveStore$default$2());
        Option option = this.sessionList().get((Object)e.sessionId());
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveSessionData sessionData = (LiveSessionData)((Object)some.value());
            sessionData.totalExecution_$eq(sessionData.totalExecution() + 1);
            this.updateLiveStore(sessionData, this.updateLiveStore$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(50).append("onOperationStart called with unknown session id: ").append(e.sessionId()).append(".").toString()).append("Regardless, the operation has been registered.").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private synchronized void onOperationAnalyzed(SparkListenerConnectOperationAnalyzed e) {
        Option option = this.executionList().get((Object)e.jobTag());
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData = (LiveExecutionData)((Object)some.value());
            executionData.state_$eq(ExecutionState$.MODULE$.COMPILED());
            this.updateLiveStore(executionData, this.updateLiveStore$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("onOperationAnalyzed called with unknown operation id: ").append(e.jobTag()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private synchronized void onOperationReadyForExecution(SparkListenerConnectOperationReadyForExecution e) {
        Option option = this.executionList().get((Object)e.jobTag());
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData = (LiveExecutionData)((Object)some.value());
            executionData.state_$eq(ExecutionState$.MODULE$.READY());
            this.updateLiveStore(executionData, this.updateLiveStore$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("onOperationReadyForExecution called with unknown operation id: ").append(e.jobTag()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private synchronized void onOperationCanceled(SparkListenerConnectOperationCanceled e) {
        Option option = this.executionList().get((Object)e.jobTag());
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData = (LiveExecutionData)((Object)some.value());
            executionData.finishTimestamp_$eq(e.eventTime());
            executionData.state_$eq(ExecutionState$.MODULE$.CANCELED());
            this.updateLiveStore(executionData, this.updateLiveStore$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("onOperationCanceled called with unknown operation id: ").append(e.jobTag()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private synchronized void onOperationFailed(SparkListenerConnectOperationFailed e) {
        Option option = this.executionList().get((Object)e.jobTag());
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData = (LiveExecutionData)((Object)some.value());
            executionData.finishTimestamp_$eq(e.eventTime());
            executionData.detail_$eq(e.errorMessage());
            executionData.state_$eq(ExecutionState$.MODULE$.FAILED());
            this.updateLiveStore(executionData, this.updateLiveStore$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("onOperationFailed called with unknown operation id: ").append(e.jobTag()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private synchronized void onOperationFinished(SparkListenerConnectOperationFinished e) {
        Option option = this.executionList().get((Object)e.jobTag());
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData = (LiveExecutionData)((Object)some.value());
            executionData.finishTimestamp_$eq(e.eventTime());
            executionData.state_$eq(ExecutionState$.MODULE$.FINISHED());
            this.updateLiveStore(executionData, this.updateLiveStore$default$2());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("onOperationFinished called with unknown operation id: ").append(e.jobTag()).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private synchronized Object onOperationClosed(SparkListenerConnectOperationClosed e) {
        BoxedUnit boxedUnit;
        Option option = this.executionList().get((Object)e.jobTag());
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveExecutionData executionData = (LiveExecutionData)((Object)some.value());
            executionData.closeTimestamp_$eq(e.eventTime());
            executionData.state_$eq(ExecutionState$.MODULE$.CLOSED());
            this.updateStoreWithTriggerEnabled(executionData);
            boxedUnit = this.executionList().remove((Object)e.jobTag());
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(52).append("onOperationClosed called with unknown operation id: ").append(e.jobTag()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        return boxedUnit;
    }

    private synchronized void onSessionStarted(SparkListenerConnectSessionStarted e) {
        LiveSessionData session = this.getOrCreateSession(e.sessionId(), e.userId(), e.eventTime());
        this.sessionList().put((Object)e.sessionId(), (Object)session);
        this.updateLiveStore(session, this.updateLiveStore$default$2());
    }

    private synchronized Object onSessionClosed(SparkListenerConnectSessionClosed e) {
        BoxedUnit boxedUnit;
        Option option = this.sessionList().get((Object)e.sessionId());
        if (option instanceof Some) {
            Some some = (Some)option;
            LiveSessionData sessionData = (LiveSessionData)((Object)some.value());
            sessionData.finishTimestamp_$eq(e.eventTime());
            this.updateStoreWithTriggerEnabled(sessionData);
            boxedUnit = this.sessionList().remove((Object)e.sessionId());
        } else if (None$.MODULE$.equals(option)) {
            this.logWarning((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("onSessionClosed called with unknown session id: ").append(e.sessionId()).toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
        return boxedUnit;
    }

    public synchronized void updateStoreWithTriggerEnabled(LiveEntity entity) {
        entity.write(this.kvstore, System.nanoTime(), true);
    }

    public synchronized void updateLiveStore(LiveEntity entity, boolean trigger) {
        block0: {
            long now = System.nanoTime();
            if (!this.live || this.liveUpdatePeriodNs() < 0L || now - entity.lastWriteTime() <= this.liveUpdatePeriodNs()) break block0;
            entity.write(this.kvstore, now, trigger);
        }
    }

    public boolean updateLiveStore$default$2() {
        return false;
    }

    private synchronized LiveSessionData getOrCreateSession(String sessionId, String userName, long startTime) {
        return (LiveSessionData)((Object)this.sessionList().getOrElseUpdate((Object)sessionId, (Function0 & Serializable)() -> new LiveSessionData(sessionId, startTime, userName)));
    }

    private synchronized LiveExecutionData getOrCreateExecution(String jobTag, String statement, String sessionId, long startTimestamp, String userId, String operationId, Set<String> sparkSessionTags) {
        return (LiveExecutionData)((Object)this.executionList().getOrElseUpdate((Object)jobTag, (Function0 & Serializable)() -> new LiveExecutionData(jobTag, statement, sessionId, startTimestamp, userId, operationId, sparkSessionTags)));
    }

    private void cleanupExecutions(long count) {
        long countToDelete = this.calculateNumberToRemove(count, this.retainedStatements());
        if (countToDelete <= 0L) {
            return;
        }
        KVStoreView view = this.kvstore.view(ExecutionInfo.class).index("finishTime").first((Object)BoxesRunTime.boxToLong((long)0L));
        Seq toDelete = KVUtils$.MODULE$.viewToSeq(view, (int)countToDelete, (Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$cleanupExecutions$1(j)));
        toDelete.foreach((Function1 & Serializable)j -> {
            this.kvstore.delete(j.getClass(), (Object)j.jobTag());
            return BoxedUnit.UNIT;
        });
    }

    private void cleanupSession(long count) {
        long countToDelete = this.calculateNumberToRemove(count, this.retainedSessions());
        if (countToDelete <= 0L) {
            return;
        }
        KVStoreView view = this.kvstore.view(SessionInfo.class).index("finishTime").first((Object)BoxesRunTime.boxToLong((long)0L));
        Seq toDelete = KVUtils$.MODULE$.viewToSeq(view, (int)countToDelete, (Function1 & Serializable)j -> BoxesRunTime.boxToBoolean((boolean)SparkConnectServerListener.$anonfun$cleanupSession$1(j)));
        toDelete.foreach((Function1 & Serializable)j -> {
            this.kvstore.delete(j.getClass(), (Object)j.sessionId());
            return BoxedUnit.UNIT;
        });
    }

    private long calculateNumberToRemove(long dataSize, long retainedSize) {
        return dataSize > retainedSize ? package$.MODULE$.max(retainedSize / 10L, dataSize - retainedSize) : 0L;
    }

    public static final /* synthetic */ boolean $anonfun$onJobStart$4(String x$3) {
        return !x$3.isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$onJobStart$5(String x0$1) {
        Option<String> option;
        String string = x0$1;
        boolean bl = string != null && !(option = ExecuteJobTag$.MODULE$.unapply(string)).isEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$onJobStart$6(SparkConnectServerListener $this, SparkListenerJobStart jobStart$1, LiveExecutionData exec) {
        exec.jobId().$plus$eq((Object)Integer.toString(jobStart$1.jobId()));
        $this.updateLiveStore(exec, $this.updateLiveStore$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$onJobStart$7(String executeJobTag$1, ExecutionInfo exec) {
        String string = exec.jobTag();
        String string2 = executeJobTag$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$onSQLExecutionStart$1(String x0$1) {
        Option<String> option;
        String string = x0$1;
        boolean bl = string != null && !(option = ExecuteJobTag$.MODULE$.unapply(string)).isEmpty();
        return bl;
    }

    public static final /* synthetic */ void $anonfun$onSQLExecutionStart$2(SparkConnectServerListener $this, SparkListenerSQLExecutionStart e$1, LiveExecutionData exec) {
        exec.sqlExecId().$plus$eq((Object)Long.toString(e$1.executionId()));
        $this.updateLiveStore(exec, $this.updateLiveStore$default$2());
    }

    public static final /* synthetic */ boolean $anonfun$onSQLExecutionStart$3(String executeJobTag$2, ExecutionInfo exec) {
        String string = exec.jobTag();
        String string2 = executeJobTag$2;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$cleanupExecutions$1(ExecutionInfo j) {
        return j.finishTimestamp() != 0L;
    }

    public static final /* synthetic */ boolean $anonfun$cleanupSession$1(SessionInfo j) {
        return j.finishTimestamp() != 0L;
    }

    public SparkConnectServerListener(ElementTrackingStore kvstore, SparkConf sparkConf, boolean live) {
        int n;
        int retainedSessions;
        block3: {
            Tuple2.mcII.sp sp2;
            block2: {
                this.kvstore = kvstore;
                this.live = live;
                Logging.$init$((Logging)this);
                this.sessionList = new LinkedHashMap();
                this.executionList = new LinkedHashMap();
                sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_UI_STATEMENT_LIMIT())), BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_UI_SESSION_LIMIT())));
                if (sp2 == null) break block2;
                int retainedStatements = sp2._1$mcI$sp();
                retainedSessions = sp2._2$mcI$sp();
                if (!true) break block2;
                n = retainedStatements;
                if (true) break block3;
            }
            throw new MatchError((Object)sp2);
        }
        int n2 = retainedSessions;
        Tuple2.mcII.sp sp3 = new Tuple2.mcII.sp(n, n2);
        this.x$1 = sp3;
        this.retainedStatements = this.x$1._1$mcI$sp();
        this.retainedSessions = this.x$1._2$mcI$sp();
        this.liveUpdatePeriodNs = live ? BoxesRunTime.unboxToLong((Object)sparkConf.get(Status$.MODULE$.LIVE_ENTITY_UPDATE_PERIOD())) : -1L;
        kvstore.addTrigger(SessionInfo.class, (long)this.retainedSessions(), (Function1)(JFunction1.mcVJ.sp & Serializable)count -> this.cleanupSession(count));
        kvstore.addTrigger(ExecutionInfo.class, (long)this.retainedStatements(), (Function1)(JFunction1.mcVJ.sp & Serializable)count -> this.cleanupExecutions(count));
    }
}

