/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.planner;

import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.common.InvalidPlanInput;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.common.LiteralValueProtoConverter$;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class LiteralExpressionProtoConverter$ {
    public static final LiteralExpressionProtoConverter$ MODULE$ = new LiteralExpressionProtoConverter$();

    public Literal toCatalystExpression(Expression.Literal lit) {
        Literal literal;
        Expression.Literal.LiteralTypeCase literalTypeCase = lit.getLiteralTypeCase();
        if (Expression.Literal.LiteralTypeCase.NULL.equals(literalTypeCase)) {
            literal = new Literal(null, DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getNull()));
        } else if (Expression.Literal.LiteralTypeCase.BINARY.equals(literalTypeCase)) {
            literal = new Literal((Object)lit.getBinary().toByteArray(), (DataType)BinaryType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.BOOLEAN.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToBoolean((boolean)lit.getBoolean()), (DataType)BooleanType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.BYTE.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToByte((byte)((byte)lit.getByte())), (DataType)ByteType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.SHORT.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToShort((short)((short)lit.getShort())), (DataType)ShortType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.INTEGER.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToInteger((int)lit.getInteger()), (DataType)IntegerType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.LONG.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToLong((long)lit.getLong()), (DataType)LongType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.FLOAT.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToFloat((float)lit.getFloat()), (DataType)FloatType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.DOUBLE.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToDouble((double)lit.getDouble()), (DataType)DoubleType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.DECIMAL.equals(literalTypeCase)) {
            Decimal decimal = Decimal$.MODULE$.apply(lit.getDecimal().getValue());
            int precision = decimal.precision();
            if (lit.getDecimal().hasPrecision()) {
                precision = package$.MODULE$.max(precision, lit.getDecimal().getPrecision());
            }
            int scale = decimal.scale();
            if (lit.getDecimal().hasScale()) {
                scale = package$.MODULE$.max(scale, lit.getDecimal().getScale());
            }
            literal = new Literal((Object)decimal, (DataType)new DecimalType(package$.MODULE$.max(precision, scale), scale));
        } else if (Expression.Literal.LiteralTypeCase.STRING.equals(literalTypeCase)) {
            literal = new Literal((Object)UTF8String.fromString((String)lit.getString()), (DataType)StringType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.DATE.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToInteger((int)lit.getDate()), (DataType)DateType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.TIMESTAMP.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToLong((long)lit.getTimestamp()), (DataType)TimestampType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.TIMESTAMP_NTZ.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToLong((long)lit.getTimestampNtz()), (DataType)TimestampNTZType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.CALENDAR_INTERVAL.equals(literalTypeCase)) {
            CalendarInterval interval = new CalendarInterval(lit.getCalendarInterval().getMonths(), lit.getCalendarInterval().getDays(), lit.getCalendarInterval().getMicroseconds());
            literal = new Literal((Object)interval, (DataType)CalendarIntervalType$.MODULE$);
        } else if (Expression.Literal.LiteralTypeCase.YEAR_MONTH_INTERVAL.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToInteger((int)lit.getYearMonthInterval()), (DataType)YearMonthIntervalType$.MODULE$.apply());
        } else if (Expression.Literal.LiteralTypeCase.DAY_TIME_INTERVAL.equals(literalTypeCase)) {
            literal = new Literal((Object)BoxesRunTime.boxToLong((long)lit.getDayTimeInterval()), (DataType)DayTimeIntervalType$.MODULE$.apply());
        } else if (Expression.Literal.LiteralTypeCase.ARRAY.equals(literalTypeCase)) {
            literal = Literal$.MODULE$.create(LiteralValueProtoConverter$.MODULE$.toCatalystArray(lit.getArray()), (DataType)ArrayType$.MODULE$.apply(DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getArray().getElementType())));
        } else if (Expression.Literal.LiteralTypeCase.MAP.equals(literalTypeCase)) {
            literal = Literal$.MODULE$.create(LiteralValueProtoConverter$.MODULE$.toCatalystMap(lit.getMap()), (DataType)MapType$.MODULE$.apply(DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getMap().getKeyType()), DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getMap().getValueType())));
        } else if (Expression.Literal.LiteralTypeCase.STRUCT.equals(literalTypeCase)) {
            DataType dataType = DataTypeProtoConverter$.MODULE$.toCatalystType(lit.getStruct().getStructType());
            Object structData = LiteralValueProtoConverter$.MODULE$.toCatalystStruct(lit.getStruct());
            Function1 convert = CatalystTypeConverters$.MODULE$.createToCatalystConverter(dataType);
            literal = new Literal(convert.apply(structData), dataType);
        } else {
            throw new InvalidPlanInput(new StringBuilder(0).append(new StringBuilder(26).append("Unsupported Literal Type: ").append(lit.getLiteralTypeCase().getNumber()).toString()).append(new StringBuilder(2).append("(").append(lit.getLiteralTypeCase().name()).append(")").toString()).toString(), InvalidPlanInput$.MODULE$.apply$default$2());
        }
        return literal;
    }

    private LiteralExpressionProtoConverter$() {
    }
}

