/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.common;

import com.google.protobuf.ByteString;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import org.apache.spark.connect.proto.DataType;
import org.apache.spark.connect.proto.Expression;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.ScalaReflection;
import org.apache.spark.sql.catalyst.ScalaReflection$;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.catalyst.util.SparkDateTimeUtils$;
import org.apache.spark.sql.catalyst.util.SparkIntervalUtils$;
import org.apache.spark.sql.connect.common.DataTypeProtoConverter$;
import org.apache.spark.sql.connect.common.InvalidPlanInput$;
import org.apache.spark.sql.connect.common.LiteralValueProtoConverter;
import org.apache.spark.sql.connect.common.ProtoDataTypes$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.CalendarIntervalType$;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimeType;
import org.apache.spark.sql.types.TimeType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.YearMonthIntervalType$;
import org.apache.spark.unsafe.types.CalendarInterval;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.ArraySeq;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Map$;
import scala.math.BigInt;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.api.TypeTags;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public final class LiteralValueProtoConverter$ {
    public static final LiteralValueProtoConverter$ MODULE$ = new LiteralValueProtoConverter$();

    private Expression.Literal.Builder setNullValue(Expression.Literal.Builder builder, org.apache.spark.sql.types.DataType dataType, boolean needDataType) {
        if (needDataType) {
            return builder.setNull(DataTypeProtoConverter$.MODULE$.toConnectProtoType(dataType, DataTypeProtoConverter$.MODULE$.toConnectProtoType$default$2()));
        }
        return builder.setNull(ProtoDataTypes$.MODULE$.NullType());
    }

    private Expression.Literal.Builder toLiteralProtoBuilderInternal(Object literal, LiteralValueProtoConverter.ToLiteralProtoOptions options) {
        Object object;
        Expression.Literal.Builder builder;
        while (true) {
            builder = Expression.Literal.newBuilder();
            object = literal;
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                return builder.setBoolean(bl);
            }
            if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                return builder.setByte(by);
            }
            if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                return builder.setShort(s);
            }
            if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                return builder.setInteger(n);
            }
            if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                return builder.setLong(l);
            }
            if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                return builder.setFloat(f);
            }
            if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                return builder.setDouble(d);
            }
            if (object instanceof scala.math.BigDecimal) {
                scala.math.BigDecimal bigDecimal = (scala.math.BigDecimal)object;
                return builder.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(bigDecimal.precision(), bigDecimal.scale(), bigDecimal.toString(), builder));
            }
            if (object instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)object;
                return builder.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(bigDecimal.precision(), bigDecimal.scale(), bigDecimal.toString(), builder));
            }
            if (object instanceof String) {
                String string = (String)object;
                return builder.setString(string);
            }
            if (object instanceof Character) {
                char c = BoxesRunTime.unboxToChar((Object)object);
                return builder.setString(Character.toString(c));
            }
            if (object instanceof char[]) {
                char[] cArray = (char[])object;
                return builder.setString(String.valueOf(cArray));
            }
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                return builder.setBinary(ByteString.copyFrom((byte[])byArray));
            }
            if (object instanceof scala.collection.mutable.ArraySeq) {
                scala.collection.mutable.ArraySeq arraySeq = (scala.collection.mutable.ArraySeq)object;
                literal = arraySeq.array();
                continue;
            }
            if (!(object instanceof ArraySeq)) break;
            ArraySeq arraySeq = (ArraySeq)object;
            literal = arraySeq.unsafeArray();
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return builder.setDate((int)localDate.toEpochDay());
        }
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            return builder.setDecimal(LiteralValueProtoConverter$.decimalBuilder$1(Math.max(decimal.precision(), decimal.scale()), decimal.scale(), decimal.toString(), builder));
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return builder.setTimestamp(SparkDateTimeUtils$.MODULE$.instantToMicros(instant));
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return builder.setTimestamp(SparkDateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp));
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return builder.setTimestampNtz(SparkDateTimeUtils$.MODULE$.localDateTimeToMicros(localDateTime));
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return builder.setDate(SparkDateTimeUtils$.MODULE$.fromJavaDate(date));
        }
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            return builder.setDayTimeInterval(SparkIntervalUtils$.MODULE$.durationToMicros(duration));
        }
        if (object instanceof Period) {
            Period period = (Period)object;
            return builder.setYearMonthInterval(SparkIntervalUtils$.MODULE$.periodToMonths(period));
        }
        if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            return builder.setTime(builder.getTimeBuilder().setNano(SparkDateTimeUtils$.MODULE$.localTimeToNanos(localTime)).setPrecision(TimeType$.MODULE$.DEFAULT_PRECISION()));
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            return builder.setArray(this.arrayBuilder$1(object2, builder, options));
        }
        if (object instanceof CalendarInterval) {
            CalendarInterval calendarInterval = (CalendarInterval)object;
            return builder.setCalendarInterval(LiteralValueProtoConverter$.calendarIntervalBuilder$1(calendarInterval.months, calendarInterval.days, calendarInterval.microseconds, builder));
        }
        if (object == null) {
            return builder.setNull(ProtoDataTypes$.MODULE$.NullType());
        }
        throw new UnsupportedOperationException("literal " + literal + " not supported (yet).");
    }

    private Expression.Literal.Builder toLiteralProtoBuilderInternal(Object literal, org.apache.spark.sql.types.DataType dataType, LiteralValueProtoConverter.ToLiteralProtoOptions options) {
        Tuple2 tuple2;
        Expression.Literal.Builder builder;
        while (true) {
            Object object;
            Object v;
            builder = Expression.Literal.newBuilder();
            tuple2 = new Tuple2(literal, (Object)dataType);
            if (tuple2 != null && (v = tuple2._1()) instanceof Option) {
                Option option = (Option)v;
                if (option.isDefined()) {
                    literal = option.get();
                    continue;
                }
                return this.setNullValue(builder, dataType, options.useDeprecatedDataTypeFields());
            }
            if (tuple2 != null && (object = tuple2._1()) == null) {
                return this.setNullValue(builder, dataType, options.useDeprecatedDataTypeFields());
            }
            if (tuple2 != null) {
                Object v2 = tuple2._1();
                org.apache.spark.sql.types.DataType dataType2 = (org.apache.spark.sql.types.DataType)tuple2._2();
                if (v2 instanceof scala.collection.mutable.ArraySeq) {
                    scala.collection.mutable.ArraySeq arraySeq = (scala.collection.mutable.ArraySeq)v2;
                    if (dataType2 instanceof ArrayType) {
                        literal = arraySeq.array();
                        continue;
                    }
                }
            }
            if (tuple2 == null) break;
            Object v3 = tuple2._1();
            org.apache.spark.sql.types.DataType dataType3 = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (!(v3 instanceof ArraySeq)) break;
            ArraySeq arraySeq = (ArraySeq)v3;
            if (!(dataType3 instanceof ArrayType)) break;
            literal = arraySeq.unsafeArray();
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType dataType4 = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (v instanceof byte[]) {
                byte[] byArray = (byte[])v;
                if (dataType4 instanceof ArrayType) {
                    return this.toLiteralProtoBuilderInternal(byArray, options);
                }
            }
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType dataType5 = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (dataType5 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType5;
                org.apache.spark.sql.types.DataType elementType = arrayType.elementType();
                return builder.setArray(LiteralValueProtoConverter$.arrayBuilder$2(v, elementType, builder, options));
            }
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType dataType6 = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (dataType6 instanceof MapType) {
                MapType mapType = (MapType)dataType6;
                org.apache.spark.sql.types.DataType keyType = mapType.keyType();
                org.apache.spark.sql.types.DataType valueType = mapType.valueType();
                return builder.setMap(LiteralValueProtoConverter$.mapBuilder$1(v, keyType, valueType, builder, options));
            }
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType structType = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (structType instanceof StructType) {
                StructType structType2 = (StructType)structType;
                return builder.setStruct(this.structBuilder$1(v, structType2, builder, options));
            }
        }
        if (tuple2 != null) {
            Object v = tuple2._1();
            org.apache.spark.sql.types.DataType timeType = (org.apache.spark.sql.types.DataType)tuple2._2();
            if (v instanceof LocalTime) {
                LocalTime localTime = (LocalTime)v;
                if (timeType instanceof TimeType) {
                    TimeType timeType2 = (TimeType)timeType;
                    return builder.setTime(builder.getTimeBuilder().setNano(SparkDateTimeUtils$.MODULE$.localTimeToNanos(localTime)).setPrecision(timeType2.precision()));
                }
            }
        }
        return this.toLiteralProtoBuilderInternal(literal, options);
    }

    public Expression.Literal.Builder toLiteralProtoBuilder(Object literal) {
        return this.toLiteralProtoBuilderWithOptions(literal, (Option<org.apache.spark.sql.types.DataType>)None$.MODULE$, new LiteralValueProtoConverter.ToLiteralProtoOptions(true));
    }

    public Expression.Literal.Builder toLiteralProtoBuilder(Object literal, org.apache.spark.sql.types.DataType dataType) {
        return this.toLiteralProtoBuilderWithOptions(literal, (Option<org.apache.spark.sql.types.DataType>)new Some((Object)dataType), new LiteralValueProtoConverter.ToLiteralProtoOptions(true));
    }

    private Expression.Literal.Builder setDataTypeForRootLiteral(Expression.Literal.Builder builder, org.apache.spark.sql.types.DataType dataType) {
        boolean bl;
        Expression.Literal.LiteralTypeCase literalTypeCase = builder.getLiteralTypeCase();
        Expression.Literal.LiteralTypeCase literalTypeCase2 = Expression.Literal.LiteralTypeCase.LITERALTYPE_NOT_SET;
        if (!(literalTypeCase != null ? !((Object)((Object)literalTypeCase)).equals((Object)literalTypeCase2) : literalTypeCase2 != null)) {
            throw new IllegalArgumentException("Literal type should be set first");
        }
        DataType protoDataType = DataTypeProtoConverter$.MODULE$.toConnectProtoType(dataType, true);
        DataType.KindCase kindCase = protoDataType.getKindCase();
        if (((Object)((Object)DataType.KindCase.ARRAY)).equals((Object)kindCase)) {
            bl = true;
        } else if (((Object)((Object)DataType.KindCase.STRUCT)).equals((Object)kindCase)) {
            bl = true;
        } else if (((Object)((Object)DataType.KindCase.MAP)).equals((Object)kindCase)) {
            bl = true;
        } else {
            Expression.Literal.LiteralTypeCase literalTypeCase3 = builder.getLiteralTypeCase();
            Expression.Literal.LiteralTypeCase literalTypeCase4 = Expression.Literal.LiteralTypeCase.NULL;
            bl = !(literalTypeCase3 != null ? !((Object)((Object)literalTypeCase3)).equals((Object)literalTypeCase4) : literalTypeCase4 != null);
        }
        boolean needDataType = bl;
        Object object = needDataType ? builder.setDataType(protoDataType) : BoxedUnit.UNIT;
        return builder;
    }

    public Expression.Literal.Builder toLiteralProtoBuilderWithOptions(Object literal, Option<org.apache.spark.sql.types.DataType> dataTypeOpt, LiteralValueProtoConverter.ToLiteralProtoOptions options) {
        Option<org.apache.spark.sql.types.DataType> option = dataTypeOpt;
        if (option instanceof Some) {
            Some some = (Some)option;
            org.apache.spark.sql.types.DataType dataType = (org.apache.spark.sql.types.DataType)some.value();
            Expression.Literal.Builder builder = this.toLiteralProtoBuilderInternal(literal, dataType, options);
            Object object = !options.useDeprecatedDataTypeFields() ? this.setDataTypeForRootLiteral(builder, dataType) : BoxedUnit.UNIT;
            return builder;
        }
        if (None$.MODULE$.equals(option)) {
            Object object;
            Expression.Literal.Builder builder = this.toLiteralProtoBuilderInternal(literal, options);
            Object object2 = !options.useDeprecatedDataTypeFields() ? ((object = this.unwrapArraySeq$1(literal)) == null ? this.setDataTypeForRootLiteral(builder, (org.apache.spark.sql.types.DataType)NullType$.MODULE$) : this.setDataTypeForRootLiteral(builder, this.toDataType(object.getClass()))) : BoxedUnit.UNIT;
            return builder;
        }
        throw new MatchError(option);
    }

    public <T> Expression.Literal.Builder create(T v, TypeTags.TypeTag<T> evidence$1) {
        return (Expression.Literal.Builder)Try$.MODULE$.apply((Function0 & Serializable)() -> {
            ScalaReflection.Schema schema = ScalaReflection$.MODULE$.schemaFor(evidence$1);
            if (schema == null) {
                throw new MatchError((Object)schema);
            }
            org.apache.spark.sql.types.DataType dataType = schema.dataType();
            org.apache.spark.sql.types.DataType dataType2 = dataType;
            return MODULE$.toLiteralProtoBuilder(v, dataType2);
        }).getOrElse((Function0 & Serializable)() -> MODULE$.toLiteralProtoBuilder(v));
    }

    public Expression.Literal toLiteralProto(Object literal) {
        return this.toLiteralProtoWithOptions(literal, (Option<org.apache.spark.sql.types.DataType>)None$.MODULE$, new LiteralValueProtoConverter.ToLiteralProtoOptions(true));
    }

    public Expression.Literal toLiteralProto(Object literal, org.apache.spark.sql.types.DataType dataType) {
        return this.toLiteralProtoWithOptions(literal, (Option<org.apache.spark.sql.types.DataType>)new Some((Object)dataType), new LiteralValueProtoConverter.ToLiteralProtoOptions(true));
    }

    public Expression.Literal toLiteralProtoWithOptions(Object literal, Option<org.apache.spark.sql.types.DataType> dataTypeOpt, LiteralValueProtoConverter.ToLiteralProtoOptions options) {
        return this.toLiteralProtoBuilderWithOptions(literal, dataTypeOpt, options).build();
    }

    public org.apache.spark.sql.types.DataType toDataType(Class<?> clz) {
        block38: {
            block37: {
                block36: {
                    block35: {
                        Class<?> clazz = clz;
                        Class<Short> clazz2 = Short.TYPE;
                        Class<?> clazz3 = clazz;
                        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
                            return ShortType$.MODULE$;
                        }
                        Class<Integer> clazz4 = Integer.TYPE;
                        Class<?> clazz5 = clazz;
                        if (!(clazz4 != null ? !clazz4.equals(clazz5) : clazz5 != null)) {
                            return IntegerType$.MODULE$;
                        }
                        Class<Long> clazz6 = Long.TYPE;
                        Class<?> clazz7 = clazz;
                        if (!(clazz6 != null ? !clazz6.equals(clazz7) : clazz7 != null)) {
                            return LongType$.MODULE$;
                        }
                        Class<Double> clazz8 = Double.TYPE;
                        Class<?> clazz9 = clazz;
                        if (!(clazz8 != null ? !clazz8.equals(clazz9) : clazz9 != null)) {
                            return DoubleType$.MODULE$;
                        }
                        Class<Byte> clazz10 = Byte.TYPE;
                        Class<?> clazz11 = clazz;
                        if (!(clazz10 != null ? !clazz10.equals(clazz11) : clazz11 != null)) {
                            return ByteType$.MODULE$;
                        }
                        Class<Float> clazz12 = Float.TYPE;
                        Class<?> clazz13 = clazz;
                        if (!(clazz12 != null ? !clazz12.equals(clazz13) : clazz13 != null)) {
                            return FloatType$.MODULE$;
                        }
                        Class<Boolean> clazz14 = Boolean.TYPE;
                        Class<?> clazz15 = clazz;
                        if (!(clazz14 != null ? !clazz14.equals(clazz15) : clazz15 != null)) {
                            return BooleanType$.MODULE$;
                        }
                        Class<Character> clazz16 = Character.TYPE;
                        Class<?> clazz17 = clazz;
                        if (!(clazz16 != null ? !clazz16.equals(clazz17) : clazz17 != null)) {
                            return StringType$.MODULE$;
                        }
                        Class<?> clazz18 = clz;
                        Class<LocalDate> clazz19 = LocalDate.class;
                        if (!(clazz18 == null ? clazz19 != null : !clazz18.equals(clazz19))) break block35;
                        Class<?> clazz20 = clz;
                        Class<Date> clazz21 = Date.class;
                        if (clazz20 != null ? !clazz20.equals(clazz21) : clazz21 != null) break block36;
                    }
                    return DateType$.MODULE$;
                }
                Class<?> clazz = clz;
                Class<Instant> clazz22 = Instant.class;
                if (!(clazz == null ? clazz22 != null : !clazz.equals(clazz22))) break block37;
                Class<?> clazz23 = clz;
                Class<Timestamp> clazz24 = Timestamp.class;
                if (clazz23 != null ? !clazz23.equals(clazz24) : clazz24 != null) break block38;
            }
            return TimestampType$.MODULE$;
        }
        Class<?> clazz = clz;
        Class<LocalDateTime> clazz25 = LocalDateTime.class;
        if (!(clazz != null ? !clazz.equals(clazz25) : clazz25 != null)) {
            return TimestampNTZType$.MODULE$;
        }
        Class<?> clazz26 = clz;
        Class<LocalTime> clazz27 = LocalTime.class;
        if (!(clazz26 != null ? !clazz26.equals(clazz27) : clazz27 != null)) {
            return new TimeType(TimeType$.MODULE$.DEFAULT_PRECISION());
        }
        Class<?> clazz28 = clz;
        Class<Duration> clazz29 = Duration.class;
        if (!(clazz28 != null ? !clazz28.equals(clazz29) : clazz29 != null)) {
            return DayTimeIntervalType$.MODULE$.DEFAULT();
        }
        Class<?> clazz30 = clz;
        Class<Period> clazz31 = Period.class;
        if (!(clazz30 != null ? !clazz30.equals(clazz31) : clazz31 != null)) {
            return YearMonthIntervalType$.MODULE$.DEFAULT();
        }
        Class<?> clazz32 = clz;
        Class<BigDecimal> clazz33 = BigDecimal.class;
        if (!(clazz32 != null ? !clazz32.equals(clazz33) : clazz33 != null)) {
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz34 = clz;
        Class<byte[]> clazz35 = byte[].class;
        if (!(clazz34 != null ? !clazz34.equals(clazz35) : clazz35 != null)) {
            return BinaryType$.MODULE$;
        }
        Class<?> clazz36 = clz;
        Class<char[]> clazz37 = char[].class;
        if (!(clazz36 != null ? !clazz36.equals(clazz37) : clazz37 != null)) {
            return StringType$.MODULE$;
        }
        Class<?> clazz38 = clz;
        Class<Short> clazz39 = Short.class;
        if (!(clazz38 != null ? !clazz38.equals(clazz39) : clazz39 != null)) {
            return ShortType$.MODULE$;
        }
        Class<?> clazz40 = clz;
        Class<Integer> clazz41 = Integer.class;
        if (!(clazz40 != null ? !clazz40.equals(clazz41) : clazz41 != null)) {
            return IntegerType$.MODULE$;
        }
        Class<?> clazz42 = clz;
        Class<Long> clazz43 = Long.class;
        if (!(clazz42 != null ? !clazz42.equals(clazz43) : clazz43 != null)) {
            return LongType$.MODULE$;
        }
        Class<?> clazz44 = clz;
        Class<Double> clazz45 = Double.class;
        if (!(clazz44 != null ? !clazz44.equals(clazz45) : clazz45 != null)) {
            return DoubleType$.MODULE$;
        }
        Class<?> clazz46 = clz;
        Class<Byte> clazz47 = Byte.class;
        if (!(clazz46 != null ? !clazz46.equals(clazz47) : clazz47 != null)) {
            return ByteType$.MODULE$;
        }
        Class<?> clazz48 = clz;
        Class<Float> clazz49 = Float.class;
        if (!(clazz48 != null ? !clazz48.equals(clazz49) : clazz49 != null)) {
            return FloatType$.MODULE$;
        }
        Class<?> clazz50 = clz;
        Class<Boolean> clazz51 = Boolean.class;
        if (!(clazz50 != null ? !clazz50.equals(clazz51) : clazz51 != null)) {
            return BooleanType$.MODULE$;
        }
        Class<?> clazz52 = clz;
        Class<Character> clazz53 = Character.class;
        if (!(clazz52 != null ? !clazz52.equals(clazz53) : clazz53 != null)) {
            return StringType$.MODULE$;
        }
        Class<?> clazz54 = clz;
        Class<String> clazz55 = String.class;
        if (!(clazz54 != null ? !clazz54.equals(clazz55) : clazz55 != null)) {
            return StringType$.MODULE$;
        }
        Class<?> clazz56 = clz;
        Class<BigInt> clazz57 = BigInt.class;
        if (!(clazz56 != null ? !clazz56.equals(clazz57) : clazz57 != null)) {
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz58 = clz;
        Class<scala.math.BigDecimal> clazz59 = scala.math.BigDecimal.class;
        if (!(clazz58 != null ? !clazz58.equals(clazz59) : clazz59 != null)) {
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz60 = clz;
        Class<Decimal> clazz61 = Decimal.class;
        if (!(clazz60 != null ? !clazz60.equals(clazz61) : clazz61 != null)) {
            return DecimalType$.MODULE$.SYSTEM_DEFAULT();
        }
        Class<?> clazz62 = clz;
        Class<CalendarInterval> clazz63 = CalendarInterval.class;
        if (!(clazz62 != null ? !clazz62.equals(clazz63) : clazz63 != null)) {
            return CalendarIntervalType$.MODULE$;
        }
        if (clz.isArray()) {
            return ArrayType$.MODULE$.apply(this.toDataType(clz.getComponentType()));
        }
        throw new UnsupportedOperationException("Unsupported component type " + clz + " in arrays.");
    }

    public Object toScalaValue(Expression.Literal literal) {
        return this.getScalaConverter(this.getProtoDataType(literal)).apply((Object)literal);
    }

    private Function1<Expression.Literal, Object> getScalaConverter(DataType dataType) {
        Function1 & Serializable intersect;
        DataType.KindCase kindCase = dataType.getKindCase();
        if (((Object)((Object)DataType.KindCase.NULL)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> {
                throw InvalidPlanInput$.MODULE$.apply("Expected null value, but got " + v.getLiteralTypeCase());
            };
        } else if (((Object)((Object)DataType.KindCase.SHORT)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToShort((short)LiteralValueProtoConverter$.$anonfun$getScalaConverter$2(v));
        } else if (((Object)((Object)DataType.KindCase.INTEGER)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToInteger((int)v.getInteger());
        } else if (((Object)((Object)DataType.KindCase.LONG)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToLong((long)v.getLong());
        } else if (((Object)((Object)DataType.KindCase.DOUBLE)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToDouble((double)v.getDouble());
        } else if (((Object)((Object)DataType.KindCase.BYTE)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToByte((byte)LiteralValueProtoConverter$.$anonfun$getScalaConverter$6(v));
        } else if (((Object)((Object)DataType.KindCase.FLOAT)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToFloat((float)v.getFloat());
        } else if (((Object)((Object)DataType.KindCase.BOOLEAN)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> BoxesRunTime.boxToBoolean((boolean)v.getBoolean());
        } else if (((Object)((Object)DataType.KindCase.STRING)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> v.getString();
        } else if (((Object)((Object)DataType.KindCase.BINARY)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> v.getBinary().toByteArray();
        } else if (((Object)((Object)DataType.KindCase.DATE)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> SparkDateTimeUtils$.MODULE$.toJavaDate(v.getDate());
        } else if (((Object)((Object)DataType.KindCase.TIMESTAMP)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> SparkDateTimeUtils$.MODULE$.toJavaTimestamp(v.getTimestamp());
        } else if (((Object)((Object)DataType.KindCase.TIMESTAMP_NTZ)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> SparkDateTimeUtils$.MODULE$.microsToLocalDateTime(v.getTimestampNtz());
        } else if (((Object)((Object)DataType.KindCase.DAY_TIME_INTERVAL)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> SparkIntervalUtils$.MODULE$.microsToDuration(v.getDayTimeInterval());
        } else if (((Object)((Object)DataType.KindCase.YEAR_MONTH_INTERVAL)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> SparkIntervalUtils$.MODULE$.monthsToPeriod(v.getYearMonthInterval());
        } else if (((Object)((Object)DataType.KindCase.TIME)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> SparkDateTimeUtils$.MODULE$.nanosToLocalTime(v.getTime().getNano());
        } else if (((Object)((Object)DataType.KindCase.DECIMAL)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> Decimal$.MODULE$.apply(v.getDecimal().getValue());
        } else if (((Object)((Object)DataType.KindCase.CALENDAR_INTERVAL)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> {
                Expression.Literal.CalendarInterval interval = v.getCalendarInterval();
                return new CalendarInterval(interval.getMonths(), interval.getDays(), interval.getMicroseconds());
            };
        } else if (((Object)((Object)DataType.KindCase.ARRAY)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> MODULE$.toScalaArrayInternal((Expression.Literal)v, dataType.getArray());
        } else if (((Object)((Object)DataType.KindCase.MAP)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> MODULE$.toScalaMapInternal((Expression.Literal)v, dataType.getMap());
        } else if (((Object)((Object)DataType.KindCase.STRUCT)).equals((Object)kindCase)) {
            intersect = (Function1 & Serializable)v -> MODULE$.toScalaStructInternal((Expression.Literal)v, dataType.getStruct());
        } else {
            throw InvalidPlanInput$.MODULE$.apply("Unsupported Literal Type: " + dataType.getKindCase());
        }
        Function1 & Serializable converter = intersect;
        return (Function1 & Serializable)v -> {
            if (v.hasNull()) {
                return null;
            }
            return converter.apply(v);
        };
    }

    private boolean isCompatible(Expression.Literal.LiteralTypeCase literalTypeCase, DataType.KindCase dataTypeCase) {
        Expression.Literal.LiteralTypeCase literalTypeCase2;
        Tuple2 tuple2 = new Tuple2((Object)literalTypeCase, (Object)dataTypeCase);
        if (tuple2 != null && ((Object)((Object)Expression.Literal.LiteralTypeCase.NULL)).equals((Object)(literalTypeCase2 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1())))) {
            return true;
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase3 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.BINARY)).equals((Object)literalTypeCase3) && ((Object)((Object)DataType.KindCase.BINARY)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase4 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.BOOLEAN)).equals((Object)literalTypeCase4) && ((Object)((Object)DataType.KindCase.BOOLEAN)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase5 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.BYTE)).equals((Object)literalTypeCase5) && ((Object)((Object)DataType.KindCase.BYTE)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase6 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.SHORT)).equals((Object)literalTypeCase6) && ((Object)((Object)DataType.KindCase.SHORT)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase7 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.INTEGER)).equals((Object)literalTypeCase7) && ((Object)((Object)DataType.KindCase.INTEGER)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase8 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.LONG)).equals((Object)literalTypeCase8) && ((Object)((Object)DataType.KindCase.LONG)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase9 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.FLOAT)).equals((Object)literalTypeCase9) && ((Object)((Object)DataType.KindCase.FLOAT)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase10 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.DOUBLE)).equals((Object)literalTypeCase10) && ((Object)((Object)DataType.KindCase.DOUBLE)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase11 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.DECIMAL)).equals((Object)literalTypeCase11) && ((Object)((Object)DataType.KindCase.DECIMAL)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase12 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.STRING)).equals((Object)literalTypeCase12) && ((Object)((Object)DataType.KindCase.STRING)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase13 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.DATE)).equals((Object)literalTypeCase13) && ((Object)((Object)DataType.KindCase.DATE)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase14 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.TIMESTAMP)).equals((Object)literalTypeCase14) && ((Object)((Object)DataType.KindCase.TIMESTAMP)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase15 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.TIMESTAMP_NTZ)).equals((Object)literalTypeCase15) && ((Object)((Object)DataType.KindCase.TIMESTAMP_NTZ)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase16 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.CALENDAR_INTERVAL)).equals((Object)literalTypeCase16) && ((Object)((Object)DataType.KindCase.CALENDAR_INTERVAL)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase17 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.DAY_TIME_INTERVAL)).equals((Object)literalTypeCase17) && ((Object)((Object)DataType.KindCase.DAY_TIME_INTERVAL)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase18 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.YEAR_MONTH_INTERVAL)).equals((Object)literalTypeCase18) && ((Object)((Object)DataType.KindCase.YEAR_MONTH_INTERVAL)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase19 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.TIME)).equals((Object)literalTypeCase19) && ((Object)((Object)DataType.KindCase.TIME)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase20 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.ARRAY)).equals((Object)literalTypeCase20) && ((Object)((Object)DataType.KindCase.ARRAY)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase21 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.MAP)).equals((Object)literalTypeCase21) && ((Object)((Object)DataType.KindCase.MAP)).equals((Object)kindCase)) {
                return true;
            }
        }
        if (tuple2 != null) {
            Expression.Literal.LiteralTypeCase literalTypeCase22 = (Expression.Literal.LiteralTypeCase)((Object)tuple2._1());
            DataType.KindCase kindCase = (DataType.KindCase)((Object)tuple2._2());
            if (((Object)((Object)Expression.Literal.LiteralTypeCase.STRUCT)).equals((Object)literalTypeCase22) && ((Object)((Object)DataType.KindCase.STRUCT)).equals((Object)kindCase)) {
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DataType getProtoDataType(Expression.Literal literal) {
        DataType dataType;
        if (literal.hasDataType()) {
            v0 = literal.getDataType();
        } else {
            Expression.Literal.LiteralTypeCase literalTypeCase = literal.getLiteralTypeCase();
            Expression.Literal.LiteralTypeCase literalTypeCase2 = Expression.Literal.LiteralTypeCase.NULL;
            if (!(literalTypeCase != null ? !((Object)((Object)literalTypeCase)).equals((Object)literalTypeCase2) : literalTypeCase2 != null)) {
                v0 = literal.getNull();
            } else {
                DataType.Builder builder = DataType.newBuilder();
                Expression.Literal.LiteralTypeCase literalTypeCase3 = literal.getLiteralTypeCase();
                if (((Object)((Object)Expression.Literal.LiteralTypeCase.BINARY)).equals((Object)literalTypeCase3)) {
                    builder.setBinary(DataType.Binary.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.BOOLEAN)).equals((Object)literalTypeCase3)) {
                    builder.setBoolean(DataType.Boolean.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.BYTE)).equals((Object)literalTypeCase3)) {
                    builder.setByte(DataType.Byte.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.SHORT)).equals((Object)literalTypeCase3)) {
                    builder.setShort(DataType.Short.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.INTEGER)).equals((Object)literalTypeCase3)) {
                    builder.setInteger(DataType.Integer.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.LONG)).equals((Object)literalTypeCase3)) {
                    builder.setLong(DataType.Long.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.FLOAT)).equals((Object)literalTypeCase3)) {
                    builder.setFloat(DataType.Float.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.DOUBLE)).equals((Object)literalTypeCase3)) {
                    builder.setDouble(DataType.Double.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.DECIMAL)).equals((Object)literalTypeCase3)) {
                    Decimal decimal = Decimal$.MODULE$.apply(literal.getDecimal().getValue());
                    int precision = decimal.precision();
                    if (literal.getDecimal().hasPrecision()) {
                        precision = package$.MODULE$.max(precision, literal.getDecimal().getPrecision());
                    }
                    int scale = decimal.scale();
                    if (literal.getDecimal().hasScale()) {
                        scale = package$.MODULE$.max(scale, literal.getDecimal().getScale());
                    }
                    builder.setDecimal(DataType.Decimal.newBuilder().setPrecision(package$.MODULE$.max(precision, scale)).setScale(scale).build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.STRING)).equals((Object)literalTypeCase3)) {
                    builder.setString(DataType.String.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.DATE)).equals((Object)literalTypeCase3)) {
                    builder.setDate(DataType.Date.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.TIMESTAMP)).equals((Object)literalTypeCase3)) {
                    builder.setTimestamp(DataType.Timestamp.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.TIMESTAMP_NTZ)).equals((Object)literalTypeCase3)) {
                    builder.setTimestampNtz(DataType.TimestampNTZ.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.CALENDAR_INTERVAL)).equals((Object)literalTypeCase3)) {
                    builder.setCalendarInterval(DataType.CalendarInterval.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.YEAR_MONTH_INTERVAL)).equals((Object)literalTypeCase3)) {
                    builder.setYearMonthInterval(DataType.YearMonthInterval.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.DAY_TIME_INTERVAL)).equals((Object)literalTypeCase3)) {
                    builder.setDayTimeInterval(DataType.DayTimeInterval.newBuilder().build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.TIME)).equals((Object)literalTypeCase3)) {
                    DataType.Time.Builder timeBuilder = DataType.Time.newBuilder();
                    Object object = literal.getTime().hasPrecision() ? timeBuilder.setPrecision(literal.getTime().getPrecision()) : BoxedUnit.UNIT;
                    builder.setTime(timeBuilder.build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.ARRAY)).equals((Object)literalTypeCase3)) {
                    if (!literal.getArray().hasElementType()) throw InvalidPlanInput$.MODULE$.apply("Data type information is missing in the array literal.");
                    builder.setArray(DataType.Array.newBuilder().setElementType(literal.getArray().getElementType()).setContainsNull(true).build());
                } else if (((Object)((Object)Expression.Literal.LiteralTypeCase.MAP)).equals((Object)literalTypeCase3)) {
                    if (!literal.getMap().hasKeyType() || !literal.getMap().hasValueType()) throw InvalidPlanInput$.MODULE$.apply("Data type information is missing in the map literal.");
                    builder.setMap(DataType.Map.newBuilder().setKeyType(literal.getMap().getKeyType()).setValueType(literal.getMap().getValueType()).setValueContainsNull(true).build());
                } else {
                    if (!((Object)((Object)Expression.Literal.LiteralTypeCase.STRUCT)).equals((Object)literalTypeCase3)) throw InvalidPlanInput$.MODULE$.apply("Unsupported Literal Type: " + literal.getLiteralTypeCase().name() + "(" + literal.getLiteralTypeCase().getNumber() + ")");
                    if (!literal.getStruct().hasStructType()) throw InvalidPlanInput$.MODULE$.apply("Data type information is missing in the struct literal.");
                    builder.setStruct(literal.getStruct().getStructType().getStruct());
                }
                v0 = dataType = builder.build();
            }
        }
        if (this.isCompatible(literal.getLiteralTypeCase(), dataType.getKindCase())) return dataType;
        throw InvalidPlanInput$.MODULE$.apply("Incompatible data type " + dataType.getKindCase() + " for literal " + literal.getLiteralTypeCase());
    }

    private Object toScalaArrayInternal(Expression.Literal literal, DataType.Array arrayType) {
        if (!literal.hasArray()) {
            throw InvalidPlanInput$.MODULE$.apply("Array literal is not set.");
        }
        Expression.Literal.Array array = literal.getArray();
        return LiteralValueProtoConverter$.makeArrayData$1(this.getScalaConverter(arrayType.getElementType()), ClassTag$.MODULE$.Any(), array);
    }

    private scala.collection.mutable.Map<?, ?> toScalaMapInternal(Expression.Literal literal, DataType.Map mapType) {
        if (!literal.hasMap()) {
            throw InvalidPlanInput$.MODULE$.apply("Map literal is not set.");
        }
        Expression.Literal.Map map = literal.getMap();
        return LiteralValueProtoConverter$.makeMapData$1(this.getScalaConverter(mapType.getKeyType()), this.getScalaConverter(mapType.getValueType()), ClassTag$.MODULE$.Any(), ClassTag$.MODULE$.Any(), map);
    }

    private Object toScalaStructInternal(Expression.Literal literal, DataType.Struct structType) {
        if (!literal.hasStruct()) {
            throw InvalidPlanInput$.MODULE$.apply("Struct literal is not set.");
        }
        Expression.Literal.Struct struct = literal.getStruct();
        Object[] structData = (Object[])Array$.MODULE$.tabulate(struct.getElementsCount(), (Function1 & Serializable)i -> LiteralValueProtoConverter$.$anonfun$toScalaStructInternal$1(struct, structType, BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.Any());
        return new GenericRowWithSchema(structData, DataTypeProtoConverter$.MODULE$.toCatalystStructType(structType));
    }

    public org.apache.spark.sql.types.DataType getDataType(Expression.Literal literal) {
        return DataTypeProtoConverter$.MODULE$.toCatalystType(this.getProtoDataType(literal));
    }

    private static final Expression.Literal.Decimal.Builder decimalBuilder$1(int precision, int scale, String value, Expression.Literal.Builder builder$1) {
        return builder$1.getDecimalBuilder().setPrecision(precision).setScale(scale).setValue(value);
    }

    private static final Expression.Literal.CalendarInterval.Builder calendarIntervalBuilder$1(int months, int days, long microseconds, Expression.Literal.Builder builder$1) {
        return builder$1.getCalendarIntervalBuilder().setMonths(months).setDays(days).setMicroseconds(microseconds);
    }

    private final Expression.Literal.Array.Builder arrayBuilder$1(Object array, Expression.Literal.Builder builder$1, LiteralValueProtoConverter.ToLiteralProtoOptions options$1) {
        Expression.Literal.Array.Builder ab = builder$1.getArrayBuilder();
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(array), (Function1 & Serializable)x -> ab.addElements(MODULE$.toLiteralProtoBuilderInternal(x, options$1).build()));
        Object object = options$1.useDeprecatedDataTypeFields() ? ab.setElementType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(this.toDataType(array.getClass().getComponentType()), DataTypeProtoConverter$.MODULE$.toConnectProtoType$default$2())) : BoxedUnit.UNIT;
        return ab;
    }

    private static final Expression.Literal.Array.Builder arrayBuilder$2(Object scalaValue, org.apache.spark.sql.types.DataType elementType, Expression.Literal.Builder builder$2, LiteralValueProtoConverter.ToLiteralProtoOptions options$2) {
        Expression.Literal.Array.Builder ab = builder$2.getArrayBuilder();
        Object object = scalaValue;
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.genericArrayOps(object2), (Function1 & Serializable)item -> ab.addElements(MODULE$.toLiteralProtoBuilderInternal(item, elementType, options$2).build()));
        } else if (object instanceof Seq) {
            Seq seq = (Seq)object;
            seq.foreach((Function1 & Serializable)item -> ab.addElements(MODULE$.toLiteralProtoBuilderInternal(item, elementType, options$2).build()));
        } else {
            throw new IllegalArgumentException("literal " + object + " not supported (yet).");
        }
        Object object3 = options$2.useDeprecatedDataTypeFields() ? ab.setElementType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(elementType, DataTypeProtoConverter$.MODULE$.toConnectProtoType$default$2())) : BoxedUnit.UNIT;
        return ab;
    }

    private static final Expression.Literal.Map.Builder mapBuilder$1(Object scalaValue, org.apache.spark.sql.types.DataType keyType, org.apache.spark.sql.types.DataType valueType, Expression.Literal.Builder builder$2, LiteralValueProtoConverter.ToLiteralProtoOptions options$2) {
        Expression.Literal.Map.Builder mb = builder$2.getMapBuilder();
        Object object = scalaValue;
        if (!(object instanceof Map)) {
            throw new IllegalArgumentException("literal " + object + " not supported (yet).");
        }
        Map map = (Map)object;
        map.foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                Object v = tuple2._2();
                mb.addKeys(MODULE$.toLiteralProtoBuilderInternal(k, keyType, options$2).build());
                return mb.addValues(MODULE$.toLiteralProtoBuilderInternal(v, valueType, options$2).build());
            }
            throw new MatchError((Object)tuple2);
        });
        if (options$2.useDeprecatedDataTypeFields()) {
            mb.setKeyType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(keyType, DataTypeProtoConverter$.MODULE$.toConnectProtoType$default$2()));
            v0 = mb.setValueType(DataTypeProtoConverter$.MODULE$.toConnectProtoType(valueType, DataTypeProtoConverter$.MODULE$.toConnectProtoType$default$2()));
        } else {
            v0 = BoxedUnit.UNIT;
        }
        return mb;
    }

    private final Expression.Literal.Struct.Builder structBuilder$1(Object scalaValue, StructType structType, Expression.Literal.Builder builder$2, LiteralValueProtoConverter.ToLiteralProtoOptions options$2) {
        Iterator iterator;
        Expression.Literal.Struct.Builder sb = builder$2.getStructBuilder();
        StructField[] fields = structType.fields();
        Object object = scalaValue;
        if (object instanceof Product) {
            Product product = (Product)object;
            iterator = product.productIterator();
        } else if (object instanceof Row) {
            Row row = (Row)object;
            iterator = row.toSeq().iterator();
        } else {
            throw new IllegalArgumentException("literal " + object.getClass().getName() + "(" + object + ") not supported (yet).");
        }
        Iterator iter = iterator;
        for (int idx = 0; idx < structType.size(); ++idx) {
            StructField field = fields[idx];
            Expression.Literal.Builder literalProto = this.toLiteralProtoBuilderInternal(iter.next(), field.dataType(), options$2);
            sb.addElements(literalProto);
        }
        Object object2 = options$2.useDeprecatedDataTypeFields() ? sb.setStructType(DataTypeProtoConverter$.MODULE$.toConnectProtoType((org.apache.spark.sql.types.DataType)structType, DataTypeProtoConverter$.MODULE$.toConnectProtoType$default$2())) : BoxedUnit.UNIT;
        return sb;
    }

    private final Object unwrapArraySeq$1(Object value) {
        while (true) {
            Object object;
            if ((object = value) instanceof scala.collection.mutable.ArraySeq) {
                scala.collection.mutable.ArraySeq arraySeq = (scala.collection.mutable.ArraySeq)object;
                value = arraySeq.array();
                continue;
            }
            if (!(object instanceof ArraySeq)) break;
            ArraySeq arraySeq = (ArraySeq)object;
            value = arraySeq.unsafeArray();
        }
        return value;
    }

    public static final /* synthetic */ short $anonfun$getScalaConverter$2(Expression.Literal v) {
        return (short)v.getShort();
    }

    public static final /* synthetic */ byte $anonfun$getScalaConverter$6(Expression.Literal v) {
        return (byte)v.getByte();
    }

    private static final Object makeArrayData$1(Function1 converter, ClassTag tag, Expression.Literal.Array array$1) {
        int size = array$1.getElementsCount();
        if (size > 0) {
            return Array$.MODULE$.tabulate(size, (Function1 & Serializable)i -> converter.apply((Object)array$1.getElements(BoxesRunTime.unboxToInt((Object)i))), tag);
        }
        return Array$.MODULE$.empty(tag);
    }

    public static final /* synthetic */ Tuple2 $anonfun$toScalaMapInternal$1(Function1 keyConverter$1, Expression.Literal.Map map$1, Function1 valueConverter$1, int i) {
        return new Tuple2(keyConverter$1.apply((Object)map$1.getKeys(i)), valueConverter$1.apply((Object)map$1.getValues(i)));
    }

    private static final scala.collection.mutable.Map makeMapData$1(Function1 keyConverter, Function1 valueConverter, ClassTag tagK, ClassTag tagV, Expression.Literal.Map map$1) {
        int size = map$1.getKeysCount();
        if (size > 0) {
            LinkedHashMap m = LinkedHashMap$.MODULE$.empty();
            m.sizeHint(size);
            return (scala.collection.mutable.Map)m.addAll((IterableOnce)scala.package$.MODULE$.Iterator().tabulate(size, (Function1 & Serializable)i -> LiteralValueProtoConverter$.$anonfun$toScalaMapInternal$1(keyConverter, map$1, valueConverter, BoxesRunTime.unboxToInt((Object)i))));
        }
        return (scala.collection.mutable.Map)Map$.MODULE$.empty();
    }

    public static final /* synthetic */ Object $anonfun$toScalaStructInternal$1(Expression.Literal.Struct struct$1, DataType.Struct structType$1, int i) {
        Expression.Literal element = struct$1.getElements(i);
        DataType dataType = structType$1.getFields(i).getDataType();
        return MODULE$.getScalaConverter(dataType).apply((Object)element);
    }

    private LiteralValueProtoConverter$() {
    }
}

