/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.client;

import com.typesafe.tools.mima.core.DirectMissingMethodProblem;
import com.typesafe.tools.mima.core.MissingClassProblem;
import com.typesafe.tools.mima.core.MissingTypesProblem;
import com.typesafe.tools.mima.core.Problem;
import com.typesafe.tools.mima.core.ProblemFilters$;
import com.typesafe.tools.mima.core.ReversedMissingMethodProblem;
import com.typesafe.tools.mima.lib.MiMaLib;
import com.typesafe.tools.mima.lib.MiMaLib$;
import java.io.File;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.spark.SparkBuildInfo$;
import org.apache.spark.sql.connect.client.CheckConnectJvmClientCompatibility;
import org.apache.spark.sql.test.IntegrationTestUtils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class CheckConnectJvmClientCompatibility$ {
    public static final CheckConnectJvmClientCompatibility$ MODULE$ = new CheckConnectJvmClientCompatibility$();
    private static String sparkHome;
    private static final File sqlJar;
    private static final File clientJar;
    private static volatile boolean bitmap$0;

    static {
        Path path = Paths.get(MODULE$.sparkHome(), "sql", "core", "target", new StringBuilder(6).append("scala-").append(IntegrationTestUtils$.MODULE$.scalaVersion()).toString(), new StringBuilder(15).append("spark-sql_").append(IntegrationTestUtils$.MODULE$.scalaVersion()).append("-").append(SparkBuildInfo$.MODULE$.spark_version()).append(".jar").toString());
        Predef$.MODULE$.assert(Files.exists(path, new LinkOption[0]), (Function0 & Serializable)() -> new StringBuilder(15).append(path).append(" does not exist").toString());
        sqlJar = path.toFile();
        Path path2 = Paths.get(MODULE$.sparkHome(), "connector", "connect", "client", "jvm", "target", new StringBuilder(6).append("scala-").append(IntegrationTestUtils$.MODULE$.scalaVersion()).toString(), new StringBuilder(30).append("spark-connect-client-jvm_").append(IntegrationTestUtils$.MODULE$.scalaVersion()).append("-").append(SparkBuildInfo$.MODULE$.spark_version()).append(".jar").toString());
        Predef$.MODULE$.assert(Files.exists(path2, new LinkOption[0]), (Function0 & Serializable)() -> new StringBuilder(15).append(path2).append(" does not exist").toString());
        clientJar = path2.toFile();
    }

    private String sparkHome$lzycompute() {
        CheckConnectJvmClientCompatibility$ checkConnectJvmClientCompatibility$ = this;
        synchronized (checkConnectJvmClientCompatibility$) {
            if (!bitmap$0) {
                if (!scala.sys.package$.MODULE$.env().contains((Object)"SPARK_HOME")) {
                    throw new IllegalArgumentException("SPARK_HOME is not set.");
                }
                sparkHome = (String)scala.sys.package$.MODULE$.env().apply((Object)"SPARK_HOME");
                bitmap$0 = true;
            }
        }
        return sparkHome;
    }

    private String sparkHome() {
        return !bitmap$0 ? this.sparkHome$lzycompute() : sparkHome;
    }

    private File sqlJar() {
        return sqlJar;
    }

    private File clientJar() {
        return clientJar;
    }

    public void main(String[] args) {
        try (Writer resultWriter = null;){
            try {
                resultWriter = Files.newBufferedWriter(Paths.get(new StringBuilder(27).append(this.sparkHome()).append("/.connect-mima-check-result").toString(), new String[0]), StandardCharsets.UTF_8, new OpenOption[0]);
                List<Problem> problemsWithSqlModule = this.checkMiMaCompatibilityWithSqlModule(this.clientJar(), this.sqlJar());
                this.appendMimaCheckErrorMessageIfNeeded(resultWriter, problemsWithSqlModule, this.clientJar(), this.sqlJar(), "Sql", this.appendMimaCheckErrorMessageIfNeeded$default$6());
                List<Problem> problemsWithClientModule = this.checkMiMaCompatibilityWithReversedSqlModule(this.clientJar(), this.sqlJar());
                this.appendMimaCheckErrorMessageIfNeeded(resultWriter, problemsWithClientModule, this.clientJar(), this.sqlJar(), "ReversedSql", "Sql");
                File avroJar = IntegrationTestUtils$.MODULE$.findJar("connector/avro", "spark-avro", "spark-avro", IntegrationTestUtils$.MODULE$.findJar$default$4());
                List<Problem> problemsWithAvroModule = this.checkMiMaCompatibilityWithAvroModule(this.clientJar(), avroJar);
                this.appendMimaCheckErrorMessageIfNeeded(resultWriter, problemsWithAvroModule, this.clientJar(), avroJar, "Avro", this.appendMimaCheckErrorMessageIfNeeded$default$6());
                File protobufJar = IntegrationTestUtils$.MODULE$.findJar("connector/protobuf", "spark-protobuf-assembly", "spark-protobuf", IntegrationTestUtils$.MODULE$.findJar$default$4());
                List<Problem> problemsWithProtobufModule = this.checkMiMaCompatibilityWithProtobufModule(this.clientJar(), protobufJar);
                this.appendMimaCheckErrorMessageIfNeeded(resultWriter, problemsWithProtobufModule, this.clientJar(), protobufJar, "Protobuf", this.appendMimaCheckErrorMessageIfNeeded$default$6());
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)e.getMessage());
                resultWriter.write(new StringBuilder(8).append("ERROR: ").append(e.getMessage()).append("\n").toString());
            }
        }
    }

    private List<Problem> checkMiMaCompatibilityWithAvroModule(File clientJar, File avroJar) {
        Seq includedRules = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CheckConnectJvmClientCompatibility.IncludeByName[]{new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.avro.functions.*")}));
        Seq excludeRules = (Seq)package$.MODULE$.Seq().empty();
        return this.checkMiMaCompatibility(clientJar, avroJar, (Seq<CheckConnectJvmClientCompatibility.IncludeByName>)includedRules, (Seq<Function1<Problem, Object>>)excludeRules);
    }

    private List<Problem> checkMiMaCompatibilityWithProtobufModule(File clientJar, File protobufJar) {
        Seq includedRules = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CheckConnectJvmClientCompatibility.IncludeByName[]{new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.protobuf.functions.*")}));
        Seq excludeRules = (Seq)package$.MODULE$.Seq().empty();
        return this.checkMiMaCompatibility(clientJar, protobufJar, (Seq<CheckConnectJvmClientCompatibility.IncludeByName>)includedRules, (Seq<Function1<Problem, Object>>)excludeRules);
    }

    private List<Problem> checkMiMaCompatibilityWithSqlModule(File clientJar, File sqlJar) {
        Seq includedRules = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CheckConnectJvmClientCompatibility.IncludeByName[]{new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.*")}));
        Seq excludeRules = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.api.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.catalyst.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.columnar.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.connector.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.execution.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.expressions.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.internal.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.jdbc.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.sources.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.ui.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.test.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.util.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.*.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.ExperimentalMethods", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SQLContext", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SQLContext$*", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSessionExtensions", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSessionExtensionsProvider", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.UDTFRegistration", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.UDFRegistration$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataFrameReader.json", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataFrameNaFunctions.fillValue", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.ofRows", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.DATASET_ID_TAG", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.COL_POS_KEY", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.DATASET_ID_KEY", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.curId", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.observe", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Observation", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Observation$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.ObservationListener", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.ObservationListener$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.queryExecution", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.sqlContext", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.metadataColumn", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.selectUntyped", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.rdd", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.toJavaRDD", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.javaRDD", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.functions.unwrap_udt", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.functions.udaf", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.KeyValueGroupedDataset.queryExecution", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.RelationalGroupedDataset$*", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.RelationalGroupedDataset.apply", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.sparkContext", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.sharedState", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.sessionState", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.sqlContext", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.listenerManager", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.experimental", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.udtf", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.createDataFrame", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.baseRelationToDataFrame", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.createDataset", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.executeCommand", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession#implicits._sqlContext", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession#Builder.config", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession#Builder.withExtensions", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.RuntimeConfig$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.DataStreamWriter$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.DataStreamWriter.SOURCE*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryException.message", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryException.cause", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryException.startOffset", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryException.endOffset", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryException.time", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.TestGroupState", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.TestGroupState$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.PythonStreamingQueryListener", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.PythonStreamingQueryListenerWrapper", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryListener$Event", ClassTag$.MODULE$.apply(MissingTypesProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryListener$QueryIdleEvent", ClassTag$.MODULE$.apply(MissingTypesProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryListener#QueryIdleEvent.logEvent", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryListener$QueryProgressEvent", ClassTag$.MODULE$.apply(MissingTypesProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryListener#QueryProgressEvent.logEvent", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryListener$QueryStartedEvent", ClassTag$.MODULE$.apply(MissingTypesProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryListener#QueryStartedEvent.logEvent", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryListener$QueryTerminatedEvent", ClassTag$.MODULE$.apply(MissingTypesProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.StreamingQueryListener#QueryTerminatedEvent.logEvent", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SQLImplicits.rddToDatasetHolder", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SQLImplicits._sqlContext", ClassTag$.MODULE$.apply(Problem.class))}));
        return this.checkMiMaCompatibility(clientJar, sqlJar, (Seq<CheckConnectJvmClientCompatibility.IncludeByName>)includedRules, (Seq<Function1<Problem, Object>>)excludeRules);
    }

    private List<Problem> checkMiMaCompatibilityWithReversedSqlModule(File clientJar, File sqlJar) {
        Seq includedRules = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CheckConnectJvmClientCompatibility.IncludeByName[]{new CheckConnectJvmClientCompatibility.IncludeByName("org.apache.spark.sql.*")}));
        Seq excludeRules = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function1[]{ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.avro.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.connect.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.protobuf.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.*.this", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.DataFrameStatFunctions$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.KeyValueGroupedDatasetImpl", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.KeyValueGroupedDatasetImpl$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SQLImplicits._sqlContext", ClassTag$.MODULE$.apply(ReversedMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.catalyst.util.SparkCollectionUtils", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.catalyst.util.SparkCollectionUtils$", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.expressions.ScalarUserDefinedFunction", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.expressions.ScalarUserDefinedFunction$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.plan", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Dataset.collectResult", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.RuntimeConfig", ClassTag$.MODULE$.apply(MissingTypesProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.RuntimeConfig.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.application.ConnectRepl", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.application.ConnectRepl$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.application.ExtendedCodeClassWrapper", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.application.ExtendedCodeClassWrapper$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.newDataFrame", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.newDataset", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.execute", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.addArtifact", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.addArtifacts", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.registerClassFinder", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.interruptAll", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.interruptTag", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.interruptOperation", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.addTag", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.removeTag", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.getTags", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession.clearTags", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession#Builder.remote", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession#Builder.client", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession#Builder.build", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession#Builder.create", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.SparkSession#Builder.interceptor", ClassTag$.MODULE$.apply(DirectMissingMethodProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.DataStreamWriter", ClassTag$.MODULE$.apply(MissingTypesProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.DataStreamWriter.*", ClassTag$.MODULE$.apply(Problem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.RemoteStreamingQuery", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.streaming.RemoteStreamingQuery$", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Encoders", ClassTag$.MODULE$.apply(MissingClassProblem.class)), ProblemFilters$.MODULE$.exclude("org.apache.spark.sql.Encoders$", ClassTag$.MODULE$.apply(MissingClassProblem.class))}));
        return this.checkMiMaCompatibility(sqlJar, clientJar, (Seq<CheckConnectJvmClientCompatibility.IncludeByName>)includedRules, (Seq<Function1<Problem, Object>>)excludeRules);
    }

    private List<Problem> checkMiMaCompatibility(File newJar, File oldJar, Seq<CheckConnectJvmClientCompatibility.IncludeByName> includedRules, Seq<Function1<Problem, Object>> excludeRules) {
        MiMaLib mima = new MiMaLib((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new File[]{newJar, oldJar})), MiMaLib$.MODULE$.$lessinit$greater$default$2());
        List allProblems = mima.collectProblems(oldJar, newJar, package$.MODULE$.List().empty());
        List problems = allProblems.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)includedRules.exists((Function1 & Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)rule.apply(p))))).filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)excludeRules.forall((Function1 & Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)CheckConnectJvmClientCompatibility$.$anonfun$checkMiMaCompatibility$4(p, rule)))));
        return problems;
    }

    private void appendMimaCheckErrorMessageIfNeeded(Writer resultWriter, List<Problem> problems, File clientModule, File targetModule, String targetName, String description) {
        block0: {
            if (!problems.nonEmpty()) break block0;
            resultWriter.write(new StringBuilder(42).append("ERROR: Comparing Client jar: ").append(clientModule).append(" and ").append(targetName).append(" jar: ").append(targetModule).append(" \n").toString());
            resultWriter.write(new StringBuilder(24).append("problems with ").append(targetName).append(" module: \n").toString());
            resultWriter.write(String.valueOf(problems.map((Function1 & Serializable)p -> (String)p.description().apply((Object)description)).mkString("\n")));
            resultWriter.write("\n");
            resultWriter.write(new StringBuilder(51).append("Exceptions to binary compatibility can be added in ").append(new StringBuilder(70).append("'CheckConnectJvmClientCompatibility#checkMiMaCompatibilityWith").append(targetName).append("Module'\n").toString()).toString());
        }
    }

    private String appendMimaCheckErrorMessageIfNeeded$default$6() {
        return "client";
    }

    public static final /* synthetic */ boolean $anonfun$checkMiMaCompatibility$4(Problem p$2, Function1 rule) {
        return BoxesRunTime.unboxToBoolean((Object)rule.apply((Object)p$2));
    }

    private CheckConnectJvmClientCompatibility$() {
    }
}

