/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.test.SparkConnectServerUtils;
import org.apache.spark.sql.types.StructType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JavaEncoderSuite
implements Serializable {
    private static SparkSession spark;

    @BeforeClass
    public static void setup() {
        spark = SparkConnectServerUtils.createSparkSession();
    }

    @AfterClass
    public static void tearDown() {
        spark.stop();
        spark = null;
        SparkConnectServerUtils.stop();
    }

    private static BigDecimal bigDec(long unscaled, int scale) {
        return BigDecimal.valueOf(unscaled, scale);
    }

    private <T> Dataset<T> dataset(Encoder<T> encoder, T ... elements) {
        return spark.createDataset(Arrays.asList(elements), encoder);
    }

    @Test
    public void testSimpleEncoders() {
        Column v = functions.col((String)"value");
        Assert.assertFalse((boolean)((Boolean)this.dataset(Encoders.BOOLEAN(), false, true, false).select(new Column[]{functions.every((Column)v)}).as(Encoders.BOOLEAN()).head()));
        Assert.assertEquals((long)7L, (long)((Long)this.dataset(Encoders.BYTE(), (byte)-120, (byte)127).select(new Column[]{functions.sum((Column)v)}).as(Encoders.LONG()).head()));
        Assert.assertEquals((long)16L, (long)((Short)this.dataset(Encoders.SHORT(), (short)16, (short)2334).select(new Column[]{functions.min((Column)v)}).as(Encoders.SHORT()).head()).shortValue());
        Assert.assertEquals((long)10L, (long)((Long)this.dataset(Encoders.INT(), 1, 2, 3, 4).select(new Column[]{functions.sum((Column)v)}).as(Encoders.LONG()).head()));
        Assert.assertEquals((long)96L, (long)((Long)this.dataset(Encoders.LONG(), 77L, 19L).select(new Column[]{functions.sum((Column)v)}).as(Encoders.LONG()).head()));
        Assert.assertEquals((float)0.12f, (float)((Float)this.dataset(Encoders.FLOAT(), Float.valueOf(0.12f), Float.valueOf(0.3f), Float.valueOf(44.0f)).select(new Column[]{functions.min((Column)v)}).as(Encoders.FLOAT()).head()).floatValue(), (float)1.0E-4f);
        Assert.assertEquals((double)789.0, (double)((Double)this.dataset(Encoders.DOUBLE(), 789.0, 12.213, 10.01).select(new Column[]{functions.max((Column)v)}).as(Encoders.DOUBLE()).head()), (double)1.0E-4f);
        Assert.assertEquals((Object)JavaEncoderSuite.bigDec(1002L, 2), (Object)((BigDecimal)this.dataset(Encoders.DECIMAL(), JavaEncoderSuite.bigDec(1000L, 2), JavaEncoderSuite.bigDec(2L, 2)).select(new Column[]{functions.sum((Column)v)}).as(Encoders.DECIMAL()).head()).setScale(2));
    }

    @Test
    public void testRowEncoder() {
        StructType schema = new StructType().add("a", "int").add("b", "string");
        Dataset df = spark.range(3L).map((MapFunction)new MapFunction<Long, Row>(){

            public Row call(Long i) {
                return RowFactory.create((Object[])new Object[]{i.intValue(), "s" + i});
            }
        }, Encoders.row((StructType)schema)).filter(functions.col((String)"a").geq((Object)1));
        List<Row> expected = Arrays.asList(RowFactory.create((Object[])new Object[]{1, "s1"}), RowFactory.create((Object[])new Object[]{2, "s2"}));
        Assert.assertEquals(expected, (Object)df.collectAsList());
    }
}

