/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.solr.BaseDistributedSearchTestCase;
import org.apache.solr.cli.ConfigSetUploadTool;
import org.apache.solr.cli.DefaultToolRuntime;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.Tool;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;
import org.apache.solr.client.solrj.response.CollectionAdminResponse;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.Diagnostics;
import org.apache.solr.embedded.JettySolrRunner;
import org.apache.zookeeper.KeeperException;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDistribZkTestBase
extends BaseDistributedSearchTestCase {
    private static final String REMOVE_VERSION_FIELD = "remove.version.field";
    private static final String ENABLE_UPDATE_LOG = "enable.update.log";
    private static final String ZK_HOST = "zkHost";
    private static final String ZOOKEEPER_FORCE_SYNC = "zookeeper.forceSync";
    protected static final String DEFAULT_COLLECTION = "collection1";
    protected volatile ZkTestServer zkServer;
    private final AtomicInteger homeCount = new AtomicInteger();
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @BeforeClass
    public static void beforeThisClass() throws Exception {
    }

    @Override
    public void distribSetUp() throws Exception {
        super.distribSetUp();
        Path zkDir = this.testDir.toPath().resolve("zookeeper/server1/data");
        this.zkServer = new ZkTestServer(zkDir);
        this.zkServer.run();
        System.setProperty(ZK_HOST, this.zkServer.getZkAddress());
        System.setProperty(ENABLE_UPDATE_LOG, "true");
        System.setProperty(REMOVE_VERSION_FIELD, "true");
        System.setProperty(ZOOKEEPER_FORCE_SYNC, "false");
        System.setProperty("solr.tests.allow_reading_files_still_open_for_write", "true");
        String schema = this.getCloudSchemaFile();
        if (schema == null) {
            schema = "schema.xml";
        }
        this.zkServer.buildZooKeeper(this.getCloudSolrConfig(), schema);
        System.setProperty("solr.test.sys.prop1", "propone");
        System.setProperty("solr.test.sys.prop2", "proptwo");
    }

    protected String getCloudSolrConfig() {
        return "solrconfig-tlog.xml";
    }

    protected String getCloudSchemaFile() {
        return AbstractDistribZkTestBase.getSchemaFile();
    }

    @Override
    protected void createServers(int numShards) throws Exception {
        File controlHome = new File(new File(this.getSolrHome()).getParentFile(), "control" + this.homeCount.incrementAndGet());
        FileUtils.copyDirectory((File)new File(this.getSolrHome()), (File)controlHome);
        this.setupJettySolrHome(controlHome);
        this.controlJetty = this.createJetty(controlHome, null);
        this.controlJetty.start();
        this.controlClient = this.createNewSolrClient(this.controlJetty.getLocalPort());
        AbstractDistribZkTestBase.assertTrue((boolean)((CollectionAdminResponse)CollectionAdminRequest.createCollection((String)"control_collection", (int)1, (int)1).setCreateNodeSet(this.controlJetty.getNodeName()).process(this.controlClient)).isSuccess());
        ZkStateReader zkStateReader = ((JettySolrRunner)this.jettys.get(0)).getCoreContainer().getZkController().getZkStateReader();
        AbstractDistribZkTestBase.waitForRecoveriesToFinish("control_collection", zkStateReader, false, true, 15L);
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i <= numShards; ++i) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            File jettyHome = new File(new File(this.getSolrHome()).getParentFile(), "jetty" + this.homeCount.incrementAndGet());
            this.setupJettySolrHome(jettyHome);
            JettySolrRunner j = this.createJetty(jettyHome, null, "shard" + (i + 2));
            j.start();
            this.jettys.add(j);
            this.clients.add(this.createNewSolrClient(j.getLocalPort()));
            sb.append(AbstractDistribZkTestBase.buildUrl(j.getLocalPort()));
        }
        this.shards = sb.toString();
    }

    protected void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose) throws Exception {
        this.waitForRecoveriesToFinish(collection, zkStateReader, verbose, true);
    }

    protected void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose, boolean failOnTimeout) throws Exception {
        AbstractDistribZkTestBase.waitForRecoveriesToFinish(collection, zkStateReader, verbose, failOnTimeout, 330L, TimeUnit.SECONDS);
    }

    public static void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose, boolean failOnTimeout, long timeoutSeconds) throws Exception {
        AbstractDistribZkTestBase.waitForRecoveriesToFinish(collection, zkStateReader, verbose, failOnTimeout, timeoutSeconds, TimeUnit.SECONDS);
    }

    public static void waitForRecoveriesToFinish(String collection, ZkStateReader zkStateReader, boolean verbose, boolean failOnTimeout, long timeout, TimeUnit unit) throws Exception {
        log.info("Wait for recoveries to finish - collection:{} failOnTimeout:{} timeout:{}{}", new Object[]{collection, failOnTimeout, timeout, unit});
        try {
            zkStateReader.waitForState(collection, timeout, unit, (liveNodes, docCollection) -> {
                if (docCollection == null) {
                    return false;
                }
                boolean sawLiveRecovering = false;
                Map slices = docCollection.getSlicesMap();
                AbstractDistribZkTestBase.assertNotNull((String)("Could not find collection:" + collection), (Object)slices);
                for (Map.Entry entry : slices.entrySet()) {
                    Slice slice = (Slice)entry.getValue();
                    if (slice.getState() == Slice.State.CONSTRUCTION) {
                        if (verbose) {
                            System.out.println("Found a slice in construction state; will wait.");
                        }
                        sawLiveRecovering = true;
                    }
                    Map shards = slice.getReplicasMap();
                    for (Map.Entry shard : shards.entrySet()) {
                        Replica.State state;
                        if (verbose) {
                            System.out.println("replica:" + ((Replica)shard.getValue()).getName() + " rstate:" + ((Replica)shard.getValue()).getStr("state") + " live:" + liveNodes.contains(((Replica)shard.getValue()).getNodeName()));
                        }
                        if ((state = ((Replica)shard.getValue()).getState()) != Replica.State.RECOVERING && state != Replica.State.DOWN && state != Replica.State.RECOVERY_FAILED || !liveNodes.contains(((Replica)shard.getValue()).getStr("node_name"))) continue;
                        return false;
                    }
                }
                if (!sawLiveRecovering) {
                    if (verbose) {
                        System.out.println("no one is recoverying");
                    }
                    return true;
                }
                return false;
            });
        }
        catch (InterruptedException | TimeoutException e) {
            Diagnostics.logThreadDumps((String)"Gave up waiting for recovery to finish.  THREAD DUMP:");
            zkStateReader.getZkClient().printLayoutToStream(System.out);
            AbstractDistribZkTestBase.fail((String)("There are still nodes recovering - waited for " + timeout + unit));
        }
        log.info("Recoveries finished - collection:{}", (Object)collection);
    }

    public static void waitForCollectionToDisappear(String collection, ZkStateReader zkStateReader, boolean failOnTimeout, int timeoutSeconds) throws Exception {
        log.info("Wait for collection to disappear - collection: {} failOnTimeout:{} timeout (sec):{}", new Object[]{collection, failOnTimeout, timeoutSeconds});
        zkStateReader.waitForState(collection, (long)timeoutSeconds, TimeUnit.SECONDS, docCollection -> docCollection == null);
        log.info("Collection has disappeared - collection:{}", (Object)collection);
    }

    static void waitForNewLeader(CloudSolrClient cloudClient, String shardName, Replica oldLeader) throws Exception {
        log.info("Will wait for a node to become leader for 15 secs");
        ZkStateReader zkStateReader = ZkStateReader.from((CloudSolrClient)cloudClient);
        long startNs = System.nanoTime();
        try {
            zkStateReader.waitForState(DEFAULT_COLLECTION, 15L, TimeUnit.SECONDS, docCollection -> {
                if (docCollection == null) {
                    return false;
                }
                Slice slice = docCollection.getSlice(shardName);
                if (slice != null && slice.getLeader() != null && !slice.getLeader().equals((Object)oldLeader) && slice.getLeader().getState() == Replica.State.ACTIVE) {
                    if (log.isInfoEnabled()) {
                        log.info("Old leader {}, new leader {}. New leader got elected in {} ms", new Object[]{oldLeader, slice.getLeader(), TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNs)});
                    }
                    return true;
                }
                return false;
            });
        }
        catch (TimeoutException e) {
            Diagnostics.logThreadDumps((String)"Could not find new leader in specified timeout");
            zkStateReader.getZkClient().printLayoutToStream(System.out);
            AbstractDistribZkTestBase.fail((String)"Could not find new leader even after waiting for 15s");
        }
    }

    public static void verifyReplicaStatus(ZkStateReader reader, String collection, String shard, String coreNodeName, Replica.State expectedState) throws InterruptedException, TimeoutException {
        log.info("verifyReplicaStatus ({}) shard={} coreNodeName={}", new Object[]{collection, shard, coreNodeName});
        reader.waitForState(collection, 15000L, TimeUnit.MILLISECONDS, collectionState -> collectionState != null && collectionState.getSlice(shard) != null && collectionState.getSlice(shard).getReplicasMap().get(coreNodeName) != null && ((Replica)collectionState.getSlice(shard).getReplicasMap().get(coreNodeName)).getState() == expectedState);
    }

    protected static void assertAllActive(String collection, ZkStateReader zkStateReader) throws KeeperException, InterruptedException {
        zkStateReader.forceUpdateCollection(collection);
        ClusterState clusterState = zkStateReader.getClusterState();
        DocCollection docCollection = clusterState.getCollectionOrNull(collection);
        if (docCollection == null || docCollection.getSlices() == null) {
            throw new IllegalArgumentException("Cannot find collection:" + collection);
        }
        Map slices = docCollection.getSlicesMap();
        for (Map.Entry entry : slices.entrySet()) {
            Slice slice = (Slice)entry.getValue();
            if (slice.getState() != Slice.State.ACTIVE) {
                AbstractDistribZkTestBase.fail((String)("Not all shards are ACTIVE - found a shard " + slice.getName() + " that is: " + slice.getState()));
            }
            Map shards = slice.getReplicasMap();
            for (Map.Entry shard : shards.entrySet()) {
                Replica replica = (Replica)shard.getValue();
                if (replica.getState() == Replica.State.ACTIVE) continue;
                AbstractDistribZkTestBase.fail((String)("Not all replicas are ACTIVE - found a replica " + replica.getName() + " that is: " + replica.getState()));
            }
        }
    }

    @Override
    public void distribTearDown() throws Exception {
        AbstractDistribZkTestBase.resetExceptionIgnores();
        try {
            this.zkServer.shutdown();
        }
        catch (Exception e) {
            throw new RuntimeException("Exception shutting down Zk Test Server.", e);
        }
        finally {
            try {
                super.distribTearDown();
            }
            finally {
                System.clearProperty(ZK_HOST);
                System.clearProperty("collection");
                System.clearProperty(ENABLE_UPDATE_LOG);
                System.clearProperty(REMOVE_VERSION_FIELD);
                System.clearProperty("solr.directoryFactory");
                System.clearProperty("solr.test.sys.prop1");
                System.clearProperty("solr.test.sys.prop2");
                System.clearProperty(ZOOKEEPER_FORCE_SYNC);
                System.clearProperty("solr.tests.allow_reading_files_still_open_for_write");
            }
        }
    }

    protected void printLayout() throws Exception {
        SolrZkClient zkClient = new SolrZkClient.Builder().withUrl(this.zkServer.getZkHost()).withTimeout(45000, TimeUnit.MILLISECONDS).build();
        zkClient.printLayoutToStream(System.out);
        zkClient.close();
    }

    protected void restartZk(int pauseMillis) throws Exception {
        log.info("Restarting ZK with a pause of {}ms in between", (Object)pauseMillis);
        this.zkServer.shutdown();
        Thread.sleep(pauseMillis);
        this.zkServer = new ZkTestServer(this.zkServer.getZkDir(), this.zkServer.getPort());
        this.zkServer.run(false);
    }

    public static void copyConfigUp(Path configSetDir, String srcConfigSet, String dstConfigName, String zkAddr) throws Exception {
        File fullConfDir = new File(configSetDir.toFile(), srcConfigSet);
        String[] args = new String[]{"--conf-name", dstConfigName, "--conf-dir", fullConfDir.getAbsolutePath(), "-z", zkAddr};
        DefaultToolRuntime runtime = new DefaultToolRuntime();
        ConfigSetUploadTool tool = new ConfigSetUploadTool((ToolRuntime)runtime);
        int res = tool.runTool(SolrCLI.processCommandLineArgs((Tool)tool, (String[])args));
        AbstractDistribZkTestBase.assertEquals((String)("Tool should have returned 0 for success, returned: " + res), (long)res, (long)0L);
    }
}

