/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.util;

import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DisjunctionMaxQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.hamcrest.internal.ReflectiveTypeFinder;

public class QueryMatchers {
    private QueryMatchers() {
    }

    public static Matcher<Query> stringQuery(final String query) {
        return new TypeSafeDiagnosingMatcher<Query>(){

            protected boolean matchesSafely(Query item, Description mismatchDescription) {
                return Matchers.is((Object)query).matches((Object)item.toString());
            }

            public void describeTo(Description description) {
                description.appendText(query);
            }
        };
    }

    public static Matcher<Query> termQuery(String field, String text) {
        return Matchers.is((Object)new TermQuery(new Term(field, text)));
    }

    public static Matcher<Query> boosted(String field, String text, float boost) {
        return QueryMatchers.boosted(QueryMatchers.termQuery(field, text), boost);
    }

    public static Matcher<Query> boosted(final Matcher<? extends Query> query, final float boost) {
        return new SubTypeDiagnosingMatcher<BoostQuery>(){

            @Override
            protected boolean matchesExactType(BoostQuery item, Description mismatchDescription) {
                boolean match = true;
                mismatchDescription.appendText("was a BoostQuery ");
                if (!query.matches((Object)item.getQuery())) {
                    match = false;
                    mismatchDescription.appendText("with" + String.valueOf(item.getQuery()));
                }
                if (boost != item.getBoost()) {
                    match = false;
                    mismatchDescription.appendText("with boost " + item.getBoost());
                }
                return match;
            }

            public void describeTo(Description description) {
                description.appendText("a BoostQuery ").appendDescriptionOf((SelfDescribing)query).appendText("^" + boost);
            }
        };
    }

    public static Matcher<Query> phraseQuery(String field, String terms) {
        return Matchers.is((Object)new PhraseQuery(field, terms.split(" ")));
    }

    private static Matcher<BooleanClause> shouldClause(Matcher<? extends Query> query) {
        return QueryMatchers.booleanClause(query, BooleanClause.Occur.SHOULD);
    }

    private static Matcher<BooleanClause> mustClause(Matcher<? extends Query> query) {
        return QueryMatchers.booleanClause(query, BooleanClause.Occur.MUST);
    }

    public static Matcher<BooleanClause> booleanClause(final Matcher<? extends Query> query, final BooleanClause.Occur occur) {
        return new TypeSafeDiagnosingMatcher<BooleanClause>(){

            protected boolean matchesSafely(BooleanClause item, Description mismatchDescription) {
                boolean match = true;
                mismatchDescription.appendText("was a BooleanClause ");
                if (occur != item.getOccur()) {
                    match = false;
                    mismatchDescription.appendText("that " + item.getOccur().name() + " occur ");
                }
                if (!query.matches((Object)item.getQuery())) {
                    match = false;
                    mismatchDescription.appendText("with " + String.valueOf(item.getQuery()));
                    query.describeMismatch((Object)item.getQuery(), mismatchDescription);
                }
                return match;
            }

            public void describeTo(Description description) {
                description.appendText(occur.toString()).appendText("(").appendDescriptionOf((SelfDescribing)query).appendText(")");
            }
        };
    }

    public static Matcher<Query> booleanQuery(Matcher<Query> q1, BooleanClause.Occur occur) {
        return QueryMatchers._booleanQuery((Matcher<Iterable<? extends BooleanClause>>)Matchers.contains(QueryMatchers.booleanClause(q1, occur)));
    }

    public static Matcher<Query> booleanQuery(Matcher<Query> q1, Matcher<Query> q2, BooleanClause.Occur occur) {
        return QueryMatchers._booleanQuery((Matcher<Iterable<? extends BooleanClause>>)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QueryMatchers.booleanClause(q1, occur), QueryMatchers.booleanClause(q2, occur)}));
    }

    public static Matcher<Query> booleanQuery(Matcher<Query> query) {
        return QueryMatchers._booleanQuery((Matcher<Iterable<? extends BooleanClause>>)Matchers.contains(QueryMatchers.shouldClause(query)));
    }

    public static Matcher<Query> booleanQuery(Matcher<Query> c1, Matcher<Query> c2) {
        return QueryMatchers._booleanQuery((Matcher<Iterable<? extends BooleanClause>>)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QueryMatchers.shouldClause(c1), QueryMatchers.shouldClause(c2)}));
    }

    public static Matcher<Query> booleanQuery(Matcher<Query> c1, Matcher<Query> c2, Matcher<Query> c3) {
        return QueryMatchers._booleanQuery((Matcher<Iterable<? extends BooleanClause>>)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QueryMatchers.shouldClause(c1), QueryMatchers.shouldClause(c2), QueryMatchers.shouldClause(c3)}));
    }

    public static Matcher<Query> booleanQuery(Matcher<Query> c1, Matcher<Query> c2, Matcher<Query> c3, Matcher<Query> c4) {
        return QueryMatchers._booleanQuery((Matcher<Iterable<? extends BooleanClause>>)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{QueryMatchers.shouldClause(c1), QueryMatchers.shouldClause(c2), QueryMatchers.shouldClause(c3), QueryMatchers.shouldClause(c4)}));
    }

    private static Matcher<Query> _booleanQuery(final Matcher<Iterable<? extends BooleanClause>> matcher) {
        return new SubTypeDiagnosingMatcher<BooleanQuery>(){

            @Override
            protected boolean matchesExactType(BooleanQuery item, Description mismatchDescription) {
                if (matcher.matches((Object)item.clauses())) {
                    return true;
                }
                mismatchDescription.appendText("was a BooleanQuery with ");
                matcher.describeMismatch((Object)item.clauses(), mismatchDescription);
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("a BooleanQuery with ").appendDescriptionOf((SelfDescribing)matcher);
            }
        };
    }

    public static Matcher<Query> disjunctionOf(Matcher<Query> q1) {
        return QueryMatchers.disjunctionQuery((Matcher<Iterable<? extends Query>>)Matchers.contains(q1));
    }

    public static Matcher<Query> disjunctionOf(Matcher<Query> q1, Matcher<Query> q2) {
        return QueryMatchers.disjunctionQuery((Matcher<Iterable<? extends Query>>)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{q1, q2}));
    }

    public static Matcher<Query> disjunctionOf(Matcher<Query> q1, Matcher<Query> q2, Matcher<Query> q3) {
        return QueryMatchers.disjunctionQuery((Matcher<Iterable<? extends Query>>)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{q1, q2, q3}));
    }

    public static Matcher<Query> disjunctionOf(Matcher<Query> q1, Matcher<Query> q2, Matcher<Query> q3, Matcher<Query> q4) {
        return QueryMatchers.disjunctionQuery((Matcher<Iterable<? extends Query>>)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{q1, q2, q3, q4}));
    }

    private static Matcher<Query> disjunctionQuery(final Matcher<Iterable<? extends Query>> disjuncts) {
        return new SubTypeDiagnosingMatcher<DisjunctionMaxQuery>(){

            @Override
            protected boolean matchesExactType(DisjunctionMaxQuery item, Description mismatchDescription) {
                if (disjuncts.matches((Object)item.getDisjuncts())) {
                    return true;
                }
                mismatchDescription.appendText("was a DisjunctionMaxQuery with ");
                disjuncts.describeMismatch((Object)item.getDisjuncts(), mismatchDescription);
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("a DisjunctionMaxQuery with ").appendDescriptionOf((SelfDescribing)disjuncts);
            }
        };
    }

    private static abstract class SubTypeDiagnosingMatcher<Q extends Query>
    extends TypeSafeDiagnosingMatcher<Query> {
        private static final ReflectiveTypeFinder TYPE_FINDER = new ReflectiveTypeFinder("matchesExactType", 2, 0);

        public SubTypeDiagnosingMatcher() {
            super(TYPE_FINDER);
        }

        protected final boolean matchesSafely(Query item, Description mismatchDescription) {
            return this.matchesExactType(item, mismatchDescription);
        }

        protected abstract boolean matchesExactType(Q var1, Description var2);
    }
}

