/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import org.apache.http.client.utils.URIBuilder;
import org.apache.lucene.tests.util.TestUtil;
import org.apache.solr.SolrTestCase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BackupRestoreUtils
extends SolrTestCase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static int indexDocs(SolrClient leaderClient, String collectionName, long docsSeed) throws IOException, SolrServerException {
        leaderClient.deleteByQuery(collectionName, "*:*");
        Random random = new Random(docsSeed);
        int nDocs = TestUtil.nextInt((Random)random, (int)1, (int)100);
        log.info("Indexing {} test docs", (Object)nDocs);
        ArrayList<SolrInputDocument> docs = new ArrayList<SolrInputDocument>(nDocs);
        for (int i = 0; i < nDocs; ++i) {
            SolrInputDocument doc = new SolrInputDocument();
            doc.addField("id", (Object)i);
            doc.addField("name", (Object)("name = " + i));
            docs.add(doc);
        }
        leaderClient.add(collectionName, docs);
        leaderClient.commit(collectionName);
        BackupRestoreUtils.verifyDocs(nDocs, leaderClient, collectionName);
        return nDocs;
    }

    public static void verifyDocs(int nDocs, SolrClient leaderClient, String collectionName) throws SolrServerException, IOException {
        ModifiableSolrParams queryParams = new ModifiableSolrParams();
        queryParams.set("q", new String[]{"*:*"});
        QueryResponse response = leaderClient.query(collectionName, (SolrParams)queryParams);
        BackupRestoreUtils.assertEquals((long)0L, (long)response.getStatus());
        BackupRestoreUtils.assertEquals((long)nDocs, (long)response.getResults().getNumFound());
    }

    public static void runCoreAdminCommand(String baseUrl, String coreName, String action, Map<String, String> params) throws IOException, URISyntaxException {
        URI uri = new URI(baseUrl);
        String oldPath = uri.getPath() != null ? uri.getPath().substring(1) : "";
        String newPath = "admin/cores";
        Object finalPath = oldPath.isEmpty() ? "admin/cores" : oldPath + "/admin/cores";
        URIBuilder builder = new URIBuilder(uri).setPath((String)finalPath).addParameter("action", action).addParameter("core", coreName);
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.addParameter(entry.getKey(), entry.getValue());
        }
        BackupRestoreUtils.executeHttpRequest(builder.build());
    }

    public static void runReplicationHandlerCommand(String baseUrl, String coreName, String action, String repoName, String backupName) throws IOException, URISyntaxException {
        URI uri = new URI(baseUrl);
        String oldPath = uri.getPath() != null ? uri.getPath().substring(1) : "";
        String newPath = coreName + "/replication";
        String finalPath = oldPath.isEmpty() ? newPath : oldPath + "/" + newPath;
        URI finalURI = new URIBuilder(uri).setPath(finalPath).addParameter("command", action).addParameter("repository", repoName).addParameter("name", backupName).build();
        BackupRestoreUtils.executeHttpRequest(finalURI);
    }

    private static void executeHttpRequest(URI uri) throws IOException {
        URL url = uri.toURL();
        try (InputStream stream = url.openStream();){
            assert (stream != null);
        }
    }
}

