/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cluster.placement;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.cluster.Cluster;
import org.apache.solr.cluster.Node;
import org.apache.solr.cluster.Replica;
import org.apache.solr.cluster.Shard;
import org.apache.solr.cluster.SolrCollection;

class ClusterAbstractionsForTest {
    ClusterAbstractionsForTest() {
    }

    static class ReplicaImpl
    implements Replica {
        private final String replicaName;
        private final String coreName;
        private final Shard shard;
        private final Replica.ReplicaType replicaType;
        private final Replica.ReplicaState replicaState;
        private final Node node;

        ReplicaImpl(String replicaName, String coreName, Shard shard, Replica.ReplicaType replicaType, Replica.ReplicaState replicaState, Node node) {
            this.replicaName = replicaName;
            this.coreName = coreName;
            this.shard = shard;
            this.replicaType = replicaType;
            this.replicaState = replicaState;
            this.node = node;
        }

        public Shard getShard() {
            return this.shard;
        }

        public Replica.ReplicaType getType() {
            return this.replicaType;
        }

        public Replica.ReplicaState getState() {
            return this.replicaState;
        }

        public String getReplicaName() {
            return this.replicaName;
        }

        public String getCoreName() {
            return this.coreName;
        }

        public Node getNode() {
            return this.node;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ReplicaImpl)) {
                return false;
            }
            ReplicaImpl other = (ReplicaImpl)obj;
            return Objects.equals(this.replicaName, other.replicaName) && Objects.equals(this.coreName, other.coreName) && Objects.equals(this.shard, other.shard) && Objects.equals(this.replicaType, other.replicaType) && Objects.equals(this.replicaState, other.replicaState) && Objects.equals(this.node, other.node);
        }

        public int hashCode() {
            return Objects.hash(this.replicaName, this.coreName, this.shard, this.replicaType, this.replicaState, this.node);
        }

        public String toString() {
            return "ReplicaImpl{replicaName='" + this.replicaName + "', coreName='" + this.coreName + "', shard='" + String.valueOf(this.shard) + "', replicaType=" + String.valueOf(this.replicaType) + ", replicaState=" + String.valueOf(this.replicaState) + ", node=" + String.valueOf(this.node) + "}";
        }
    }

    static class ShardImpl
    implements Shard {
        private final String shardName;
        private final SolrCollection collection;
        private final Shard.ShardState shardState;
        private Map<String, Replica> replicas;
        private Replica leader;

        ShardImpl(String shardName, SolrCollection collection, Shard.ShardState shardState) {
            this.shardName = shardName;
            this.collection = collection;
            this.shardState = shardState;
        }

        void setReplicas(Map<String, Replica> replicas, Replica leader) {
            this.replicas = replicas;
            this.leader = leader;
        }

        public String getShardName() {
            return this.shardName;
        }

        public SolrCollection getCollection() {
            return this.collection;
        }

        public Replica getReplica(String name) {
            return this.replicas.get(name);
        }

        public Iterator<Replica> iterator() {
            return this.replicas.values().iterator();
        }

        public Iterable<Replica> replicas() {
            return this::iterator;
        }

        public Replica getLeader() {
            return this.leader;
        }

        public Shard.ShardState getState() {
            return this.shardState;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof ShardImpl)) {
                return false;
            }
            ShardImpl other = (ShardImpl)obj;
            return Objects.equals(this.shardName, other.shardName) && Objects.equals(this.collection, other.collection) && Objects.equals(this.shardState, other.shardState) && Objects.equals(this.replicas, other.replicas) && Objects.equals(this.leader, other.leader);
        }

        public int hashCode() {
            return Objects.hash(this.shardName, this.collection, this.shardState);
        }

        public String toString() {
            return "ShardImpl{shardName='" + this.shardName + "'}";
        }
    }

    static class SolrCollectionImpl
    implements SolrCollection {
        private final String collectionName;
        private Map<String, Shard> shards;
        private final Map<String, String> customProperties;

        SolrCollectionImpl(String collectionName, Map<String, String> customProperties) {
            this.collectionName = collectionName;
            this.customProperties = customProperties;
        }

        void setShards(Map<String, Shard> shards) {
            this.shards = shards;
        }

        public String getName() {
            return this.collectionName;
        }

        public Shard getShard(String name) {
            return this.shards.get(name);
        }

        public Iterator<Shard> iterator() {
            return this.shards.values().iterator();
        }

        public Iterable<Shard> shards() {
            return this::iterator;
        }

        public Set<String> getShardNames() {
            return this.shards.keySet();
        }

        public String getCustomProperty(String customPropertyName) {
            return this.customProperties.get(customPropertyName);
        }
    }

    static class NodeImpl
    implements Node {
        public final String nodeName;

        NodeImpl(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getName() {
            return this.nodeName;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.getName() + ")";
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof NodeImpl)) {
                return false;
            }
            NodeImpl other = (NodeImpl)obj;
            return Objects.equals(this.nodeName, other.nodeName);
        }

        public int hashCode() {
            return Objects.hashCode(this.nodeName);
        }
    }

    static class ClusterImpl
    implements Cluster {
        private final Set<Node> liveNodes = new HashSet<Node>();
        private final Map<String, SolrCollection> collections = new HashMap<String, SolrCollection>();

        ClusterImpl(Set<Node> liveNodes, Map<String, SolrCollection> collections) {
            this.liveNodes.addAll(liveNodes);
            this.collections.putAll(collections);
        }

        public Set<Node> getLiveNodes() {
            return this.liveNodes;
        }

        public Set<Node> getLiveDataNodes() {
            return this.liveNodes;
        }

        public SolrCollection getCollection(String collectionName) {
            return this.collections.get(collectionName);
        }

        public Iterator<SolrCollection> iterator() {
            return this.collections.values().iterator();
        }

        public Iterable<SolrCollection> collections() {
            return this::iterator;
        }
    }
}

