/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.cloud.StoppableIndexingThread;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.embedded.JettySolrRunner;
import org.apache.solr.util.TestInjection;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public abstract class AbstractTlogReplayBufferedWhileIndexingTestBase
extends AbstractFullDistribZkTestBase {
    private List<StoppableIndexingThread> threads;

    public AbstractTlogReplayBufferedWhileIndexingTestBase() throws Exception {
        this.sliceCount = 1;
        this.fixShardCount(2);
        schemaString = "schema15.xml";
    }

    @BeforeClass
    public static void beforeRestartWhileUpdatingTest() throws Exception {
        System.setProperty("leaderVoteWait", "300000");
        System.setProperty("solr.autoCommit.maxTime", "10000");
        System.setProperty("solr.autoSoftCommit.maxTime", "3000");
        TestInjection.updateLogReplayRandomPause = "true:10";
        TestInjection.updateRandomPause = "true:10";
        AbstractTlogReplayBufferedWhileIndexingTestBase.useFactory("solr.StandardDirectoryFactory");
    }

    @AfterClass
    public static void afterRestartWhileUpdatingTest() {
        System.clearProperty("leaderVoteWait");
        System.clearProperty("solr.autoCommit.maxTime");
        System.clearProperty("solr.autoSoftCommit.maxTime");
    }

    @Test
    public void test() throws Exception {
        this.handle.clear();
        this.handle.put("timestamp", 4);
        this.waitForRecoveriesToFinish(false);
        int numThreads = 3;
        this.threads = new ArrayList<StoppableIndexingThread>(numThreads);
        ArrayList allJetty = new ArrayList();
        allJetty.addAll(this.jettys);
        allJetty.remove(((AbstractFullDistribZkTestBase.CloudJettyRunner)this.shardToLeaderJetty.get((Object)"shard1")).jetty);
        assert (allJetty.size() == 1) : allJetty.size();
        ((JettySolrRunner)allJetty.get(0)).stop();
        for (int i = 0; i < numThreads; ++i) {
            boolean pauseBetweenUpdates = AbstractTlogReplayBufferedWhileIndexingTestBase.random().nextBoolean();
            int batchSize = AbstractTlogReplayBufferedWhileIndexingTestBase.random().nextInt(4) + 1;
            StoppableIndexingThread indexThread = new StoppableIndexingThread(this.controlClient, (SolrClient)this.cloudClient, Integer.toString(i), true, 900, batchSize, pauseBetweenUpdates);
            this.threads.add(indexThread);
            indexThread.start();
        }
        Thread.sleep(2000L);
        ((JettySolrRunner)allJetty.get(0)).start();
        Thread.sleep(45000L);
        this.waitForThingsToLevelOut();
        Thread.sleep(2000L);
        this.waitForRecoveriesToFinish("collection1", ZkStateReader.from((CloudSolrClient)this.cloudClient), false, true);
        for (StoppableIndexingThread thread : this.threads) {
            thread.safeStop();
        }
        this.waitForThingsToLevelOut(30, TimeUnit.SECONDS);
        this.checkShardConsistency(false, false);
    }

    @Override
    protected void indexDoc(SolrInputDocument doc) throws IOException, SolrServerException {
        this.cloudClient.add(doc);
    }

    @Override
    public void distribTearDown() throws Exception {
        if (this.threads != null) {
            for (StoppableIndexingThread thread : this.threads) {
                thread.safeStop();
            }
            for (StoppableIndexingThread thread : this.threads) {
                thread.join();
            }
        }
        super.distribTearDown();
    }

    @Override
    protected void indexr(Object ... fields) throws Exception {
        SolrInputDocument doc = new SolrInputDocument();
        AbstractTlogReplayBufferedWhileIndexingTestBase.addFields(doc, fields);
        AbstractTlogReplayBufferedWhileIndexingTestBase.addFields(doc, "rnd_b", true);
        this.indexDoc(doc);
    }
}

