/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.solr.client.api.model.LogLevelChange;
import org.apache.solr.client.api.model.SetThresholdRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for logging, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class LoggingApi {

  public static class FetchLocalLogMessagesResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.LogMessagesResponse> {
    public FetchLocalLogMessagesResponse() {
      super(org.apache.solr.client.api.model.LogMessagesResponse.class);
    }
  }

  public static class FetchLocalLogMessages extends SolrRequest<FetchLocalLogMessagesResponse> {
    private Long since;

    /** Create a FetchLocalLogMessages request object. */
    public FetchLocalLogMessages() {
      super(SolrRequest.METHOD.valueOf("GET"), "/node/logging/messages");
    }

    public void setSince(Long since) {
      this.since = since;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (since != null) {

        params.add("since", since.toString());
      }
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      queryParams.add("since");
      return queryParams;
    }

    @Override
    protected FetchLocalLogMessagesResponse createResponse(SolrClient client) {
      return new FetchLocalLogMessagesResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ListAllLoggersAndLevelsResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.ListLevelsResponse> {
    public ListAllLoggersAndLevelsResponse() {
      super(org.apache.solr.client.api.model.ListLevelsResponse.class);
    }
  }

  public static class ListAllLoggersAndLevels extends SolrRequest<ListAllLoggersAndLevelsResponse> {

    /** Create a ListAllLoggersAndLevels request object. */
    public ListAllLoggersAndLevels() {
      super(SolrRequest.METHOD.valueOf("GET"), "/node/logging/levels");
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected ListAllLoggersAndLevelsResponse createResponse(SolrClient client) {
      return new ListAllLoggersAndLevelsResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ModifyLocalLogLevelResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.LoggingResponse> {
    public ModifyLocalLogLevelResponse() {
      super(org.apache.solr.client.api.model.LoggingResponse.class);
    }
  }

  public static class ModifyLocalLogLevel extends SolrRequest<ModifyLocalLogLevelResponse> {
    private final List<LogLevelChange> requestBody;

    /** Create a ModifyLocalLogLevel request object. */
    public ModifyLocalLogLevel() {
      super(SolrRequest.METHOD.valueOf("PUT"), "/node/logging/levels");

      this.requestBody = new ArrayList<>();
    }

    public void addLogLevelChange(LogLevelChange entry) {
      this.requestBody.add(entry);
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
      // v2 only supports JSON request bodies, so we ignore this type coming from the RequestWriter
      return new JacksonContentWriter(requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected ModifyLocalLogLevelResponse createResponse(SolrClient client) {
      return new ModifyLocalLogLevelResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class SetMessageThresholdResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.LoggingResponse> {
    public SetMessageThresholdResponse() {
      super(org.apache.solr.client.api.model.LoggingResponse.class);
    }
  }

  public static class SetMessageThreshold extends SolrRequest<SetMessageThresholdResponse> {
    private final SetThresholdRequestBody requestBody;

    /** Create a SetMessageThreshold request object. */
    public SetMessageThreshold() {
      super(SolrRequest.METHOD.valueOf("PUT"), "/node/logging/messages/threshold");

      this.requestBody = new SetThresholdRequestBody();
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setLevel(String level) {
      this.requestBody.level = level;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
      // v2 only supports JSON request bodies, so we ignore this type coming from the RequestWriter
      return new JacksonContentWriter(requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected SetMessageThresholdResponse createResponse(SolrClient client) {
      return new SetMessageThresholdResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
