/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.api.model.UpdateCollectionPropertyRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for collectionProperties, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class CollectionPropertiesApi {

  public static class CreateOrUpdateCollectionPropertyResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public CreateOrUpdateCollectionPropertyResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class CreateOrUpdateCollectionProperty
      extends SolrRequest<CreateOrUpdateCollectionPropertyResponse> {
    private final UpdateCollectionPropertyRequestBody requestBody;
    private final String collName;
    private final String propName;

    /**
     * Create a CreateOrUpdateCollectionProperty request object.
     *
     * @param collName Path param -
     * @param propName Path param -
     */
    public CreateOrUpdateCollectionProperty(String collName, String propName) {
      super(
          SolrRequest.METHOD.valueOf("PUT"),
          "/collections/{collName}/properties/{propName}"
              .replace("{" + "collName" + "}", collName)
              .replace("{" + "propName" + "}", propName));

      this.collName = collName;
      this.propName = propName;
      this.requestBody = new UpdateCollectionPropertyRequestBody();
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setValue(String value) {
      this.requestBody.value = value;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String _expectedTypeIGNORE) {
      // v2 only supports JSON request bodies, so we ignore this type coming from the RequestWriter
      return new JacksonContentWriter(requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected CreateOrUpdateCollectionPropertyResponse createResponse(SolrClient client) {
      return new CreateOrUpdateCollectionPropertyResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class DeleteCollectionPropertyResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public DeleteCollectionPropertyResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class DeleteCollectionProperty
      extends SolrRequest<DeleteCollectionPropertyResponse> {
    private final String collName;
    private final String propName;

    /**
     * Create a DeleteCollectionProperty request object.
     *
     * @param collName Path param -
     * @param propName Path param -
     */
    public DeleteCollectionProperty(String collName, String propName) {
      super(
          SolrRequest.METHOD.valueOf("DELETE"),
          "/collections/{collName}/properties/{propName}"
              .replace("{" + "collName" + "}", collName)
              .replace("{" + "propName" + "}", propName));

      this.collName = collName;
      this.propName = propName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    public Set<String> getQueryParams() {
      final var queryParams = new HashSet<String>();
      return queryParams;
    }

    @Override
    protected DeleteCollectionPropertyResponse createResponse(SolrClient client) {
      return new DeleteCollectionPropertyResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
