/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.params;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.AppendedSolrParams;
import org.apache.solr.common.params.DefaultSolrParams;
import org.apache.solr.common.params.RequiredSolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.common.util.StrUtils;

public abstract class SolrParams
implements Serializable,
MapWriter,
Iterable<Map.Entry<String, String[]>> {
    public abstract String get(String var1);

    public abstract String[] getParams(String var1);

    public abstract Iterator<String> getParameterNamesIterator();

    public String get(String param, String def) {
        String val = this.get(param);
        return val == null ? def : val;
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        this.toNamedList().forEach((String k, ? super T v) -> {
            if (v == null || "".equals(v)) {
                return;
            }
            try {
                ew.put((CharSequence)k, v);
            }
            catch (IOException e) {
                throw new RuntimeException("Error serializing", e);
            }
        });
    }

    @Override
    public Iterator<Map.Entry<String, String[]>> iterator() {
        final Iterator<String> it = this.getParameterNamesIterator();
        return new Iterator<Map.Entry<String, String[]>>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public Map.Entry<String, String[]> next() {
                final String key = (String)it.next();
                return new Map.Entry<String, String[]>(){

                    @Override
                    public String getKey() {
                        return key;
                    }

                    @Override
                    public String[] getValue() {
                        return SolrParams.this.getParams(key);
                    }

                    @Override
                    public String[] setValue(String[] newValue) {
                        throw new UnsupportedOperationException("read-only");
                    }

                    public String toString() {
                        return this.getKey() + "=" + Arrays.toString(this.getValue());
                    }
                };
            }
        };
    }

    public Stream<Map.Entry<String, String[]>> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public RequiredSolrParams required() {
        return new RequiredSolrParams(this);
    }

    protected String fpname(String field, String param) {
        return "f." + field + "." + param;
    }

    public String getFieldParam(String field, String param) {
        String val = this.get(this.fpname(field, param));
        return val != null ? val : this.get(param);
    }

    public String getFieldParam(String field, String param, String def) {
        String val = this.get(this.fpname(field, param));
        return val != null ? val : this.get(param, def);
    }

    public String[] getFieldParams(String field, String param) {
        String[] val = this.getParams(this.fpname(field, param));
        return val != null ? val : this.getParams(param);
    }

    public Boolean getBool(String param) {
        String val = this.get(param);
        return val == null ? null : Boolean.valueOf(StrUtils.parseBool(val));
    }

    public boolean getPrimitiveBool(String param) {
        return this.getBool(param, false);
    }

    public boolean getBool(String param, boolean def) {
        String val = this.get(param);
        return val == null ? def : StrUtils.parseBool(val);
    }

    public Boolean getFieldBool(String field, String param) {
        String val = this.getFieldParam(field, param);
        return val == null ? null : Boolean.valueOf(StrUtils.parseBool(val));
    }

    public boolean getPrimitiveFieldBool(String field, String param) {
        return this.getFieldBool(field, param, false);
    }

    public boolean getFieldBool(String field, String param, boolean def) {
        String val = this.getFieldParam(field, param);
        return val == null ? def : StrUtils.parseBool(val);
    }

    public Integer getInt(String param) {
        String val = this.get(param);
        try {
            return val == null ? null : Integer.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public int getPrimitiveInt(String param) {
        return this.getInt(param, 0);
    }

    public int getInt(String param, int def) {
        String val = this.get(param);
        try {
            return val == null ? def : Integer.parseInt(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Long getLong(String param) {
        String val = this.get(param);
        try {
            return val == null ? null : Long.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public long getLong(String param, long def) {
        String val = this.get(param);
        try {
            return val == null ? def : Long.parseLong(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Integer getFieldInt(String field, String param) {
        String val = this.getFieldParam(field, param);
        try {
            return val == null ? null : Integer.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public int getFieldInt(String field, String param, int def) {
        String val = this.getFieldParam(field, param);
        try {
            return val == null ? def : Integer.parseInt(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Float getFloat(String param) {
        String val = this.get(param);
        try {
            return val == null ? null : Float.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public float getFloat(String param, float def) {
        String val = this.get(param);
        try {
            return val == null ? def : Float.parseFloat(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Double getDouble(String param) {
        String val = this.get(param);
        try {
            return val == null ? null : Double.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public double getDouble(String param, double def) {
        String val = this.get(param);
        try {
            return val == null ? def : Double.parseDouble(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Float getFieldFloat(String field, String param) {
        String val = this.getFieldParam(field, param);
        try {
            return val == null ? null : Float.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public float getPrimitiveFieldFloat(String field, String param) {
        return this.getFieldFloat(field, param, 0.0f);
    }

    public float getFieldFloat(String field, String param, float def) {
        String val = this.getFieldParam(field, param);
        try {
            return val == null ? def : Float.parseFloat(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public Double getFieldDouble(String field, String param) {
        String val = this.getFieldParam(field, param);
        try {
            return val == null ? null : Double.valueOf(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public double getFieldDouble(String field, String param, double def) {
        String val = this.getFieldParam(field, param);
        try {
            return val == null ? def : Double.parseDouble(val);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, ex.getMessage(), (Throwable)ex);
        }
    }

    public static SolrParams wrapDefaults(SolrParams params, SolrParams defaults) {
        if (params == null) {
            return defaults;
        }
        if (defaults == null) {
            return params;
        }
        return new DefaultSolrParams(params, defaults);
    }

    public static SolrParams wrapAppended(SolrParams params, SolrParams defaults) {
        if (params == null) {
            return defaults;
        }
        if (defaults == null) {
            return params;
        }
        return AppendedSolrParams.wrapAppended(params, defaults);
    }

    public NamedList<Object> toNamedList() {
        SimpleOrderedMap<Object> result = new SimpleOrderedMap<Object>();
        Iterator<String> it = this.getParameterNamesIterator();
        while (it.hasNext()) {
            String name = it.next();
            String[] values = this.getParams(name);
            if (values.length == 1) {
                result.add(name, values[0]);
                continue;
            }
            result.add(name, values);
        }
        return result;
    }

    public String toQueryString() {
        try {
            String charset = StandardCharsets.UTF_8.name();
            StringBuilder sb = new StringBuilder(128);
            boolean first = true;
            Iterator<String> it = this.getParameterNamesIterator();
            while (it.hasNext()) {
                String name = it.next();
                String nameEnc = URLEncoder.encode(name, charset);
                for (String val : this.getParams(name)) {
                    sb.append(first ? (char)'?' : '&').append(nameEnc).append('=').append(URLEncoder.encode(val, charset));
                    first = false;
                }
            }
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError((Object)e);
        }
    }

    public String toLocalParamsString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("{!");
        Iterator<String> it = this.getParameterNamesIterator();
        while (it.hasNext()) {
            String name = it.next();
            for (String val : this.getParams(name)) {
                sb.append(' ');
                sb.append(name);
                sb.append('=');
                if (val.startsWith("$")) {
                    sb.append(val);
                    continue;
                }
                sb.append(ClientUtils.encodeLocalParamVal(val));
            }
        }
        sb.append('}');
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        boolean first = true;
        Iterator<String> it = this.getParameterNamesIterator();
        while (it.hasNext()) {
            String name = it.next();
            for (String val : this.getParams(name)) {
                if (!first) {
                    sb.append('&');
                }
                first = false;
                StrUtils.partialURLEncodeVal(sb, name);
                sb.append('=');
                StrUtils.partialURLEncodeVal(sb, val);
            }
        }
        return sb.toString();
    }
}

