/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.DeleteNodeRequestBody;
import org.apache.solr.client.api.model.ReplaceNodeRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for node, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class NodeApi {

  public static class DeleteNodeResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public DeleteNodeResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class DeleteNode extends SolrRequest<DeleteNodeResponse> {
    private final DeleteNodeRequestBody requestBody;
    private final String nodeName;

    /**
     * Create a DeleteNode request object.
     *
     * @param nodeName Path param - The name of the node to be cleared. Usually of the form
     *     &#39;host:1234_solr&#39;.
     */
    public DeleteNode(String nodeName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/cluster/nodes/{nodeName}/clear".replace("{" + "nodeName" + "}", nodeName));

      this.nodeName = nodeName;
      this.requestBody = new DeleteNodeRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param async Request ID to track this action which will be processed asynchronously.
     */
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected DeleteNodeResponse createResponse(SolrClient client) {
      return new DeleteNodeResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetCommandStatusResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.GetNodeCommandStatusResponse> {
    public GetCommandStatusResponse() {
      super(org.apache.solr.client.api.model.GetNodeCommandStatusResponse.class);
    }
  }

  public static class GetCommandStatus extends SolrRequest<GetCommandStatusResponse> {
    private final String requestId;

    /**
     * Create a GetCommandStatus request object.
     *
     * @param requestId Path param - The user defined request-id for the asynchronous request.
     */
    public GetCommandStatus(String requestId) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/node/commands/{requestId}".replace("{" + "requestId" + "}", requestId));

      this.requestId = requestId;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetCommandStatusResponse createResponse(SolrClient client) {
      return new GetCommandStatusResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetPublicKeyResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.PublicKeyResponse> {
    public GetPublicKeyResponse() {
      super(org.apache.solr.client.api.model.PublicKeyResponse.class);
    }
  }

  public static class GetPublicKey extends SolrRequest<GetPublicKeyResponse> {

    /** Create a GetPublicKey request object. */
    public GetPublicKey() {
      super(SolrRequest.METHOD.valueOf("GET"), "/node/key");
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetPublicKeyResponse createResponse(SolrClient client) {
      return new GetPublicKeyResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ReplaceNodeResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public ReplaceNodeResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class ReplaceNode extends SolrRequest<ReplaceNodeResponse> {
    private final ReplaceNodeRequestBody requestBody;
    private final String sourceNodeName;

    /**
     * Create a ReplaceNode request object.
     *
     * @param sourceNodeName Path param - The name of the node to be replaced.
     */
    public ReplaceNode(String sourceNodeName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/cluster/nodes/{sourceNodeName}/replace"
              .replace("{" + "sourceNodeName" + "}", sourceNodeName));

      this.sourceNodeName = sourceNodeName;
      this.requestBody = new ReplaceNodeRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param targetNodeName The target node where replicas will be copied. If this parameter is not
     *     provided, Solr will identify nodes automatically based on policies or number of cores in
     *     each node.
     */
    public void setTargetNodeName(String targetNodeName) {
      this.requestBody.targetNodeName = targetNodeName;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param waitForFinalState If true, the request will complete only when all affected replicas
     *     become active. If false, the API will return the status of the single action, which may
     *     be before the new replica is online and active.
     */
    public void setWaitForFinalState(Boolean waitForFinalState) {
      this.requestBody.waitForFinalState = waitForFinalState;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param async Request ID to track this action which will be processed asynchronously.
     */
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected ReplaceNodeResponse createResponse(SolrClient client) {
      return new ReplaceNodeResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
