/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import java.util.List;
import org.apache.solr.client.api.model.InstallCoreDataRequestBody;
import org.apache.solr.client.api.model.MergeIndexesRequestBody;
import org.apache.solr.client.api.model.RenameCoreRequestBody;
import org.apache.solr.client.api.model.RestoreCoreRequestBody;
import org.apache.solr.client.api.model.SwapCoresRequestBody;
import org.apache.solr.client.api.model.UnloadCoreRequestBody;
import org.apache.solr.client.solrj.JacksonContentWriter;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for cores, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class CoresApi {

  public static class InstallCoreDataResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public InstallCoreDataResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class InstallCoreData extends SolrRequest<InstallCoreDataResponse> {
    private final InstallCoreDataRequestBody requestBody;
    private final String coreName;

    /**
     * Create a InstallCoreData request object.
     *
     * @param coreName Path param -
     */
    public InstallCoreData(String coreName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/cores/{coreName}/install".replace("{" + "coreName" + "}", coreName));

      this.coreName = coreName;
      this.requestBody = new InstallCoreDataRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setLocation(String location) {
      this.requestBody.location = location;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setRepository(String repository) {
      this.requestBody.repository = repository;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setAsyncId(String asyncId) {
      this.requestBody.asyncId = asyncId;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected InstallCoreDataResponse createResponse(SolrClient client) {
      return new InstallCoreDataResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class MergeIndexesResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public MergeIndexesResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class MergeIndexes extends SolrRequest<MergeIndexesResponse> {
    private final MergeIndexesRequestBody requestBody;
    private final String coreName;

    /**
     * Create a MergeIndexes request object.
     *
     * @param coreName Path param - The core that the specified indices are merged into.
     */
    public MergeIndexes(String coreName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/cores/{coreName}/merge-indices".replace("{" + "coreName" + "}", coreName));

      this.coreName = coreName;
      this.requestBody = new MergeIndexesRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param indexDirs Multi-valued, directories that would be merged.
     */
    public void setIndexDirs(List<String> indexDirs) {
      this.requestBody.indexDirs = indexDirs;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param srcCores Multi-valued, source cores that would be merged.
     */
    public void setSrcCores(List<String> srcCores) {
      this.requestBody.srcCores = srcCores;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param async Request ID to track this action which will be processed asynchronously.
     */
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setUpdateChain(String updateChain) {
      this.requestBody.updateChain = updateChain;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected MergeIndexesResponse createResponse(SolrClient client) {
      return new MergeIndexesResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ReloadCoreResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public ReloadCoreResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class ReloadCore extends SolrRequest<ReloadCoreResponse> {
    private final String coreName;

    /**
     * Create a ReloadCore request object.
     *
     * @param coreName Path param - The name of the core to reload.
     */
    public ReloadCore(String coreName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/cores/{coreName}/reload".replace("{" + "coreName" + "}", coreName));

      this.coreName = coreName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected ReloadCoreResponse createResponse(SolrClient client) {
      return new ReloadCoreResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class RenameCoreResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public RenameCoreResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class RenameCore extends SolrRequest<RenameCoreResponse> {
    private final RenameCoreRequestBody requestBody;
    private final String coreName;

    /**
     * Create a RenameCore request object.
     *
     * @param coreName Path param -
     */
    public RenameCore(String coreName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/cores/{coreName}/rename".replace("{" + "coreName" + "}", coreName));

      this.coreName = coreName;
      this.requestBody = new RenameCoreRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param to The new name for the Solr core.
     */
    public void setTo(String to) {
      this.requestBody.to = to;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param async Request ID to track this action which will be processed asynchronously.
     */
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected RenameCoreResponse createResponse(SolrClient client) {
      return new RenameCoreResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class RestoreCoreResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public RestoreCoreResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class RestoreCore extends SolrRequest<RestoreCoreResponse> {
    private final RestoreCoreRequestBody requestBody;
    private final String coreName;

    /**
     * Create a RestoreCore request object.
     *
     * @param coreName Path param - The name of the core to be restored
     */
    public RestoreCore(String coreName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/cores/{coreName}/restore".replace("{" + "coreName" + "}", coreName));

      this.coreName = coreName;
      this.requestBody = new RestoreCoreRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setName(String name) {
      this.requestBody.name = name;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setShardBackupId(String shardBackupId) {
      this.requestBody.shardBackupId = shardBackupId;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setLocation(String location) {
      this.requestBody.location = location;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    public void setBackupRepository(String backupRepository) {
      this.requestBody.backupRepository = backupRepository;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected RestoreCoreResponse createResponse(SolrClient client) {
      return new RestoreCoreResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class SwapCoresResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public SwapCoresResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class SwapCores extends SolrRequest<SwapCoresResponse> {
    private final SwapCoresRequestBody requestBody;
    private final String coreName;

    /**
     * Create a SwapCores request object.
     *
     * @param coreName Path param -
     */
    public SwapCores(String coreName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/cores/{coreName}/swap".replace("{" + "coreName" + "}", coreName));

      this.coreName = coreName;
      this.requestBody = new SwapCoresRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param with The name of the other core to be swapped.
     */
    public void setWith(String with) {
      this.requestBody.with = with;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param async Request ID to track this action which will be processed asynchronously.
     */
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected SwapCoresResponse createResponse(SolrClient client) {
      return new SwapCoresResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class UnloadCoreResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SolrJerseyResponse> {
    public UnloadCoreResponse() {
      super(org.apache.solr.client.api.model.SolrJerseyResponse.class);
    }
  }

  public static class UnloadCore extends SolrRequest<UnloadCoreResponse> {
    private final UnloadCoreRequestBody requestBody;
    private final String coreName;

    /**
     * Create a UnloadCore request object.
     *
     * @param coreName Path param -
     */
    public UnloadCore(String coreName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/cores/{coreName}/unload".replace("{" + "coreName" + "}", coreName));

      this.coreName = coreName;
      this.requestBody = new UnloadCoreRequestBody();
      addHeader("Content-type", "application/json");
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param deleteIndex If true, will remove the index when unloading the core.
     */
    public void setDeleteIndex(Boolean deleteIndex) {
      this.requestBody.deleteIndex = deleteIndex;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param deleteDataDir If true, removes the data directory and all sub-directories.
     */
    public void setDeleteDataDir(Boolean deleteDataDir) {
      this.requestBody.deleteDataDir = deleteDataDir;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param deleteInstanceDir If true, removes everything related to the core, including the index
     *     directory, configuration files and other related files.
     */
    public void setDeleteInstanceDir(Boolean deleteInstanceDir) {
      this.requestBody.deleteInstanceDir = deleteInstanceDir;
    }

    // TODO find a way to add required parameters in the request body to the class constructor
    /**
     * @param async Request ID to track this action which will be processed asynchronously.
     */
    public void setAsync(String async) {
      this.requestBody.async = async;
    }

    @Override
    @SuppressWarnings("unchecked")
    public RequestWriter.ContentWriter getContentWriter(String expectedType) {
      return new JacksonContentWriter(expectedType, requestBody);
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected UnloadCoreResponse createResponse(SolrClient client) {
      return new UnloadCoreResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
