/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.solr.common.MapWriter;
import org.apache.solr.common.SolrDocument;

public class SolrDocumentList
extends ArrayList<SolrDocument>
implements MapWriter {
    private long numFound = 0L;
    private long start = 0L;
    private Float maxScore = null;
    private Boolean numFoundExact = true;

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put((CharSequence)"numFound", this.numFound);
        ew.put((CharSequence)"start", this.start);
        if (this.maxScore != null) {
            ew.put((CharSequence)"maxScore", this.maxScore);
        }
        if (this.numFoundExact != null) {
            ew.put((CharSequence)"numFoundExact", this.numFoundExact);
        }
        Iterator docs = this.iterator();
        ew.put((CharSequence)"docs", iw -> docs.forEachRemaining(iw::addNoEx));
    }

    public Boolean getNumFoundExact() {
        return this.numFoundExact;
    }

    public void setNumFoundExact(Boolean numFoundExact) {
        this.numFoundExact = numFoundExact;
    }

    public Float getMaxScore() {
        return this.maxScore;
    }

    public void setMaxScore(Float maxScore) {
        this.maxScore = maxScore;
    }

    public long getNumFound() {
        return this.numFound;
    }

    public void setNumFound(long numFound) {
        this.numFound = numFound;
    }

    public long getStart() {
        return this.start;
    }

    public void setStart(long start) {
        this.start = start;
    }

    @Override
    public String toString() {
        return "{numFound=" + this.numFound + ",numFoundExact=" + String.valueOf(this.numFoundExact) + ",start=" + this.start + (String)(this.maxScore != null ? ",maxScore=" + this.maxScore : "") + ",docs=" + super.toString() + "}";
    }
}

