/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.IndexType;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for schema, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class SchemaApi {

  public static class GetDynamicFieldInfoResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.SchemaGetDynamicFieldInfoResponse> {
    public GetDynamicFieldInfoResponse() {
      super(org.apache.solr.client.api.model.SchemaGetDynamicFieldInfoResponse.class);
    }
  }

  public static class GetDynamicFieldInfo extends SolrRequest<GetDynamicFieldInfoResponse> {
    private final IndexType indexType;
    private final String indexName;
    private final String fieldName;

    /**
     * Create a GetDynamicFieldInfo request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     * @param fieldName Path param -
     */
    public GetDynamicFieldInfo(IndexType indexType, String indexName, String fieldName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema/dynamicfields/{fieldName}"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName)
              .replace("{" + "fieldName" + "}", fieldName));

      this.indexType = indexType;
      this.indexName = indexName;
      this.fieldName = fieldName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetDynamicFieldInfoResponse createResponse(SolrClient client) {
      return new GetDynamicFieldInfoResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetFieldInfoResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SchemaGetFieldInfoResponse> {
    public GetFieldInfoResponse() {
      super(org.apache.solr.client.api.model.SchemaGetFieldInfoResponse.class);
    }
  }

  public static class GetFieldInfo extends SolrRequest<GetFieldInfoResponse> {
    private final IndexType indexType;
    private final String indexName;
    private final String fieldName;

    /**
     * Create a GetFieldInfo request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     * @param fieldName Path param -
     */
    public GetFieldInfo(IndexType indexType, String indexName, String fieldName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema/fields/{fieldName}"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName)
              .replace("{" + "fieldName" + "}", fieldName));

      this.indexType = indexType;
      this.indexName = indexName;
      this.fieldName = fieldName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetFieldInfoResponse createResponse(SolrClient client) {
      return new GetFieldInfoResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetFieldTypeInfoResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.SchemaGetFieldTypeInfoResponse> {
    public GetFieldTypeInfoResponse() {
      super(org.apache.solr.client.api.model.SchemaGetFieldTypeInfoResponse.class);
    }
  }

  public static class GetFieldTypeInfo extends SolrRequest<GetFieldTypeInfoResponse> {
    private final IndexType indexType;
    private final String indexName;
    private final String fieldTypeName;

    /**
     * Create a GetFieldTypeInfo request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     * @param fieldTypeName Path param -
     */
    public GetFieldTypeInfo(IndexType indexType, String indexName, String fieldTypeName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema/fieldtypes/{fieldTypeName}"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName)
              .replace("{" + "fieldTypeName" + "}", fieldTypeName));

      this.indexType = indexType;
      this.indexName = indexName;
      this.fieldTypeName = fieldTypeName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetFieldTypeInfoResponse createResponse(SolrClient client) {
      return new GetFieldTypeInfoResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetSchemaInfoResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SchemaInfoResponse> {
    public GetSchemaInfoResponse() {
      super(org.apache.solr.client.api.model.SchemaInfoResponse.class);
    }
  }

  public static class GetSchemaInfo extends SolrRequest<GetSchemaInfoResponse> {
    private final IndexType indexType;
    private final String indexName;

    /**
     * Create a GetSchemaInfo request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     */
    public GetSchemaInfo(IndexType indexType, String indexName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName));

      this.indexType = indexType;
      this.indexName = indexName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetSchemaInfoResponse createResponse(SolrClient client) {
      return new GetSchemaInfoResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetSchemaNameResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SchemaNameResponse> {
    public GetSchemaNameResponse() {
      super(org.apache.solr.client.api.model.SchemaNameResponse.class);
    }
  }

  public static class GetSchemaName extends SolrRequest<GetSchemaNameResponse> {
    private final IndexType indexType;
    private final String indexName;

    /**
     * Create a GetSchemaName request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     */
    public GetSchemaName(IndexType indexType, String indexName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema/name"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName));

      this.indexType = indexType;
      this.indexName = indexName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetSchemaNameResponse createResponse(SolrClient client) {
      return new GetSchemaNameResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetSchemaSimilarityResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SchemaSimilarityResponse> {
    public GetSchemaSimilarityResponse() {
      super(org.apache.solr.client.api.model.SchemaSimilarityResponse.class);
    }
  }

  public static class GetSchemaSimilarity extends SolrRequest<GetSchemaSimilarityResponse> {
    private final IndexType indexType;
    private final String indexName;

    /**
     * Create a GetSchemaSimilarity request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     */
    public GetSchemaSimilarity(IndexType indexType, String indexName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema/similarity"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName));

      this.indexType = indexType;
      this.indexName = indexName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetSchemaSimilarityResponse createResponse(SolrClient client) {
      return new GetSchemaSimilarityResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetSchemaUniqueKeyResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SchemaUniqueKeyResponse> {
    public GetSchemaUniqueKeyResponse() {
      super(org.apache.solr.client.api.model.SchemaUniqueKeyResponse.class);
    }
  }

  public static class GetSchemaUniqueKey extends SolrRequest<GetSchemaUniqueKeyResponse> {
    private final IndexType indexType;
    private final String indexName;

    /**
     * Create a GetSchemaUniqueKey request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     */
    public GetSchemaUniqueKey(IndexType indexType, String indexName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema/uniquekey"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName));

      this.indexType = indexType;
      this.indexName = indexName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetSchemaUniqueKeyResponse createResponse(SolrClient client) {
      return new GetSchemaUniqueKeyResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetSchemaVersionResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SchemaVersionResponse> {
    public GetSchemaVersionResponse() {
      super(org.apache.solr.client.api.model.SchemaVersionResponse.class);
    }
  }

  public static class GetSchemaVersion extends SolrRequest<GetSchemaVersionResponse> {
    private final IndexType indexType;
    private final String indexName;

    /**
     * Create a GetSchemaVersion request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     */
    public GetSchemaVersion(IndexType indexType, String indexName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema/version"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName));

      this.indexType = indexType;
      this.indexName = indexName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected GetSchemaVersionResponse createResponse(SolrClient client) {
      return new GetSchemaVersionResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class GetSchemaZkVersionResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SchemaZkVersionResponse> {
    public GetSchemaZkVersionResponse() {
      super(org.apache.solr.client.api.model.SchemaZkVersionResponse.class);
    }
  }

  public static class GetSchemaZkVersion extends SolrRequest<GetSchemaZkVersionResponse> {
    private final IndexType indexType;
    private final String indexName;
    private Integer refreshIfBelowVersion;

    /**
     * Create a GetSchemaZkVersion request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     */
    public GetSchemaZkVersion(IndexType indexType, String indexName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema/zkversion"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName));

      this.indexType = indexType;
      this.indexName = indexName;
    }

    public void setRefreshIfBelowVersion(Integer refreshIfBelowVersion) {
      this.refreshIfBelowVersion = refreshIfBelowVersion;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (refreshIfBelowVersion != null) {

        params.add("refreshIfBelowVersion", refreshIfBelowVersion.toString());
      }
      return params;
    }

    @Override
    protected GetSchemaZkVersionResponse createResponse(SolrClient client) {
      return new GetSchemaZkVersionResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ListCopyFieldsResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.SchemaListCopyFieldsResponse> {
    public ListCopyFieldsResponse() {
      super(org.apache.solr.client.api.model.SchemaListCopyFieldsResponse.class);
    }
  }

  public static class ListCopyFields extends SolrRequest<ListCopyFieldsResponse> {
    private final IndexType indexType;
    private final String indexName;

    /**
     * Create a ListCopyFields request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     */
    public ListCopyFields(IndexType indexType, String indexName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema/copyfields"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName));

      this.indexType = indexType;
      this.indexName = indexName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected ListCopyFieldsResponse createResponse(SolrClient client) {
      return new ListCopyFieldsResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ListDynamicFieldsResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.SchemaListDynamicFieldsResponse> {
    public ListDynamicFieldsResponse() {
      super(org.apache.solr.client.api.model.SchemaListDynamicFieldsResponse.class);
    }
  }

  public static class ListDynamicFields extends SolrRequest<ListDynamicFieldsResponse> {
    private final IndexType indexType;
    private final String indexName;

    /**
     * Create a ListDynamicFields request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     */
    public ListDynamicFields(IndexType indexType, String indexName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema/dynamicfields"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName));

      this.indexType = indexType;
      this.indexName = indexName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected ListDynamicFieldsResponse createResponse(SolrClient client) {
      return new ListDynamicFieldsResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ListSchemaFieldTypesResponse
      extends JacksonParsingResponse<
          org.apache.solr.client.api.model.SchemaListFieldTypesResponse> {
    public ListSchemaFieldTypesResponse() {
      super(org.apache.solr.client.api.model.SchemaListFieldTypesResponse.class);
    }
  }

  public static class ListSchemaFieldTypes extends SolrRequest<ListSchemaFieldTypesResponse> {
    private final IndexType indexType;
    private final String indexName;

    /**
     * Create a ListSchemaFieldTypes request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     */
    public ListSchemaFieldTypes(IndexType indexType, String indexName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema/fieldtypes"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName));

      this.indexType = indexType;
      this.indexName = indexName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected ListSchemaFieldTypesResponse createResponse(SolrClient client) {
      return new ListSchemaFieldTypesResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ListSchemaFieldsResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.SchemaListFieldsResponse> {
    public ListSchemaFieldsResponse() {
      super(org.apache.solr.client.api.model.SchemaListFieldsResponse.class);
    }
  }

  public static class ListSchemaFields extends SolrRequest<ListSchemaFieldsResponse> {
    private final IndexType indexType;
    private final String indexName;

    /**
     * Create a ListSchemaFields request object.
     *
     * @param indexType Path param -
     * @param indexName Path param -
     */
    public ListSchemaFields(IndexType indexType, String indexName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/{indexType}/{indexName}/schema/fields"
              .replace("{" + "indexType" + "}", indexType.toString())
              .replace("{" + "indexName" + "}", indexName));

      this.indexType = indexType;
      this.indexName = indexName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public ApiVersion getApiVersion() {
      return ApiVersion.V2;
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected ListSchemaFieldsResponse createResponse(SolrClient client) {
      return new ListSchemaFieldsResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
