/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.solr.client.solrj.request;

import org.apache.solr.client.api.model.DeleteSnapshotResponse;
import org.apache.solr.client.solrj.JacksonParsingResponse;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

// WARNING: This class is generated from a Mustache template; any intended
// changes should be made to the underlying template and not this file directly.

/**
 * Experimental SolrRequest's and SolrResponse's for coreSnapshots, generated from an OAS.
 *
 * <p>See individual request and response classes for more detailed and relevant information.
 *
 * <p>All SolrRequest implementations rely on v2 APIs which may require a SolrClient configured to
 * use the '/api' path prefix, instead of '/solr'.
 *
 * @lucene.experimental
 */
public class CoreSnapshotsApi {

  public static class CreateSnapshotResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.CreateCoreSnapshotResponse> {
    public CreateSnapshotResponse() {
      super(org.apache.solr.client.api.model.CreateCoreSnapshotResponse.class);
    }
  }

  public static class CreateSnapshot extends SolrRequest<CreateSnapshotResponse> {
    private final String coreName;
    private final String snapshotName;
    private String async;

    /**
     * Create a CreateSnapshot request object.
     *
     * @param coreName Path param - The name of the core to snapshot.
     * @param snapshotName Path param - The name to associate with the core snapshot.
     */
    public CreateSnapshot(String coreName, String snapshotName) {
      super(
          SolrRequest.METHOD.valueOf("POST"),
          "/cores/{coreName}/snapshots/{snapshotName}"
              .replace("{" + "coreName" + "}", coreName)
              .replace("{" + "snapshotName" + "}", snapshotName));

      this.coreName = coreName;
      this.snapshotName = snapshotName;
    }

    /**
     * @param async The id to associate with the async task.
     */
    public void setAsync(String async) {
      this.async = async;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (async != null) {

        params.add("async", async);
      }
      return params;
    }

    @Override
    protected CreateSnapshotResponse createResponse(SolrClient client) {
      return new CreateSnapshotResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class DeleteSnapshotResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.DeleteSnapshotResponse> {
    public DeleteSnapshotResponse() {
      super(org.apache.solr.client.api.model.DeleteSnapshotResponse.class);
    }
  }

  public static class DeleteSnapshot extends SolrRequest<DeleteSnapshotResponse> {
    private final String coreName;
    private final String snapshotName;
    private String async;

    /**
     * Create a DeleteSnapshot request object.
     *
     * @param coreName Path param - The name of the core for which to delete a snapshot.
     * @param snapshotName Path param - The name of the core snapshot to delete.
     */
    public DeleteSnapshot(String coreName, String snapshotName) {
      super(
          SolrRequest.METHOD.valueOf("DELETE"),
          "/cores/{coreName}/snapshots/{snapshotName}"
              .replace("{" + "coreName" + "}", coreName)
              .replace("{" + "snapshotName" + "}", snapshotName));

      this.coreName = coreName;
      this.snapshotName = snapshotName;
    }

    /**
     * @param async The id to associate with the async task.
     */
    public void setAsync(String async) {
      this.async = async;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      if (async != null) {

        params.add("async", async);
      }
      return params;
    }

    @Override
    protected DeleteSnapshotResponse createResponse(SolrClient client) {
      return new DeleteSnapshotResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }

  public static class ListSnapshotsResponse
      extends JacksonParsingResponse<org.apache.solr.client.api.model.ListCoreSnapshotsResponse> {
    public ListSnapshotsResponse() {
      super(org.apache.solr.client.api.model.ListCoreSnapshotsResponse.class);
    }
  }

  public static class ListSnapshots extends SolrRequest<ListSnapshotsResponse> {
    private final String coreName;

    /**
     * Create a ListSnapshots request object.
     *
     * @param coreName Path param - The name of the core for which to retrieve snapshots.
     */
    public ListSnapshots(String coreName) {
      super(
          SolrRequest.METHOD.valueOf("GET"),
          "/cores/{coreName}/snapshots".replace("{" + "coreName" + "}", coreName));

      this.coreName = coreName;
    }

    // TODO Hardcode this for now, but in reality we'll want to parse this out of the Operation data
    // somehow
    @Override
    public String getRequestType() {
      return SolrRequestType.ADMIN.toString();
    }

    @Override
    public SolrParams getParams() {
      final ModifiableSolrParams params = new ModifiableSolrParams();
      return params;
    }

    @Override
    protected ListSnapshotsResponse createResponse(SolrClient client) {
      return new ListSnapshotsResponse();
    }

    @Override
    public ResponseParser getResponseParser() {
      return new InputStreamResponseParser("json");
    }
  }
}
