/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.crossdc.update.processor;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.cloud.CloudDescriptor;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.crossdc.common.CrossDcConf;
import org.apache.solr.crossdc.update.processor.ProducerMetrics;
import org.apache.solr.crossdc.update.processor.RequestMirroringHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.DistributedUpdateProcessor;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MirroringUpdateProcessor
extends UpdateRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final boolean doMirroring;
    final RequestMirroringHandler requestMirroringHandler;
    final ProducerMetrics producerMetrics;
    private final SolrParams mirrorParams;
    private final boolean indexUnmirrorableDocs;
    private final boolean mirrorCommits;
    private final CrossDcConf.ExpandDbq expandDbq;
    private final long maxMirroringDocSizeBytes;
    private DistributedUpdateProcessor.DistribPhase distribPhase;

    public MirroringUpdateProcessor(UpdateRequestProcessor next, boolean doMirroring, boolean indexUnmirrorableDocs, boolean mirrorCommits, CrossDcConf.ExpandDbq expandDbq, long maxMirroringBatchSizeBytes, SolrParams mirroredReqParams, DistributedUpdateProcessor.DistribPhase distribPhase, RequestMirroringHandler requestMirroringHandler, ProducerMetrics producerMetrics) {
        super(next);
        this.doMirroring = doMirroring;
        this.indexUnmirrorableDocs = indexUnmirrorableDocs;
        this.mirrorCommits = mirrorCommits;
        this.expandDbq = expandDbq;
        this.maxMirroringDocSizeBytes = maxMirroringBatchSizeBytes;
        this.mirrorParams = mirroredReqParams;
        this.distribPhase = distribPhase;
        this.requestMirroringHandler = requestMirroringHandler;
        this.producerMetrics = producerMetrics;
    }

    UpdateRequest createMirrorRequest() {
        UpdateRequest mirrorRequest = new UpdateRequest();
        mirrorRequest.setParams(new ModifiableSolrParams(this.mirrorParams));
        return mirrorRequest;
    }

    public void processAdd(AddUpdateCommand cmd) throws IOException {
        boolean tooLargeForKafka;
        UpdateRequest mirrorRequest = this.createMirrorRequest();
        SolrInputDocument doc = cmd.getSolrInputDocument().deepCopy();
        doc.removeField("_version_");
        long estimatedDocSizeInBytes = ObjectSizeEstimator.estimate(doc);
        if (log.isDebugEnabled()) {
            log.debug("estimated doc size is {} bytes, max size is {}", (Object)estimatedDocSizeInBytes, (Object)this.maxMirroringDocSizeBytes);
        }
        this.producerMetrics.getDocumentSize().update(estimatedDocSizeInBytes);
        boolean bl = tooLargeForKafka = estimatedDocSizeInBytes > this.maxMirroringDocSizeBytes;
        if (tooLargeForKafka && !this.indexUnmirrorableDocs) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Update exceeds the doc-size limit and is unmirrorable. id=" + cmd.getPrintableId() + " doc size=" + estimatedDocSizeInBytes + " maxDocSize=" + this.maxMirroringDocSizeBytes);
        }
        if (tooLargeForKafka) {
            this.producerMetrics.getDocumentTooLarge().inc();
            log.warn("Skipping mirroring of doc {} as it exceeds the doc-size limit ({} bytes) and is unmirrorable. doc size={}", new Object[]{cmd.getPrintableId(), this.maxMirroringDocSizeBytes, estimatedDocSizeInBytes});
        }
        try {
            super.processAdd(cmd);
            this.producerMetrics.getLocal().inc();
        }
        catch (IOException exception) {
            this.producerMetrics.getLocalError().inc();
            throw exception;
        }
        boolean isLeader = this.isLeader(cmd.getReq(), cmd.getIndexedIdStr(), null, cmd.getSolrInputDocument());
        if (!tooLargeForKafka && this.doMirroring && isLeader) {
            mirrorRequest.add(doc, Integer.valueOf(cmd.commitWithin), Boolean.valueOf(cmd.overwrite));
            try {
                this.requestMirroringHandler.mirror(mirrorRequest);
                this.producerMetrics.getSubmitted().inc();
            }
            catch (Exception e) {
                log.error("mirror submit failed", (Throwable)e);
                this.producerMetrics.getSubmitError().inc();
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "mirror submit failed", (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("processAdd isLeader={} doMirroring={} tooLargeForKafka={} cmd={}", new Object[]{isLeader, this.doMirroring, tooLargeForKafka, cmd});
        }
    }

    public void processDelete(DeleteUpdateCommand cmd) throws IOException {
        if (this.doMirroring && this.expandDbq != CrossDcConf.ExpandDbq.NONE && !cmd.isDeleteById() && !"*:*".equals(cmd.query)) {
            CloudDescriptor cloudDesc = cmd.getReq().getCore().getCoreDescriptor().getCloudDescriptor();
            String collection = cloudDesc.getCollectionName();
            try {
                String uniqueField = cmd.getReq().getSchema().getUniqueKeyField().getName();
                int rows = Integer.getInteger("solr.crossdc.dbq_rows", 1000);
                SolrQuery q = new SolrQuery(cmd.query).setRows(Integer.valueOf(rows)).setSort(SolrQuery.SortClause.asc((String)uniqueField)).setFields(new String[]{uniqueField});
                String cursorMark = "*";
                int cnt = 1;
                boolean done = false;
                while (!done) {
                    q.set("cursorMark", new String[]{cursorMark});
                    Http2SolrClient client = cmd.getReq().getCoreContainer().getDefaultHttpSolrClient();
                    QueryResponse rsp = client.query(collection, (SolrParams)q);
                    String nextCursorMark = rsp.getNextCursorMark();
                    if (log.isDebugEnabled()) {
                        log.debug("resp: cm={}, ncm={}, cnt={}, results={} ", new Object[]{cursorMark, nextCursorMark, cnt, rsp.getResults()});
                        ++cnt;
                    }
                    MirroringUpdateProcessor.processDBQResults((SolrClient)client, collection, uniqueField, rsp);
                    if (cursorMark.equals(nextCursorMark)) {
                        done = true;
                    }
                    cursorMark = nextCursorMark;
                }
            }
            catch (SolrServerException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
            }
            return;
        }
        super.processDelete(cmd);
        if (this.doMirroring) {
            boolean isLeader = false;
            UpdateRequest mirrorRequest = this.createMirrorRequest();
            if (cmd.isDeleteById()) {
                isLeader = this.isLeader(cmd.getReq(), cmd.getId(), null != cmd.getRoute() ? cmd.getRoute() : cmd.getReq().getParams().get("_route_"), null);
                if (isLeader) {
                    mirrorRequest.deleteById(cmd.getId());
                    try {
                        this.requestMirroringHandler.mirror(mirrorRequest);
                    }
                    catch (Exception e) {
                        log.error("mirror submit failed", (Throwable)e);
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "mirror submit failed", (Throwable)e);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("processDelete doMirroring={} isLeader={} cmd={}", new Object[]{true, isLeader, cmd});
                }
            } else {
                if (this.distribPhase == DistributedUpdateProcessor.DistribPhase.NONE) {
                    mirrorRequest.deleteByQuery(cmd.query);
                    try {
                        this.requestMirroringHandler.mirror(mirrorRequest);
                    }
                    catch (Exception e) {
                        log.error("mirror submit failed", (Throwable)e);
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "mirror submit failed", (Throwable)e);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("processDelete doMirroring={} cmd={}", (Object)true, (Object)cmd);
                }
            }
        }
    }

    private static void processDBQResults(SolrClient client, String collection, String uniqueField, QueryResponse rsp) throws SolrServerException, IOException {
        SolrDocumentList results = rsp.getResults();
        ArrayList ids = new ArrayList(results.size());
        results.forEach(entries -> {
            String id = entries.getFirstValue(uniqueField).toString();
            ids.add(id);
        });
        if (!ids.isEmpty()) {
            client.deleteById(collection, ids);
        }
    }

    boolean isLeader(SolrQueryRequest req, String id, String route, SolrInputDocument doc) {
        String shardId;
        CloudDescriptor cloudDesc = req.getCore().getCoreDescriptor().getCloudDescriptor();
        String collection = cloudDesc.getCollectionName();
        ClusterState clusterState = req.getCore().getCoreContainer().getZkController().getClusterState();
        DocCollection coll = clusterState.getCollection(collection);
        Slice slice = coll.getRouter().getTargetSlice(id, doc, route, req.getParams(), coll);
        if (slice == null && (slice = coll.getSlice(shardId = cloudDesc.getShardId())) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No shard " + shardId + " in " + coll);
        }
        shardId = slice.getName();
        Replica leaderReplica = null;
        try {
            leaderReplica = req.getCore().getCoreContainer().getZkController().getZkStateReader().getLeaderRetry(collection, shardId);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
        }
        return leaderReplica.getName().equals(cloudDesc.getCoreNodeName());
    }

    public void processRollback(RollbackUpdateCommand cmd) throws IOException {
        super.processRollback(cmd);
    }

    private boolean shouldMirrorCommit(SolrQueryRequest req) {
        CloudDescriptor cd = req.getCore().getCoreDescriptor().getCloudDescriptor();
        if (cd != null) {
            Replica leaderReplica;
            ClusterState clusterState;
            DocCollection coll;
            String firstShard;
            String shardId = cd.getShardId();
            if (!shardId.equals(firstShard = (String)new TreeMap((coll = (clusterState = req.getCore().getCoreContainer().getZkController().getClusterState()).getCollection(cd.getCollectionName())).getSlicesMap()).keySet().iterator().next())) {
                return false;
            }
            try {
                leaderReplica = req.getCore().getCoreContainer().getZkController().getZkStateReader().getLeaderRetry(cd.getCollectionName(), shardId);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
            }
            return leaderReplica.getName().equals(cd.getCoreNodeName());
        }
        return false;
    }

    public void processCommit(CommitUpdateCommand cmd) throws IOException {
        log.debug("process commit cmd={}", (Object)cmd);
        if (this.next != null) {
            this.next.processCommit(cmd);
        }
        if (!this.mirrorCommits) {
            return;
        }
        UpdateRequest req = this.createMirrorRequest();
        boolean shouldMirror = this.shouldMirrorCommit(cmd.getReq());
        if (this.doMirroring && shouldMirror) {
            req.setParam("commit", "true");
            if (cmd.optimize) {
                req.setParam("optimize", "true");
            }
            if (cmd.softCommit) {
                req.setParam("softCommit", "true");
            }
            if (cmd.prepareCommit) {
                req.setParam("prepareCommit", "true");
            }
            if (cmd.waitSearcher) {
                req.setParam("waitSearcher", "true");
            }
            if (cmd.openSearcher) {
                req.setParam("openSearcher", "true");
            }
            if (cmd.expungeDeletes) {
                req.setParam("expungeDeletes", "true");
            }
            if (cmd.maxOptimizeSegments != 0) {
                req.setParam("maxSegments", Integer.toString(cmd.maxOptimizeSegments));
            }
            log.debug(" --doMirroring commit req={}", (Object)req);
            try {
                this.requestMirroringHandler.mirror(req);
            }
            catch (Exception e) {
                log.error("mirror submit failed", (Throwable)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "mirror submit failed", (Throwable)e);
            }
        } else {
            log.debug(" -- skip commit mirroring, doMirroring={}, shouldMirror={}", (Object)this.doMirroring, (Object)shouldMirror);
        }
    }

    public final void finish() throws IOException {
        super.finish();
    }

    static class ObjectSizeEstimator {
        private static final IdentityHashMap<Class<?>, Integer> primitiveSizes = new IdentityHashMap();

        ObjectSizeEstimator() {
        }

        public static long estimate(SolrInputDocument doc) {
            if (doc == null) {
                return 0L;
            }
            long size = 0L;
            for (SolrInputField inputField : doc.values()) {
                size += ObjectSizeEstimator.primitiveEstimate(inputField.getName(), 0L);
                size += ObjectSizeEstimator.estimate(inputField.getValue());
            }
            if (doc.hasChildDocuments()) {
                for (SolrInputDocument childDoc : doc.getChildDocuments()) {
                    size += ObjectSizeEstimator.estimate(childDoc);
                }
            }
            return size;
        }

        static long estimate(Object obj) {
            if (obj instanceof SolrInputDocument) {
                return ObjectSizeEstimator.estimate((SolrInputDocument)obj);
            }
            if (obj instanceof Map) {
                return ObjectSizeEstimator.estimate((Map)obj);
            }
            if (obj instanceof Collection) {
                return ObjectSizeEstimator.estimate((Collection)obj);
            }
            return ObjectSizeEstimator.primitiveEstimate(obj, 0L);
        }

        private static long primitiveEstimate(Object obj, long def) {
            Class<?> clazz = obj.getClass();
            if (clazz.isPrimitive()) {
                return primitiveSizes.get(clazz).intValue();
            }
            if (obj instanceof String) {
                return (long)((String)obj).length() * 2L;
            }
            return def;
        }

        private static long estimate(Map<Object, Object> map) {
            if (map.isEmpty()) {
                return 0L;
            }
            long size = 0L;
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                size += ObjectSizeEstimator.primitiveEstimate(entry.getKey(), 0L);
                size += ObjectSizeEstimator.estimate(entry.getValue());
            }
            return size;
        }

        private static long estimate(Collection collection) {
            if (collection.isEmpty()) {
                return 0L;
            }
            long size = 0L;
            for (Object obj : collection) {
                size += ObjectSizeEstimator.estimate(obj);
            }
            return size;
        }

        static {
            primitiveSizes.put(Boolean.TYPE, 1);
            primitiveSizes.put(Boolean.class, 1);
            primitiveSizes.put(Byte.TYPE, 1);
            primitiveSizes.put(Byte.class, 1);
            primitiveSizes.put(Character.TYPE, 2);
            primitiveSizes.put(Character.class, 2);
            primitiveSizes.put(Short.TYPE, 2);
            primitiveSizes.put(Short.class, 2);
            primitiveSizes.put(Integer.TYPE, 4);
            primitiveSizes.put(Integer.class, 4);
            primitiveSizes.put(Float.TYPE, 4);
            primitiveSizes.put(Float.class, 4);
            primitiveSizes.put(Double.TYPE, 8);
            primitiveSizes.put(Double.class, 8);
            primitiveSizes.put(Long.TYPE, 8);
            primitiveSizes.put(Long.class, 8);
        }
    }
}

