/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.osgi;

import java.io.File;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.testing.tools.http.RequestBuilder;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.apache.sling.testing.tools.http.RetryingContentChecker;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebconsoleClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final RequestExecutor executor;
    private final RequestBuilder builder;
    private final String username;
    private final String password;
    public static final String JSON_KEY_ID = "id";
    public static final String JSON_KEY_VERSION = "version";
    public static final String JSON_KEY_DATA = "data";
    public static final String JSON_KEY_STATE = "state";
    public static final String CONSOLE_BUNDLES_PATH = "/system/console/bundles";

    public WebconsoleClient(String slingServerUrl, String username, String password) {
        this.builder = new RequestBuilder(slingServerUrl);
        this.executor = new RequestExecutor(new DefaultHttpClient());
        this.username = username;
        this.password = password;
    }

    public void uninstallBundle(String symbolicName, File f) throws Exception {
        long bundleId = this.getBundleId(symbolicName);
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("action", (ContentBody)new StringBody("uninstall"));
        this.executor.execute(this.builder.buildPostRequest("/system/console/bundles/" + bundleId).withCredentials(this.username, this.password).withEntity((HttpEntity)entity)).assertStatus(200);
    }

    public void installBundle(File f, boolean startBundle) throws Exception {
        this.installBundle(f, startBundle, 0);
    }

    public void installBundle(File f, boolean startBundle, int startLevel) throws Exception {
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("action", (ContentBody)new StringBody("install"));
        if (startBundle) {
            entity.addPart("bundlestart", (ContentBody)new StringBody("true"));
        }
        entity.addPart("bundlefile", (ContentBody)new FileBody(f));
        if (startLevel > 0) {
            entity.addPart("bundlestartlevel", (ContentBody)new StringBody(String.valueOf(startLevel)));
            this.log.info("Installing bundle {} at start level {}", (Object)f.getName(), (Object)startLevel);
        } else {
            this.log.info("Installing bundle {} at default start level", (Object)f.getName());
        }
        this.executor.execute(this.builder.buildPostRequest(CONSOLE_BUNDLES_PATH).withCredentials(this.username, this.password).withEntity((HttpEntity)entity)).assertStatus(302);
    }

    public void checkBundleInstalled(String symbolicName, int timeoutSeconds) {
        String path = this.getBundlePath(symbolicName, ".json");
        new RetryingContentChecker(this.executor, this.builder).check(path, 200, timeoutSeconds, 500);
    }

    private JSONObject getBundleData(String symbolicName) throws Exception {
        JSONObject bundle;
        JSONArray data;
        String path = this.getBundlePath(symbolicName, ".json");
        String content = this.executor.execute(this.builder.buildGetRequest(path, new String[0]).withCredentials(this.username, this.password)).assertStatus(200).getContent();
        JSONObject root = new JSONObject(content);
        if (!root.has(JSON_KEY_DATA)) {
            Assert.fail((String)(path + " does not provide '" + JSON_KEY_DATA + "' element, JSON content=" + content));
        }
        if ((data = root.getJSONArray(JSON_KEY_DATA)).length() < 1) {
            Assert.fail((String)(path + "." + JSON_KEY_DATA + " is empty, JSON content=" + content));
        }
        if (!(bundle = data.getJSONObject(0)).has(JSON_KEY_STATE)) {
            Assert.fail((String)(path + ".data[0].state missing, JSON content=" + content));
        }
        return bundle;
    }

    public long getBundleId(String symbolicName) throws Exception {
        JSONObject bundle = this.getBundleData(symbolicName);
        return bundle.getLong(JSON_KEY_ID);
    }

    public String getBundleVersion(String symbolicName) throws Exception {
        JSONObject bundle = this.getBundleData(symbolicName);
        return bundle.getString(JSON_KEY_VERSION);
    }

    public String getBundleState(String symbolicName) throws Exception {
        JSONObject bundle = this.getBundleData(symbolicName);
        return bundle.getString(JSON_KEY_STATE);
    }

    public void startBundle(String symbolicName) throws Exception {
        String path = this.getBundlePath(symbolicName, null);
        this.log.info("Starting bundle {} via {}", (Object)symbolicName, (Object)path);
        MultipartEntity entity = new MultipartEntity();
        entity.addPart("action", (ContentBody)new StringBody("start"));
        this.executor.execute(this.builder.buildPostRequest(path).withCredentials(this.username, this.password).withEntity((HttpEntity)entity)).assertStatus(200);
    }

    private String getBundlePath(String symbolicName, String extension) {
        return "/system/console/bundles/" + symbolicName + (extension == null ? "" : extension);
    }
}

