/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.sling;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.sling.testing.tools.http.RequestBuilder;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.apache.sling.testing.tools.jarexec.JarExecutor;
import org.apache.sling.testing.tools.osgi.WebconsoleClient;
import org.apache.sling.testing.tools.sling.BundlesInstaller;
import org.apache.sling.testing.tools.sling.TimeoutsProvider;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SlingTestBase {
    public static final String TEST_SERVER_URL_PROP = "test.server.url";
    public static final String TEST_SERVER_USERNAME = "test.server.username";
    public static final String TEST_SERVER_PASSWORD = "test.server.password";
    public static final String SERVER_READY_TIMEOUT_PROP = "server.ready.timeout.seconds";
    public static final String SERVER_READY_PROP_PREFIX = "server.ready.path";
    public static final String KEEP_JAR_RUNNING_PROP = "keepJarRunning";
    public static final String SERVER_HOSTNAME_PROP = "test.server.hostname";
    public static final String ADDITONAL_BUNDLES_PATH = "additional.bundles.path";
    public static final String BUNDLE_TO_INSTALL_PREFIX = "sling.additional.bundle";
    public static final String START_BUNDLES_TIMEOUT_SECONDS = "start.bundles.timeout.seconds";
    public static final String BUNDLE_INSTALL_TIMEOUT_SECONDS = "bundle.install.timeout.seconds";
    public static final String ADMIN = "admin";
    private static final boolean keepJarRunning = "true".equals(System.getProperty("keepJarRunning"));
    private final String serverBaseUrl;
    private final String serverUsername;
    private final String serverPassword;
    private RequestBuilder builder;
    private DefaultHttpClient httpClient = new DefaultHttpClient();
    private RequestExecutor executor = new RequestExecutor(this.httpClient);
    private WebconsoleClient webconsoleClient;
    private BundlesInstaller bundlesInstaller;
    private static boolean serverStarted;
    private static boolean serverStartedByThisClass;
    private static boolean serverReady;
    private static boolean serverReadyTestFailed;
    private static boolean installBundlesFailed;
    private static boolean extraBundlesInstalled;
    private static boolean startupInfoProvided;
    private static boolean serverInfoLogged;
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static JarExecutor jarExecutor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SlingTestBase() {
        String configuredUrl;
        if (jarExecutor == null) {
            SlingTestBase slingTestBase = this;
            synchronized (slingTestBase) {
                try {
                    jarExecutor = new JarExecutor(System.getProperties());
                }
                catch (Exception e) {
                    this.log.error("JarExecutor setup failed", (Throwable)e);
                    Assert.fail((String)("JarExecutor setup failed: " + e));
                }
            }
        }
        if ((configuredUrl = System.getProperty(TEST_SERVER_URL_PROP, System.getProperty("launchpad.http.server.url"))) != null) {
            this.serverBaseUrl = configuredUrl;
            serverStarted = true;
        } else {
            String serverHost = System.getProperty(SERVER_HOSTNAME_PROP);
            if (serverHost == null || serverHost.trim().length() == 0) {
                serverHost = "localhost";
            }
            this.serverBaseUrl = "http://" + serverHost + ":" + jarExecutor.getServerPort();
        }
        String configuredUsername = System.getProperty(TEST_SERVER_USERNAME);
        this.serverUsername = configuredUsername != null && configuredUsername.trim().length() > 0 ? configuredUsername : ADMIN;
        String configuredPassword = System.getProperty(TEST_SERVER_PASSWORD);
        this.serverPassword = configuredPassword != null && configuredPassword.trim().length() > 0 ? configuredPassword : ADMIN;
        this.builder = new RequestBuilder(this.serverBaseUrl);
        this.webconsoleClient = new WebconsoleClient(this.serverBaseUrl, this.serverUsername, this.serverPassword);
        this.builder = new RequestBuilder(this.serverBaseUrl);
        this.bundlesInstaller = new BundlesInstaller(this.webconsoleClient);
        if (!serverInfoLogged) {
            this.log.info("Server base URL={}", (Object)this.serverBaseUrl);
            serverInfoLogged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServerIfNeeded() {
        try {
            if (serverStarted && !serverStartedByThisClass && !startupInfoProvided) {
                this.log.info("test.server.url was set: not starting server jar (" + this.serverBaseUrl + ")");
            }
            if (!serverStarted) {
                JarExecutor jarExecutor = SlingTestBase.jarExecutor;
                synchronized (jarExecutor) {
                    if (!serverStarted) {
                        SlingTestBase.jarExecutor.start();
                        serverStartedByThisClass = true;
                        serverStarted = true;
                    }
                }
            }
            startupInfoProvided = true;
            this.waitForServerReady();
            this.installAdditionalBundles();
            this.blockIfRequested();
        }
        catch (Exception e) {
            this.log.error("Exception in maybeStartServer()", (Throwable)e);
            Assert.fail((String)("maybeStartServer() failed: " + e));
        }
    }

    protected void installAdditionalBundles() {
        if (installBundlesFailed) {
            Assert.fail((String)"Bundles could not be installed, cannot run tests");
        } else if (!extraBundlesInstalled) {
            String path = System.getProperty(ADDITONAL_BUNDLES_PATH);
            if (path == null) {
                this.log.info("System property {} not set, additional bundles won't be installed", (Object)ADDITONAL_BUNDLES_PATH);
            } else {
                List<File> toInstall = this.getBundlesToInstall(path);
                try {
                    this.bundlesInstaller.installBundles(toInstall, false);
                    LinkedList<String> symbolicNames = new LinkedList<String>();
                    for (File f : toInstall) {
                        symbolicNames.add(this.bundlesInstaller.getBundleSymbolicName(f));
                    }
                    this.bundlesInstaller.waitForBundlesInstalled(symbolicNames, TimeoutsProvider.getInstance().getTimeout(BUNDLE_INSTALL_TIMEOUT_SECONDS, 10));
                    this.bundlesInstaller.startAllBundles(symbolicNames, TimeoutsProvider.getInstance().getTimeout(START_BUNDLES_TIMEOUT_SECONDS, 30));
                }
                catch (AssertionError ae) {
                    this.log.info("Exception while installing additional bundles", (Throwable)((Object)ae));
                    installBundlesFailed = true;
                }
                catch (Exception e) {
                    this.log.info("Exception while installing additional bundles", (Throwable)e);
                    installBundlesFailed = true;
                }
                if (installBundlesFailed) {
                    Assert.fail((String)("Could not start all installed bundles:" + toInstall));
                }
            }
        }
        extraBundlesInstalled = !installBundlesFailed;
    }

    protected RequestBuilder getRequestBuilder() {
        this.startServerIfNeeded();
        return this.builder;
    }

    protected String getServerBaseUrl() {
        this.startServerIfNeeded();
        return this.serverBaseUrl;
    }

    protected String getServerUsername() {
        return this.serverUsername;
    }

    protected String getServerPassword() {
        return this.serverPassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void blockIfRequested() {
        if (keepJarRunning) {
            this.log.info("keepJarRunning set to true - entering infinite loop so that runnable jar stays up. Kill this process to exit.");
            SlingTestBase slingTestBase = this;
            synchronized (slingTestBase) {
                try {
                    this.wait();
                }
                catch (InterruptedException iex) {
                    this.log.info("InterruptedException in blockIfRequested");
                }
            }
        }
    }

    protected void waitForServerReady() throws Exception {
        if (serverReady) {
            return;
        }
        if (serverReadyTestFailed) {
            Assert.fail((String)"Server is not ready according to previous tests");
        }
        String sec = System.getProperty(SERVER_READY_TIMEOUT_PROP);
        int timeoutSec = TimeoutsProvider.getInstance().getTimeout(sec == null ? 60 : Integer.valueOf(sec));
        this.log.info("Will wait up to " + timeoutSec + " seconds for server to become ready");
        long endTime = System.currentTimeMillis() + (long)timeoutSec * 1000L;
        ArrayList<String> testPaths = new ArrayList<String>();
        TreeSet<Object> propertyNames = new TreeSet<Object>();
        propertyNames.addAll(System.getProperties().keySet());
        for (Object e : propertyNames) {
            String key = (String)e;
            if (!key.startsWith(SERVER_READY_PROP_PREFIX)) continue;
            testPaths.add(System.getProperty(key));
        }
        this.log.info("Checking that GET requests return expected content (timeout={} seconds): {}", (Object)timeoutSec, testPaths);
        while (System.currentTimeMillis() < endTime) {
            boolean errors = false;
            for (String p : testPaths) {
                String[] s = p.split(":");
                String path = s[0];
                String pattern = s.length > 0 ? s[1] : "";
                try {
                    this.executor.execute(this.builder.buildGetRequest(path, new String[0]).withCredentials(this.serverUsername, this.serverPassword)).assertStatus(200).assertContentContains(pattern);
                }
                catch (AssertionError ae) {
                    errors = true;
                    this.log.debug("Request to {}@{}{} failed, will retry ({})", new Object[]{this.serverUsername, this.serverBaseUrl, path, ae});
                }
                catch (Exception e) {
                    errors = true;
                    this.log.debug("Request to {}@{}{} failed, will retry ({})", new Object[]{this.serverUsername, this.serverBaseUrl, path, pattern, e});
                }
            }
            if (!errors) {
                serverReady = true;
                this.log.info("All {} paths return expected content, server ready", (Object)testPaths.size());
                break;
            }
            Thread.sleep(TimeoutsProvider.getInstance().getTimeout(1000L));
        }
        if (!serverReady) {
            serverReadyTestFailed = true;
            String msg = "Server not ready after " + timeoutSec + " seconds, giving up";
            this.log.info(msg);
            Assert.fail((String)msg);
        }
    }

    protected List<File> getBundlesToInstall(String additionalBundlesPath) {
        LinkedList<File> result = new LinkedList<File>();
        if (additionalBundlesPath == null) {
            return result;
        }
        File dir = new File(additionalBundlesPath);
        if (!dir.isDirectory() || !dir.canRead()) {
            this.log.info("Cannot read additional bundles directory {}, ignored", (Object)dir.getAbsolutePath());
            return result;
        }
        ArrayList<String> bundleNames = new ArrayList<String>();
        String[] files = dir.list();
        if (files != null) {
            for (String file : files) {
                if (!file.endsWith(".jar")) continue;
                bundleNames.add(file);
            }
        }
        ArrayList<String> sortedPropertyKeys = new ArrayList<String>();
        for (Object key : System.getProperties().keySet()) {
            String str = key.toString();
            if (!str.startsWith(BUNDLE_TO_INSTALL_PREFIX)) continue;
            sortedPropertyKeys.add(str);
        }
        Collections.sort(sortedPropertyKeys);
        for (String key : sortedPropertyKeys) {
            String filenamePrefix = System.getProperty(key);
            for (String bundleFilename : bundleNames) {
                if (!bundleFilename.startsWith(filenamePrefix)) continue;
                result.add(new File(dir, bundleFilename));
            }
        }
        return result;
    }

    protected boolean isServerStartedByThisClass() {
        return serverStartedByThisClass;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected RequestExecutor getRequestExecutor() {
        return this.executor;
    }

    protected WebconsoleClient getWebconsoleClient() {
        this.startServerIfNeeded();
        return this.webconsoleClient;
    }
}

