/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.tools.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.apache.sling.testing.tools.http.Request;
import org.apache.sling.testing.tools.http.RequestDocumentor;
import org.junit.Assert;

public class RequestExecutor {
    private final DefaultHttpClient httpClient;
    private HttpUriRequest request;
    private HttpResponse response;
    private HttpEntity entity;
    private String content;

    public RequestExecutor(DefaultHttpClient client) {
        this.httpClient = client;
    }

    public String toString() {
        if (this.request == null) {
            return "Request";
        }
        return this.request.getMethod() + " request to " + this.request.getURI();
    }

    public RequestExecutor execute(Request r) throws ClientProtocolException, IOException {
        this.clear();
        r.customizeIfNeeded();
        this.request = r.getRequest();
        if (r.getUsername() != null) {
            this.httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(r.getUsername(), r.getPassword()));
            this.httpClient.addRequestInterceptor((HttpRequestInterceptor)new PreemptiveAuthInterceptor(), 0);
        } else {
            this.httpClient.getCredentialsProvider().setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.getClass().getName(), this.getClass().getSimpleName()));
            this.httpClient.removeRequestInterceptorByClass(PreemptiveAuthInterceptor.class);
        }
        this.httpClient.getParams().setBooleanParameter("http.protocol.handle-redirects", r.getRedirects());
        this.response = this.httpClient.execute(this.request);
        this.entity = this.response.getEntity();
        if (this.entity != null) {
            this.consumeEntity();
        }
        return this;
    }

    protected void consumeEntity() throws ParseException, IOException {
        this.content = EntityUtils.toString((HttpEntity)this.entity);
        this.entity.consumeContent();
    }

    protected void clear() {
        this.request = null;
        this.entity = null;
        this.response = null;
        this.content = null;
    }

    public RequestExecutor assertStatus(int expected) {
        Assert.assertNotNull((String)this.toString(), (Object)this.response);
        Assert.assertEquals((String)(this + ": expecting status " + expected), (long)expected, (long)this.response.getStatusLine().getStatusCode());
        return this;
    }

    public RequestExecutor assertContentType(String expected) {
        String contentType;
        Assert.assertNotNull((String)this.toString(), (Object)this.response);
        if (this.entity == null) {
            Assert.fail((String)(this + ": no entity in response, cannot check content type"));
        }
        if ((contentType = this.entity.getContentType().getValue()) != null) {
            contentType = contentType.split(";")[0].trim();
        }
        Assert.assertEquals((String)(this + ": expecting content type " + expected), (Object)expected, (Object)contentType);
        return this;
    }

    public RequestExecutor assertContentRegexp(String ... regexp) throws IOException {
        Assert.assertNotNull((String)this.toString(), (Object)this.response);
        block0: for (String expr : regexp) {
            Pattern p = Pattern.compile(".*" + expr + ".*");
            BufferedReader br = new BufferedReader(new StringReader(this.content));
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!p.matcher(line).matches()) continue;
                continue block0;
            }
            Assert.fail((String)(this + ": no match for regexp '" + expr + "', content=\n" + this.content));
        }
        return this;
    }

    public RequestExecutor assertContentContains(String ... expected) throws ParseException, IOException {
        Assert.assertNotNull((String)this.toString(), (Object)this.response);
        for (String exp : expected) {
            if (this.content.contains(exp)) continue;
            Assert.fail((String)(this + ": content does not contain '" + exp + "', content=\n" + this.content));
        }
        return this;
    }

    public void generateDocumentation(RequestDocumentor documentor, String ... metadata) throws IOException {
        documentor.generateDocumentation(this, metadata);
    }

    public HttpUriRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public HttpEntity getEntity() {
        return this.entity;
    }

    public String getContent() {
        return this.content;
    }

    private static class PreemptiveAuthInterceptor
    implements HttpRequestInterceptor {
        private PreemptiveAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            AuthScope authScope;
            Credentials creds;
            AuthState authState = (AuthState)context.getAttribute("http.auth.target-scope");
            CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            HttpHost targetHost = (HttpHost)context.getAttribute("http.target_host");
            if (authState.getAuthScheme() == null && (creds = credsProvider.getCredentials(authScope = new AuthScope(targetHost.getHostName(), targetHost.getPort()))) != null) {
                authState.setAuthScheme((AuthScheme)new BasicScheme());
                authState.setCredentials(creds);
            }
        }
    }
}

