/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.jcr.contentloader.ContentImportListener;
import org.apache.sling.jcr.contentloader.ContentImporter;
import org.apache.sling.jcr.contentloader.ImportOptions;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.ModificationType;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;
import org.apache.sling.servlets.post.impl.operations.AbstractCreateOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportOperation
extends AbstractCreateOperation {
    private ContentImporter contentImporter;

    public void setContentImporter(ContentImporter importer) {
        this.contentImporter = importer;
    }

    private String getRequestParamAsString(SlingHttpServletRequest request, String key) {
        RequestParameter requestParameter = request.getRequestParameter(key);
        if (requestParameter == null) {
            return null;
        }
        return requestParameter.getString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doRun(SlingHttpServletRequest request, PostResponse response, final List<Modification> changes) throws RepositoryException {
        String targetName;
        ContentImporter importer = this.contentImporter;
        if (importer == null) {
            response.setStatus(500, "Missing content importer for import");
            return;
        }
        Map<String, RequestProperty> reqProperties = this.collectContent(request, response);
        VersioningConfiguration versioningConfiguration = this.getVersioningConfiguration(request);
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        try {
            this.processCreate(request.getResourceResolver(), reqProperties, response, changes, versioningConfiguration);
        }
        catch (PersistenceException pe) {
            if (!(pe.getCause() instanceof RepositoryException)) throw new RepositoryException((Throwable)pe);
            throw (RepositoryException)pe.getCause();
        }
        String path = response.getPath();
        Node node = null;
        try {
            node = (Node)session.getItem(path);
        }
        catch (RepositoryException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        catch (ClassCastException e) {
            this.log.warn(e.getMessage(), (Throwable)e);
        }
        if (node == null) {
            response.setStatus(404, "Missing target node " + path + " for import");
            return;
        }
        String contentType = this.getRequestParamAsString(request, ":contentType");
        if (contentType == null) {
            response.setStatus(412, "Required :contentType parameter is missing");
            return;
        }
        final boolean replace = "true".equalsIgnoreCase(this.getRequestParamAsString(request, ":replace"));
        final boolean replaceProperties = "true".equalsIgnoreCase(this.getRequestParamAsString(request, ":replaceProperties"));
        final boolean checkin = "true".equalsIgnoreCase(this.getRequestParamAsString(request, ":checkin"));
        final boolean autoCheckout = "true".equalsIgnoreCase(this.getRequestParamAsString(request, ":autoCheckout"));
        String basePath = this.getItemPath(request);
        if ((basePath = this.removeAndValidateWorkspace(basePath, (Session)request.getResourceResolver().adaptTo(Session.class))).endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        response.setCreateRequest(true);
        if (this.getRequestParamAsString(request, ":name") != null) {
            targetName = this.getRequestParamAsString(request, ":name");
            if (targetName.length() > 0 && node.hasNode(targetName)) {
                if (!replace) {
                    response.setStatus(412, "Cannot import " + path + "/" + targetName + ": node exists");
                    return;
                }
                response.setCreateRequest(false);
            }
        } else if (this.getRequestParamAsString(request, ":nameHint") != null) {
            String name;
            String nodePath = this.generateName(request, basePath);
            targetName = name = nodePath.substring(nodePath.lastIndexOf(47) + 1);
        } else {
            targetName = "";
        }
        String contentRootName = targetName + "." + contentType;
        try {
            InputStream contentStream = null;
            RequestParameter contentParameter = request.getRequestParameter(":content");
            if (contentParameter != null) {
                contentStream = contentParameter.getInputStream();
            } else {
                RequestParameter contentFile = request.getRequestParameter(":contentFile");
                if (contentFile != null) {
                    contentStream = contentFile.getInputStream();
                }
            }
            if (contentStream == null) {
                response.setStatus(412, "Missing content for import");
                return;
            }
            importer.importContent(node, contentRootName, contentStream, new ImportOptions(){

                public boolean isCheckin() {
                    return checkin;
                }

                public boolean isAutoCheckout() {
                    return autoCheckout;
                }

                public boolean isIgnoredImportProvider(String extension) {
                    return false;
                }

                public boolean isOverwrite() {
                    return replace;
                }

                public boolean isPropertyOverwrite() {
                    return replaceProperties;
                }
            }, new ContentImportListener(){

                public void onReorder(String orderedPath, String beforeSibbling) {
                    changes.add(Modification.onOrder(orderedPath, beforeSibbling));
                }

                public void onMove(String srcPath, String destPath) {
                    changes.add(Modification.onMoved(srcPath, destPath));
                }

                public void onModify(String srcPath) {
                    changes.add(Modification.onModified(srcPath));
                }

                public void onDelete(String srcPath) {
                    changes.add(Modification.onDeleted(srcPath));
                }

                public void onCreate(String srcPath) {
                    changes.add(Modification.onCreated(srcPath));
                }

                public void onCopy(String srcPath, String destPath) {
                    changes.add(Modification.onCopied(srcPath, destPath));
                }

                public void onCheckin(String srcPath) {
                    changes.add(Modification.onCheckin(srcPath));
                }

                public void onCheckout(String srcPath) {
                    changes.add(Modification.onCheckout(srcPath));
                }
            });
            if (changes.isEmpty()) return;
            Modification modification = changes.get(0);
            if (modification.getType() != ModificationType.CREATE) return;
            String importedPath = modification.getSource();
            response.setLocation(this.externalizePath(request, importedPath));
            response.setPath(importedPath);
            int lastSlashIndex = importedPath.lastIndexOf(47);
            if (lastSlashIndex == -1) return;
            String parentPath = importedPath.substring(0, lastSlashIndex);
            response.setParentLocation(this.externalizePath(request, parentPath));
            return;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

