/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.post.AbstractPostOperation;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.NodeNameGenerator;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.VersioningConfiguration;
import org.apache.sling.servlets.post.impl.helper.Chunk;
import org.apache.sling.servlets.post.impl.helper.DefaultNodeNameGenerator;
import org.apache.sling.servlets.post.impl.helper.RequestProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCreateOperation
extends AbstractPostOperation {
    private NodeNameGenerator defaultNodeNameGenerator = new DefaultNodeNameGenerator();
    private NodeNameGenerator[] extraNodeNameGenerators;
    private Pattern ignoredParameterNamePattern = null;

    protected AbstractCreateOperation() {
    }

    public void setDefaultNodeNameGenerator(NodeNameGenerator defaultNodeNameGenerator) {
        this.defaultNodeNameGenerator = defaultNodeNameGenerator;
    }

    public void setExtraNodeNameGenerators(NodeNameGenerator[] extraNodeNameGenerators) {
        this.extraNodeNameGenerators = extraNodeNameGenerators;
    }

    public void setIgnoredParameterNamePattern(Pattern ignoredParameterNamePattern) {
        this.ignoredParameterNamePattern = ignoredParameterNamePattern;
    }

    protected void processCreate(ResourceResolver resolver, Map<String, RequestProperty> reqProperties, PostResponse response, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException, RepositoryException {
        String path = response.getPath();
        if (resolver.getResource(path) == null) {
            this.deepGetOrCreateNode(resolver, path, reqProperties, changes, versioningConfiguration);
            response.setCreateRequest(true);
        } else {
            this.updateNodeType(resolver, path, reqProperties, changes, versioningConfiguration);
            this.updateMixins(resolver, path, reqProperties, changes, versioningConfiguration);
        }
    }

    protected void updateNodeType(ResourceResolver resolver, String path, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        Resource rsrc;
        ModifiableValueMap mvm;
        String nodeType = this.getPrimaryType(reqProperties, path);
        if (nodeType != null && (mvm = (ModifiableValueMap)(rsrc = resolver.getResource(path)).adaptTo(ModifiableValueMap.class)) != null) {
            boolean wasVersionable;
            Node node = (Node)rsrc.adaptTo(Node.class);
            boolean bl = wasVersionable = node == null ? false : this.isVersionable(node);
            if (node != null) {
                this.checkoutIfNecessary(node, changes, versioningConfiguration);
                node.setPrimaryType(nodeType);
            } else {
                mvm.put((Object)"jcr:primaryType", (Object)nodeType);
            }
            if (node != null && !wasVersionable && versioningConfiguration.isCheckinOnNewVersionableNode() && this.isVersionable(node)) {
                changes.add(Modification.onCheckout(path));
            }
        }
    }

    protected void updateMixins(ResourceResolver resolver, String path, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws RepositoryException {
        Resource rsrc;
        ModifiableValueMap mvm;
        String[] mixins = this.getMixinTypes(reqProperties, path);
        if (mixins != null && (mvm = (ModifiableValueMap)(rsrc = resolver.getResource(path)).adaptTo(ModifiableValueMap.class)) != null) {
            Node node = (Node)rsrc.adaptTo(Node.class);
            HashSet<String> newMixins = new HashSet<String>();
            newMixins.addAll(Arrays.asList(mixins));
            if (node != null) {
                this.checkoutIfNecessary(node, changes, versioningConfiguration);
                for (NodeType mixin : node.getMixinNodeTypes()) {
                    String mixinName = mixin.getName();
                    if (newMixins.remove(mixinName)) continue;
                    node.removeMixin(mixinName);
                }
                for (String mixin : newMixins) {
                    node.addMixin(mixin);
                    if (!mixin.equals("mix:versionable") || !versioningConfiguration.isCheckinOnNewVersionableNode()) continue;
                    changes.add(Modification.onCheckout(path));
                }
            } else {
                mvm.put((Object)"jcr:mixinTypes", (Object)mixins);
            }
        }
    }

    protected Map<String, RequestProperty> collectContent(SlingHttpServletRequest request, PostResponse response) {
        boolean requireItemPrefix = this.requireItemPathPrefix(request);
        LinkedHashMap<String, RequestProperty> reqProperties = new LinkedHashMap<String, RequestProperty>();
        for (Map.Entry e : request.getRequestParameterMap().entrySet()) {
            Chunk chunk;
            String sourcePath;
            RequestProperty prop;
            String paramName = (String)e.getKey();
            if (this.ignoreParameter(paramName) || requireItemPrefix && !this.hasItemPathPrefix(paramName)) continue;
            String propPath = this.toPropertyPath(paramName, response);
            if (propPath.endsWith("@TypeHint")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@TypeHint");
                RequestParameter[] rp = (RequestParameter[])e.getValue();
                if (rp.length <= 0) continue;
                prop.setTypeHintValue(rp[0].getString());
                continue;
            }
            if (propPath.endsWith("@DefaultValue")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@DefaultValue");
                prop.setDefaultValues((RequestParameter[])e.getValue());
                continue;
            }
            if (propPath.endsWith("@ValueFrom")) {
                String refName;
                RequestParameter[] refValues;
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@ValueFrom");
                if (((RequestParameter[])e.getValue()).length != 1 || (refValues = request.getRequestParameters(refName = ((RequestParameter[])e.getValue())[0].getString())) == null) continue;
                prop.setValues(refValues);
                continue;
            }
            if (propPath.endsWith("@Delete")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Delete");
                prop.setDelete(true);
                continue;
            }
            if (propPath.endsWith("@MoveFrom")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@MoveFrom");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                sourcePath = ((RequestParameter[])e.getValue())[0].getString();
                prop.setRepositorySource(sourcePath, true);
                continue;
            }
            if (propPath.endsWith("@CopyFrom")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@CopyFrom");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                sourcePath = ((RequestParameter[])e.getValue())[0].getString();
                prop.setRepositorySource(sourcePath, false);
                continue;
            }
            if (propPath.endsWith("@IgnoreBlanks")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@IgnoreBlanks");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                prop.setIgnoreBlanks(true);
                continue;
            }
            if (propPath.endsWith("@UseDefaultWhenMissing")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@UseDefaultWhenMissing");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                prop.setUseDefaultWhenMissing(true);
                continue;
            }
            if (propPath.endsWith("@Patch")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Patch");
                prop.setPatch(true);
                continue;
            }
            if (propPath.endsWith("@Offset")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Offset");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                chunk = prop.getChunk();
                if (chunk == null) {
                    chunk = new Chunk();
                }
                chunk.setOffsetValue(Long.parseLong(((RequestParameter[])e.getValue())[0].toString()));
                prop.setChunk(chunk);
                continue;
            }
            if (propPath.endsWith("@Completed")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Completed");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                chunk = prop.getChunk();
                if (chunk == null) {
                    chunk = new Chunk();
                }
                chunk.setCompleted(Boolean.parseBoolean(((RequestParameter[])e.getValue())[0].toString()));
                prop.setChunk(chunk);
                continue;
            }
            if (propPath.endsWith("@Length")) {
                prop = this.getOrCreateRequestProperty(reqProperties, propPath, "@Length");
                if (((RequestParameter[])e.getValue()).length != 1) continue;
                chunk = prop.getChunk();
                if (chunk == null) {
                    chunk = new Chunk();
                }
                chunk.setLength(Long.parseLong(((RequestParameter[])e.getValue())[0].toString()));
                prop.setChunk(chunk);
                continue;
            }
            prop = this.getOrCreateRequestProperty(reqProperties, propPath, null);
            prop.setValues((RequestParameter[])e.getValue());
        }
        return reqProperties;
    }

    private boolean ignoreParameter(String paramName) {
        if (paramName.startsWith(":")) {
            return true;
        }
        if (paramName.equals("_charset_")) {
            return true;
        }
        return this.ignoredParameterNamePattern != null && this.ignoredParameterNamePattern.matcher(paramName).matches();
    }

    private String toPropertyPath(String paramName, PostResponse response) {
        if (!paramName.startsWith("/")) {
            paramName = ResourceUtil.normalize((String)(response.getPath() + '/' + paramName));
        }
        return paramName;
    }

    private RequestProperty getOrCreateRequestProperty(Map<String, RequestProperty> props, String paramName, String suffix) {
        RequestProperty prop;
        if (suffix != null && paramName.endsWith(suffix)) {
            paramName = paramName.substring(0, paramName.length() - suffix.length());
        }
        if ((prop = props.get(paramName)) == null) {
            prop = new RequestProperty(paramName);
            props.put(paramName, prop);
        }
        return prop;
    }

    protected Resource deepGetOrCreateNode(ResourceResolver resolver, String path, Map<String, RequestProperty> reqProperties, List<Modification> changes, VersioningConfiguration versioningConfiguration) throws PersistenceException, RepositoryException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deep-creating resource '{}'", (Object)path);
        }
        if (path == null || !path.startsWith("/")) {
            throw new IllegalArgumentException("path must be an absolute path.");
        }
        String startingResourcePath = path;
        Resource startingResource = null;
        while (startingResource == null) {
            if (startingResourcePath.equals("/")) {
                startingResource = resolver.getResource("/");
                if (startingResource != null) continue;
                throw new PersistenceException("Access denied for root resource, resource can't be created: " + path);
            }
            if (resolver.getResource(startingResourcePath) != null) {
                startingResource = resolver.getResource(startingResourcePath);
                this.updateNodeType(resolver, startingResourcePath, reqProperties, changes, versioningConfiguration);
                this.updateMixins(resolver, startingResourcePath, reqProperties, changes, versioningConfiguration);
                continue;
            }
            int pos = startingResourcePath.lastIndexOf(47);
            if (pos > 0) {
                startingResourcePath = startingResourcePath.substring(0, pos);
                continue;
            }
            startingResourcePath = "/";
        }
        if (startingResourcePath.length() == path.length()) {
            return startingResource;
        }
        int from = startingResourcePath.length() == 1 ? 1 : startingResourcePath.length() + 1;
        Resource resource = startingResource;
        while (from > 0) {
            String name;
            int to = path.indexOf(47, from);
            String string = name = to < 0 ? path.substring(from) : path.substring(from, to);
            if (resource.getChild(name) != null) {
                resource = resource.getChild(name);
                this.updateNodeType(resolver, resource.getPath(), reqProperties, changes, versioningConfiguration);
                this.updateMixins(resolver, resource.getPath(), reqProperties, changes, versioningConfiguration);
            } else {
                String tmpPath = to < 0 ? path : path.substring(0, to);
                String nodeType = this.getPrimaryType(reqProperties, tmpPath);
                Node node = (Node)resource.adaptTo(Node.class);
                if (node != null) {
                    this.checkoutIfNecessary(node, changes, versioningConfiguration);
                }
                try {
                    String[] mixinTypes;
                    HashMap<String, Object> props = new HashMap<String, Object>();
                    if (nodeType != null) {
                        props.put("jcr:primaryType", nodeType);
                    }
                    if ((mixinTypes = this.getMixinTypes(reqProperties, tmpPath)) != null) {
                        props.put("jcr:mixinTypes", mixinTypes);
                    }
                    resource = resolver.create(resource, name, props);
                }
                catch (PersistenceException e) {
                    this.log.error("Unable to create resource named " + name + " in " + resource.getPath());
                    throw e;
                }
                changes.add(Modification.onCreated(resource.getPath()));
            }
            from = to + 1;
        }
        return resource;
    }

    private String getPrimaryType(Map<String, RequestProperty> reqProperties, String path) {
        RequestProperty prop = reqProperties.get(path + "/jcr:primaryType");
        return prop == null ? null : prop.getStringValues()[0];
    }

    private String[] getMixinTypes(Map<String, RequestProperty> reqProperties, String path) {
        RequestProperty prop = reqProperties.get(path + "/jcr:mixinTypes");
        return prop == null || !prop.hasValues() ? null : prop.getStringValues();
    }

    protected String generateName(SlingHttpServletRequest request, String basePath) throws RepositoryException {
        RequestParameterMap parameters = request.getRequestParameterMap();
        RequestParameter specialParam = parameters.getValue(":name");
        if (specialParam != null && specialParam.getString() != null && specialParam.getString().length() > 0) {
            basePath = basePath + "/" + specialParam.getString();
            Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
            String jcrPath = this.removeAndValidateWorkspace(basePath, session);
            if (request.getResourceResolver().getResource(jcrPath) != null) {
                throw new RepositoryException("Collision in node names for path=" + basePath);
            }
            return basePath;
        }
        boolean requirePrefix = this.requireItemPathPrefix(request);
        String generatedName = null;
        if (this.extraNodeNameGenerators != null) {
            NodeNameGenerator generator;
            NodeNameGenerator[] arr$ = this.extraNodeNameGenerators;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (generatedName = (generator = arr$[i$]).getNodeName(request, basePath, requirePrefix, this.defaultNodeNameGenerator)) == null; ++i$) {
            }
        }
        if (generatedName == null) {
            generatedName = this.defaultNodeNameGenerator.getNodeName(request, basePath, requirePrefix, this.defaultNodeNameGenerator);
        }
        basePath = basePath + "/" + generatedName;
        basePath = this.ensureUniquePath(request, basePath);
        return basePath;
    }

    private String ensureUniquePath(SlingHttpServletRequest request, String basePath) throws RepositoryException {
        String jcrPath;
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        ResourceResolver resolver = request.getResourceResolver();
        if (resolver.getResource(jcrPath = this.removeAndValidateWorkspace(basePath, session)) != null) {
            for (int idx = 0; idx < 1000; ++idx) {
                String newPath = jcrPath + "_" + idx;
                if (resolver.getResource(newPath) != null) continue;
                basePath = basePath + "_" + idx;
                jcrPath = newPath;
                break;
            }
            if (resolver.getResource(jcrPath) != null) {
                throw new RepositoryException("Collision in generated node names for path=" + basePath);
            }
        }
        return basePath;
    }
}

