/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlets.post.impl.operations;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.servlets.post.AbstractPostOperation;
import org.apache.sling.servlets.post.Modification;
import org.apache.sling.servlets.post.PostResponse;
import org.apache.sling.servlets.post.VersioningConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCopyMoveOperation
extends AbstractPostOperation {
    AbstractCopyMoveOperation() {
    }

    @Override
    protected final void doRun(SlingHttpServletRequest request, PostResponse response, List<Modification> changes) throws RepositoryException {
        String dstParent;
        Session session = (Session)request.getResourceResolver().adaptTo(Session.class);
        VersioningConfiguration versioningConfiguration = this.getVersioningConfiguration(request);
        Resource resource = request.getResource();
        String source = resource.getPath();
        String dest = request.getParameter(":dest");
        if (dest == null || dest.length() == 0) {
            throw new IllegalArgumentException("Unable to process " + this.getOperationName() + ". Missing destination");
        }
        boolean trailingSlash = dest.endsWith("/");
        if (!dest.startsWith("/")) {
            dest = ResourceUtil.getParent((String)source) + "/" + dest;
        }
        dest = ResourceUtil.normalize((String)dest);
        dest = this.removeAndValidateWorkspace(dest, session);
        String string = dstParent = trailingSlash ? dest : ResourceUtil.getParent((String)dest);
        if (!trailingSlash && session.itemExists(dest)) {
            String replaceString = request.getParameter(":replace");
            boolean isReplace = "true".equalsIgnoreCase(replaceString);
            if (!isReplace) {
                response.setStatus(412, "Cannot " + this.getOperationName() + " " + resource + " to " + dest + ": destination exists");
                return;
            }
            this.checkoutIfNecessary(session.getItem(dest).getParent(), changes, versioningConfiguration);
        } else {
            if (!dstParent.equals("")) {
                if (session.itemExists(dstParent)) {
                    this.checkoutIfNecessary((Node)session.getItem(dstParent), changes, versioningConfiguration);
                } else {
                    response.setStatus(412, "Cannot " + this.getOperationName() + " " + resource + " to " + dest + ": parent of destination does not exist");
                    return;
                }
            }
            response.setCreateRequest(true);
        }
        Iterator<Resource> resources = this.getApplyToResources(request);
        Item destItem = null;
        if (resources == null) {
            Item item = (Item)resource.adaptTo(Item.class);
            if (item == null) {
                response.setStatus(404, "Missing source " + resource + " for " + this.getOperationName());
                return;
            }
            String dstName = trailingSlash ? null : ResourceUtil.getName((String)dest);
            destItem = this.execute(changes, item, dstParent, dstName, versioningConfiguration);
        } else {
            if (!trailingSlash) {
                throw new IllegalArgumentException("Applying " + this.getOperationName() + " to multiple resources requires a trailing slash on the destination");
            }
            response.setCreateRequest(false);
            while (resources.hasNext()) {
                Resource applyTo = resources.next();
                Item item = (Item)applyTo.adaptTo(Item.class);
                if (item == null) continue;
                this.execute(changes, item, dstParent, null, versioningConfiguration);
            }
            destItem = session.getItem(dest);
        }
        this.orderNode(request, destItem, changes);
    }

    protected abstract String getOperationName();

    protected abstract Item execute(List<Modification> var1, Item var2, String var3, String var4, VersioningConfiguration var5) throws RepositoryException;
}

