/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.servlethelpers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.http.Part;

public class ByteArrayPart
implements Part {
    private final byte[] content;
    private final String name;

    public static Builder builder() {
        return new Builder();
    }

    private ByteArrayPart(byte[] content, String name) {
        if (content == null) {
            throw new IllegalArgumentException("content may not be null");
        }
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name may not be null or empty");
        }
        this.content = content;
        this.name = name;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public String getContentType() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getSubmittedFileName() {
        return this.getName();
    }

    public long getSize() {
        return this.content.length;
    }

    public void write(String fileName) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void delete() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String getHeader(String name) {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getHeaders(String name) {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getHeaderNames() {
        throw new UnsupportedOperationException();
    }

    public static class Builder {
        private byte[] content;
        private String name;

        public Builder withContent(byte[] content) {
            this.content = content;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public ByteArrayPart build() {
            return new ByteArrayPart(this.content, this.name);
        }
    }
}

