/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.path.Path;
import org.apache.sling.api.resource.path.PathSet;
import org.apache.sling.api.resource.runtime.dto.AuthType;
import org.apache.sling.api.resource.runtime.dto.FailureReason;
import org.apache.sling.api.resource.runtime.dto.ResourceProviderDTO;
import org.apache.sling.api.resource.runtime.dto.ResourceProviderFailureDTO;
import org.apache.sling.api.resource.runtime.dto.RuntimeDTO;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderHandler;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderInfo;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderStorage;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderStorageProvider;
import org.apache.sling.spi.resource.provider.ObservationReporter;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceProviderTracker
implements ResourceProviderStorageProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Map<ServiceReference<ResourceProvider>, ResourceProviderInfo> infos = new ConcurrentHashMap<ServiceReference<ResourceProvider>, ResourceProviderInfo>();
    private volatile BundleContext bundleContext;
    private volatile ServiceTracker<ResourceProvider, ServiceReference<ResourceProvider>> tracker;
    private final Map<String, List<ResourceProviderHandler>> handlers = new HashMap<String, List<ResourceProviderHandler>>();
    private final Map<ResourceProviderInfo, FailureReason> invalidProviders = new ConcurrentHashMap<ResourceProviderInfo, FailureReason>();
    private volatile EventAdmin eventAdmin;
    private volatile ObservationReporterGenerator reporterGenerator;
    private volatile ResourceProviderStorage storage;
    private volatile ObservationReporter providerReporter;
    private volatile ChangeListener listener;

    public void activate(BundleContext bundleContext, EventAdmin eventAdmin, ChangeListener listener) {
        this.bundleContext = bundleContext;
        this.eventAdmin = eventAdmin;
        this.listener = listener;
        this.tracker = new ServiceTracker(bundleContext, ResourceProvider.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ResourceProvider, ServiceReference<ResourceProvider>>(){

            public void removedService(ServiceReference<ResourceProvider> reference, ServiceReference<ResourceProvider> ref) {
                ResourceProviderInfo info = (ResourceProviderInfo)ResourceProviderTracker.this.infos.remove(ref);
                if (info != null) {
                    Object pid = ref.getProperty("service.pid");
                    if (pid != null && !(pid instanceof String)) {
                        pid = null;
                    }
                    ResourceProviderTracker.this.unregister(info, (String)pid);
                }
            }

            public void modifiedService(ServiceReference<ResourceProvider> reference, ServiceReference<ResourceProvider> service) {
                this.removedService(reference, service);
                this.addingService(reference);
            }

            public ServiceReference<ResourceProvider> addingService(ServiceReference<ResourceProvider> reference) {
                ResourceProviderInfo info = new ResourceProviderInfo(reference);
                ResourceProviderTracker.this.infos.put(reference, info);
                ResourceProviderTracker.this.register(info);
                return reference;
            }
        });
        this.tracker.open();
    }

    public void deactivate() {
        this.listener = null;
        this.eventAdmin = null;
        this.providerReporter = null;
        if (this.tracker != null) {
            this.tracker.close();
            this.tracker = null;
        }
        this.infos.clear();
        this.handlers.clear();
        this.invalidProviders.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObservationReporterGenerator(ObservationReporterGenerator generator) {
        this.providerReporter = generator.createProviderReporter();
        Map<String, List<ResourceProviderHandler>> map = this.handlers;
        synchronized (map) {
            this.reporterGenerator = generator;
            for (List<ResourceProviderHandler> list : this.handlers.values()) {
                ResourceProviderHandler h;
                if (list.isEmpty() || (h = list.get(0)) == null) continue;
                this.updateProviderContext(h);
                h.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(ResourceProviderInfo info) {
        if (info.isValid()) {
            List<ResourceProviderHandler> matchingHandlers;
            this.logger.debug("Registering new resource provider {}", (Object)info);
            ArrayList<ProviderEvent> events = new ArrayList<ProviderEvent>();
            boolean providerAdded = false;
            ResourceProviderHandler deactivateHandler = null;
            ResourceProviderHandler activate = null;
            Map<String, List<ResourceProviderHandler>> map = this.handlers;
            synchronized (map) {
                matchingHandlers = this.handlers.get(info.getPath());
                if (matchingHandlers == null) {
                    matchingHandlers = new ArrayList<ResourceProviderHandler>();
                    this.handlers.put(info.getPath(), matchingHandlers);
                }
                ResourceProviderHandler handler = new ResourceProviderHandler(this.bundleContext, info);
                matchingHandlers.add(handler);
                Collections.sort(matchingHandlers);
                if (matchingHandlers.get(0) == handler) {
                    activate = handler;
                }
            }
            if (activate != null) {
                if (this.activate(activate)) {
                    providerAdded = true;
                    events.add(new ProviderEvent(true, info));
                    map = this.handlers;
                    synchronized (map) {
                        this.storage = null;
                        matchingHandlers = this.handlers.get(info.getPath());
                        if (matchingHandlers != null && matchingHandlers.size() > 1) {
                            deactivateHandler = matchingHandlers.get(1);
                        }
                    }
                }
                map = this.handlers;
                synchronized (map) {
                    matchingHandlers = this.handlers.get(info.getPath());
                    if (matchingHandlers != null && !matchingHandlers.isEmpty() && matchingHandlers.remove(activate)) {
                        this.storage = null;
                        if (matchingHandlers.isEmpty()) {
                            this.handlers.remove(info.getPath());
                        }
                    }
                }
            }
            ChangeListener cl = this.listener;
            if (providerAdded && cl != null) {
                cl.providerAdded();
            }
            if (deactivateHandler != null) {
                ResourceProviderInfo handlerInfo = deactivateHandler.getInfo();
                if (cl != null) {
                    Object pid = handlerInfo.getServiceReference().getProperty("service.pid");
                    if (pid != null && !(pid instanceof String)) {
                        pid = null;
                    }
                    cl.providerRemoved(handlerInfo.getName(), (String)pid, handlerInfo.getAuthType() != AuthType.no, deactivateHandler.isUsed());
                }
                this.deactivate(deactivateHandler);
                Map<String, List<ResourceProviderHandler>> map2 = this.handlers;
                synchronized (map2) {
                    this.storage = null;
                }
                events.add(new ProviderEvent(false, handlerInfo));
            }
            this.postEvents(events);
        } else {
            this.logger.warn("Ignoring invalid resource provider {}", (Object)info);
            this.invalidProviders.put(info, FailureReason.invalid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregister(ResourceProviderInfo info, String pid) {
        boolean isInvalid;
        Map<ResourceProviderInfo, FailureReason> map = this.invalidProviders;
        synchronized (map) {
            isInvalid = this.invalidProviders.remove(info) != null;
        }
        if (!isInvalid) {
            this.logger.debug("Unregistering resource provider {}", (Object)info);
            ResourceProviderHandler deactivateHandler = null;
            Map<String, List<ResourceProviderHandler>> map2 = this.handlers;
            synchronized (map2) {
                List<ResourceProviderHandler> matchingHandlers = this.handlers.get(info.getPath());
                if (matchingHandlers != null) {
                    Iterator<ResourceProviderHandler> it = matchingHandlers.iterator();
                    boolean first = true;
                    while (it.hasNext()) {
                        ResourceProviderHandler h = it.next();
                        if (h.getInfo() == info) {
                            it.remove();
                            if (first) {
                                deactivateHandler = h;
                            } else {
                                h.dispose();
                            }
                            if (matchingHandlers.isEmpty()) {
                                this.handlers.remove(info.getPath());
                            }
                            this.storage = null;
                            break;
                        }
                        first = false;
                    }
                }
            }
            if (deactivateHandler != null) {
                ArrayList<ProviderEvent> events = new ArrayList<ProviderEvent>();
                ChangeListener cl = this.listener;
                if (cl != null) {
                    cl.providerRemoved(info.getName(), pid, info.getAuthType() != AuthType.no, deactivateHandler.isUsed());
                }
                this.deactivate(deactivateHandler);
                deactivateHandler.dispose();
                ResourceProviderHandler addingProvider = null;
                Map<String, List<ResourceProviderHandler>> first = this.handlers;
                synchronized (first) {
                    List<ResourceProviderHandler> matchingHandlers = this.handlers.get(info.getPath());
                    if (matchingHandlers != null) {
                        if (matchingHandlers.isEmpty()) {
                            this.handlers.remove(info.getPath());
                        } else {
                            addingProvider = matchingHandlers.get(0);
                        }
                    }
                }
                boolean providerAdded = false;
                while (addingProvider != null) {
                    Map<String, List<ResourceProviderHandler>> map3;
                    if (this.activate(addingProvider)) {
                        events.add(new ProviderEvent(true, addingProvider.getInfo()));
                        providerAdded = true;
                        addingProvider = null;
                        map3 = this.handlers;
                        synchronized (map3) {
                            this.storage = null;
                            continue;
                        }
                    }
                    map3 = this.handlers;
                    synchronized (map3) {
                        List<ResourceProviderHandler> matchingHandlers = this.handlers.get(info.getPath());
                        if (matchingHandlers != null && !matchingHandlers.isEmpty() && matchingHandlers.get(0) == addingProvider) {
                            this.storage = null;
                            matchingHandlers.remove(0);
                            addingProvider.dispose();
                            if (matchingHandlers.isEmpty()) {
                                this.handlers.remove(info.getPath());
                                addingProvider = null;
                            } else {
                                addingProvider = matchingHandlers.get(0);
                            }
                        }
                    }
                }
                if (providerAdded && cl != null && cl != null) {
                    cl.providerAdded();
                }
                events.add(new ProviderEvent(false, info));
                this.postEvents(events);
            }
        } else {
            this.logger.debug("Unregistering invalid resource provider {}", (Object)info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean activate(ResourceProviderHandler handler) {
        Map<String, List<ResourceProviderHandler>> map = this.handlers;
        synchronized (map) {
            this.updateProviderContext(handler);
        }
        if (!handler.activate()) {
            this.logger.warn("Activating resource provider {} failed", (Object)handler.getInfo());
            this.invalidProviders.put(handler.getInfo(), FailureReason.service_not_gettable);
            return false;
        }
        this.logger.debug("Activated resource provider {}", (Object)handler.getInfo());
        return true;
    }

    private void deactivate(ResourceProviderHandler handler) {
        handler.deactivate();
        this.logger.debug("Deactivated resource provider {}", (Object)handler.getInfo());
    }

    private void postOSGiEvent(ProviderEvent event) {
        EventAdmin ea = this.eventAdmin;
        if (ea != null) {
            Hashtable<String, Object> eventProps = new Hashtable<String, Object>();
            ((Dictionary)eventProps).put("path", event.path);
            if (event.pid != null) {
                ((Dictionary)eventProps).put("service.pid", event.pid);
            }
            ea.postEvent(new Event(event.isAdd ? "org/apache/sling/api/resource/ResourceProvider/ADDED" : "org/apache/sling/api/resource/ResourceProvider/REMOVED", eventProps));
        }
    }

    private void postResourceProviderChange(ProviderEvent event) {
        ObservationReporter or = this.providerReporter;
        if (or != null) {
            ResourceChange change = new ResourceChange(event.isAdd ? ResourceChange.ChangeType.PROVIDER_ADDED : ResourceChange.ChangeType.PROVIDER_REMOVED, event.path, false);
            or.reportChanges(Collections.singletonList(change), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fill(RuntimeDTO dto) {
        ArrayList<ResourceProviderDTO> dtos = new ArrayList<ResourceProviderDTO>();
        ArrayList<ResourceProviderFailureDTO> failures = new ArrayList<ResourceProviderFailureDTO>();
        Map<Object, List<ResourceProviderHandler>> map = this.handlers;
        synchronized (map) {
            for (List<ResourceProviderHandler> list : this.handlers.values()) {
                boolean isFirst = true;
                for (ResourceProviderHandler h : list) {
                    ResourceProviderDTO d;
                    if (isFirst) {
                        d = new ResourceProviderDTO();
                        dtos.add(d);
                        isFirst = false;
                    } else {
                        d = new ResourceProviderFailureDTO();
                        ((ResourceProviderFailureDTO)d).reason = FailureReason.shadowed;
                        failures.add((ResourceProviderFailureDTO)d);
                    }
                    this.fill(d, h);
                }
            }
        }
        map = this.invalidProviders;
        synchronized (map) {
            for (Map.Entry entry : this.invalidProviders.entrySet()) {
                ResourceProviderFailureDTO d = new ResourceProviderFailureDTO();
                this.fill((ResourceProviderDTO)d, (ResourceProviderInfo)entry.getKey());
                d.reason = (FailureReason)entry.getValue();
                failures.add(d);
            }
        }
        dto.providers = dtos.toArray(new ResourceProviderDTO[dtos.size()]);
        dto.failedProviders = failures.toArray(new ResourceProviderFailureDTO[failures.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceProviderStorage getResourceProviderStorage() {
        ResourceProviderStorage result = this.storage;
        if (result == null) {
            Map<String, List<ResourceProviderHandler>> map = this.handlers;
            synchronized (map) {
                if (this.storage == null) {
                    ArrayList<ResourceProviderHandler> handlerList = new ArrayList<ResourceProviderHandler>();
                    for (List<ResourceProviderHandler> list : this.handlers.values()) {
                        ResourceProviderHandler h;
                        if (list.isEmpty() || (h = list.get(0)) == null || h.getResourceProvider() == null) continue;
                        handlerList.add(h);
                    }
                    this.storage = new ResourceProviderStorage(handlerList);
                }
                result = this.storage;
            }
        }
        return result;
    }

    private void fill(ResourceProviderDTO d, ResourceProviderInfo info) {
        d.adaptable = info.isAdaptable();
        d.attributable = info.isAttributable();
        d.authType = info.getAuthType();
        d.modifiable = info.isModifiable();
        d.name = info.getName();
        d.path = info.getPath();
        d.refreshable = info.isRefreshable();
        d.serviceId = (Long)info.getServiceReference().getProperty("service.id");
        d.supportsQueryLanguage = false;
        d.useResourceAccessSecurity = info.getUseResourceAccessSecurity();
    }

    private void fill(ResourceProviderDTO d, ResourceProviderHandler handler) {
        this.fill(d, handler.getInfo());
        ResourceProvider<Object> provider = handler.getResourceProvider();
        if (provider != null) {
            d.supportsQueryLanguage = provider.getQueryLanguageProvider() != null;
        }
    }

    private void updateProviderContext(ResourceProviderHandler handler) {
        HashSet<String> excludedPaths = new HashSet<String>();
        Path handlerPath = new Path(handler.getPath());
        for (String otherPath : this.handlers.keySet()) {
            if (handler.getPath().equals(otherPath) || !handlerPath.matches(otherPath)) continue;
            excludedPaths.add(otherPath);
        }
        PathSet excludedPathSet = PathSet.fromStringCollection(excludedPaths);
        handler.getProviderContext().update(this.reporterGenerator.create(handlerPath, excludedPathSet), excludedPathSet);
    }

    private void postEvents(final List<ProviderEvent> events) {
        if (events.isEmpty()) {
            return;
        }
        if (this.listener == null && this.providerReporter == null) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                for (ProviderEvent e : events) {
                    ResourceProviderTracker.this.postOSGiEvent(e);
                    ResourceProviderTracker.this.postResourceProviderChange(e);
                }
            }
        });
        t.setName("Apache Sling Resource Provider Change Notifier");
        t.setDaemon(true);
        t.start();
    }

    private static final class ProviderEvent {
        public final boolean isAdd;
        public final Object pid;
        public final String path;

        public ProviderEvent(boolean isAdd, ResourceProviderInfo info) {
            this.isAdd = isAdd;
            this.path = info.getPath();
            Object pid = info.getServiceReference().getProperty("service.pid");
            if (pid == null) {
                pid = info.getServiceReference().getProperty("original.service.pid");
            }
            this.pid = pid;
        }
    }

    public static interface ChangeListener {
        public void providerAdded();

        public void providerRemoved(String var1, String var2, boolean var3, boolean var4);
    }

    public static interface ObservationReporterGenerator {
        public ObservationReporter create(Path var1, PathSet var2);

        public ObservationReporter createProviderReporter();
    }
}

