/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl.observation;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.api.resource.path.PathSet;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.osgi.framework.ServiceReference;

public class ResourceChangeListenerInfo {
    private static final Set<ResourceChange.ChangeType> DEFAULT_CHANGE_RESOURCE_TYPES = EnumSet.of(ResourceChange.ChangeType.ADDED, ResourceChange.ChangeType.REMOVED, ResourceChange.ChangeType.CHANGED);
    private static final Set<ResourceChange.ChangeType> DEFAULT_CHANGE_PROVIDER_TYPES = EnumSet.of(ResourceChange.ChangeType.PROVIDER_ADDED, ResourceChange.ChangeType.PROVIDER_REMOVED);
    private final PathSet paths;
    private final Set<ResourceChange.ChangeType> resourceChangeTypes;
    private final Set<ResourceChange.ChangeType> providerChangeTypes;
    private final boolean valid;
    private volatile boolean external = false;
    private volatile ResourceChangeListener listener;

    public ResourceChangeListenerInfo(ServiceReference ref, String[] searchPaths) {
        boolean configValid = true;
        HashSet<String> pathsSet = new HashSet<String>();
        String[] paths = PropertiesUtil.toStringArray((Object)ref.getProperty("resource.paths"), null);
        if (paths != null) {
            for (String p : paths) {
                if (p.isEmpty()) {
                    configValid = false;
                    continue;
                }
                if (p.startsWith("/")) {
                    pathsSet.add(p);
                    continue;
                }
                for (String sp : searchPaths) {
                    if (p.equals(".")) {
                        pathsSet.add(sp);
                        continue;
                    }
                    pathsSet.add(sp + p);
                }
            }
        }
        if (pathsSet.isEmpty()) {
            configValid = false;
        } else {
            Iterator iter = pathsSet.iterator();
            while (iter.hasNext()) {
                String path = (String)iter.next();
                boolean remove = false;
                for (String p : pathsSet) {
                    if (p.length() <= path.length() || !path.startsWith(p + "/")) continue;
                    remove = true;
                    break;
                }
                if (!remove) continue;
                iter.remove();
            }
        }
        this.paths = PathSet.fromStringCollection(pathsSet);
        if (ref.getProperty("resource.change.types") != null) {
            HashSet<ResourceChange.ChangeType> rts = new HashSet<ResourceChange.ChangeType>();
            HashSet<ResourceChange.ChangeType> pts = new HashSet<ResourceChange.ChangeType>();
            for (String changeName : PropertiesUtil.toStringArray((Object)ref.getProperty("resource.change.types"))) {
                try {
                    ResourceChange.ChangeType ct = ResourceChange.ChangeType.valueOf((String)changeName);
                    if (ct.ordinal() < ResourceChange.ChangeType.PROVIDER_ADDED.ordinal()) {
                        rts.add(ct);
                        continue;
                    }
                    pts.add(ct);
                }
                catch (IllegalArgumentException iae) {
                    configValid = false;
                }
            }
            this.resourceChangeTypes = rts.isEmpty() ? Collections.emptySet() : (rts.size() == 3 ? DEFAULT_CHANGE_RESOURCE_TYPES : Collections.unmodifiableSet(rts));
            this.providerChangeTypes = pts.isEmpty() ? Collections.emptySet() : (pts.size() == 2 ? DEFAULT_CHANGE_PROVIDER_TYPES : Collections.unmodifiableSet(pts));
        } else {
            this.resourceChangeTypes = DEFAULT_CHANGE_RESOURCE_TYPES;
            this.providerChangeTypes = DEFAULT_CHANGE_PROVIDER_TYPES;
        }
        this.valid = configValid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public Set<ResourceChange.ChangeType> getResourceChangeTypes() {
        return this.resourceChangeTypes;
    }

    public Set<ResourceChange.ChangeType> getProviderChangeTypes() {
        return this.providerChangeTypes;
    }

    public PathSet getPaths() {
        return this.paths;
    }

    public boolean isExternal() {
        return this.external;
    }

    public ResourceChangeListener getListener() {
        return this.listener;
    }

    public void setListener(ResourceChangeListener listener) {
        this.listener = listener;
        this.external = listener instanceof ExternalResourceChangeListener;
    }
}

