/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourceresolver.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.BidiMap;
import org.apache.commons.collections.bidimap.TreeBidiMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.References;
import org.apache.sling.api.resource.ResourceDecorator;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.runtime.RuntimeService;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourceresolver.impl.CommonResourceResolverFactoryImpl;
import org.apache.sling.resourceresolver.impl.FactoryPreconditions;
import org.apache.sling.resourceresolver.impl.ResourceAccessSecurityTracker;
import org.apache.sling.resourceresolver.impl.ResourceResolverFactoryImpl;
import org.apache.sling.resourceresolver.impl.helper.ResourceDecoratorTracker;
import org.apache.sling.resourceresolver.impl.mapping.Mapping;
import org.apache.sling.resourceresolver.impl.observation.ResourceChangeListenerWhiteboard;
import org.apache.sling.resourceresolver.impl.providers.ResourceProviderTracker;
import org.apache.sling.resourceresolver.impl.providers.RuntimeServiceImpl;
import org.apache.sling.serviceusermapping.ServiceUserMapper;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.event.EventAdmin;

@Component(name="org.apache.sling.jcr.resource.internal.JcrResourceResolverFactoryImpl", label="Apache Sling Resource Resolver Factory", description="Configures the Resource Resolver for request URL and resource path rewriting.", specVersion="1.1", metatype=true)
@Properties(value={@Property(name="service.description", value={"Apache Sling Resource Resolver Factory"}), @Property(name="service.vendor", value={"The Apache Software Foundation"})})
@References(value={@Reference(name="ResourceDecorator", referenceInterface=ResourceDecorator.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)})
public class ResourceResolverFactoryActivator
implements Runnable {
    @Property(value={"/apps", "/libs"}, label="Resource Search Path", description="The list of absolute path prefixes applied to find resources whose path is just specified with a relative path. The default value is [ \"/apps\", \"/libs\" ]. If an empty path is specified a single entry path of [ \"/\" ] is assumed.")
    public static final String PROP_PATH = "resource.resolver.searchpath";
    @Property(boolValue={true}, label="Namespace Mangling", description="Defines whether namespace prefixes of resource names inside the path (e.g. \"jcr:\" in \"/home/path/jcr:content\") are mangled or not. Mangling means that any namespace prefix contained in the path is replaced as per the generic substitution pattern \"/([^:]+):/_$1_/\" when calling the \"map\" method of the resource resolver. Likewise the \"resolve\" methods will unmangle such namespace prefixes according to the substituation pattern \"/_([^_]+)_/$1:/\". This feature is provided since there may be systems out there in the wild which cannot cope with URLs containing colons, even though they are perfectly valid characters in the path part of URI references with a scheme. The default value of this property if no configuration is provided is \"true\".")
    private static final String PROP_MANGLE_NAMESPACES = "resource.resolver.manglenamespaces";
    @Property(boolValue={true}, label="Allow Direct Mapping", description="Whether to add a direct URL mapping to the front of the mapping list.")
    private static final String PROP_ALLOW_DIRECT = "resource.resolver.allowDirect";
    @Property(unbounded=PropertyUnbounded.ARRAY, value={"org.apache.sling.jcr.resource.internal.helper.jcr.JcrResourceProviderFactory"}, label="Required Providers", description="A resource resolver factory is only available (registered) if all resource providers mentioned in this configuration are available. Each entry is either a service PID or a filter expression.  Invalid filters are ignored.")
    private static final String PROP_REQUIRED_PROVIDERS = "resource.resolver.required.providers";
    @Property(value={"/:/"}, unbounded=PropertyUnbounded.ARRAY, label="Virtual URLs", description="List of virtual URLs and there mappings to real URLs. Format is <externalURL>:<internalURL>. Mappings are applied on the complete request URL only.")
    private static final String PROP_VIRTUAL = "resource.resolver.virtual";
    @Property(value={"/:/", "/content/:/", "/system/docroot/:/"}, label="URL Mappings", description="List of mappings to apply to paths. Incoming mappings are applied to request paths to map to resource paths, outgoing mappings are applied to map resource paths to paths used on subsequent requests. Form is <internalPathPrefix><op><externalPathPrefix> where <op> is \">\" for incoming mappings, \"<\" for outgoing mappings and \":\" for mappings applied in both directions. Mappings are applied in configuration order by comparing and replacing URL prefixes. Note: The use of \"-\" as the <op> value indicating a mapping in both directions is deprecated.")
    private static final String PROP_MAPPING = "resource.resolver.mapping";
    @Property(value={"/etc/map"}, label="Mapping Location", description="The path to the root of the configuration to setup and configure the ResourceResolver mapping. The default value is /etc/map.")
    private static final String PROP_MAP_LOCATION = "resource.resolver.map.location";
    @Property(intValue={302}, label="Default Vanity Path Redirect Status", description="The default status code used when a sling:vanityPath is configured to redirect and does not have a specific status code associated with it (via a sling:redirectStatus property)")
    private static final String PROP_DEFAULT_VANITY_PATH_REDIRECT_STATUS = "resource.resolver.default.vanity.redirect.status";
    private static final boolean DEFAULT_ENABLE_VANITY_PATH = true;
    @Property(boolValue={true}, label="Enable Vanity Paths", description="This flag controls whether all resources with a sling:vanityPath property are processed and added to the mappoing table.")
    private static final String PROP_ENABLE_VANITY_PATH = "resource.resolver.enable.vanitypath";
    private static final long DEFAULT_MAX_CACHED_VANITY_PATHS = -1L;
    @Property(longValue={-1L}, label="Maximum number of cached vanity path entries", description="The maximum number of cached vanity path entries. Default is -1 (no limit)")
    private static final String PROP_MAX_CACHED_VANITY_PATHS = "resource.resolver.vanitypath.maxEntries";
    private static final boolean DEFAULT_MAX_CACHED_VANITY_PATHS_STARTUP = true;
    @Property(boolValue={true}, label="Limit the maximum number of cached vanity path entries only at startup", description="Limit the maximum number of cached vanity path entries only at startup. Default is true")
    private static final String PROP_MAX_CACHED_VANITY_PATHS_STARTUP = "resource.resolver.vanitypath.maxEntries.startup";
    private static final int DEFAULT_VANITY_BLOOM_FILTER_MAX_BYTES = 1024000;
    @Property(longValue={1024000L}, label="Maximum number of vanity bloom filter bytes", description="The maximum number of vanity bloom filter bytes. Changing this value is subject to vanity bloom filter rebuild")
    private static final String PROP_VANITY_BLOOM_FILTER_MAX_BYTES = " resource.resolver.vanitypath.bloomfilter.maxBytes";
    private static final boolean DEFAULT_ENABLE_OPTIMIZE_ALIAS_RESOLUTION = true;
    @Property(boolValue={true}, label="Optimize alias resolution", description="This flag controls whether to optimize the alias resolution by creating an internal cache of aliases. This might have an impact on the startup time and on the alias update time if the number of aliases is huge (over 10000).")
    private static final String PROP_ENABLE_OPTIMIZE_ALIAS_RESOLUTION = "resource.resolver.optimize.alias.resolution";
    @Property(unbounded=PropertyUnbounded.ARRAY, label="Allowed Vanity Path Location", description="This setting can contain a list of path prefixes, e.g. /libs/, /content/. If such a list is configured, only vanity paths from resources starting with this prefix  are considered. If the list is empty, all vanity paths are used.")
    private static final String PROP_ALLOWED_VANITY_PATH_PREFIX = "resource.resolver.vanitypath.whitelist";
    @Property(unbounded=PropertyUnbounded.ARRAY, label="Denied Vanity Path Location", description="This setting can contain a list of path prefixes, e.g. /misc/. If such a list is configured,vanity paths from resources starting with this prefix  are not considered. If the list is empty, all vanity paths are used.")
    private static final String PROP_DENIED_VANITY_PATH_PREFIX = "resource.resolver.vanitypath.blacklist";
    private static final boolean DEFAULT_VANITY_PATH_PRECEDENCE = false;
    @Property(boolValue={false}, label="Vanity Path Precedence", description="This flag controls whether vanity paths will have precedence over existing /etc/map mapping")
    private static final String PROP_VANITY_PATH_PRECEDENCE = "resource.resolver.vanity.precedence";
    private static final boolean DEFAULT_PARANOID_PROVIDER_HANDLING = false;
    @Property(boolValue={false}, label="Paranoid Provider Handling", description="If this flag is enabled, an unregistration of a resource provider (not factory), is causing the resource resolver factory to restart, potentially cleaning up for memory leaks caused by objects hold from that resource provider.")
    private static final String PROP_PARANOID_PROVIDER_HANDLING = "resource.resolver.providerhandling.paranoid";
    private static final boolean DEFAULT_LOG_RESOURCE_RESOLVER_CLOSING = false;
    @Property(boolValue={false}, label="Log resource resolver closing", description="When enabled CRUD operations with a closed resource resolver will log a stack trace with the point where the used resolver was closed. It's advisable to not enable this feature on production systems.")
    private static final String PROP_LOG_RESOURCE_RESOLVER_CLOSING = "resource.resolver.log.closing";
    private final ResourceDecoratorTracker resourceDecoratorTracker = new ResourceDecoratorTracker();
    private Mapping[] mappings;
    private BidiMap virtualURLMap;
    private boolean allowDirect = false;
    private String[] searchPath;
    private String mapRoot;
    private boolean mangleNamespacePrefixes;
    @Reference
    EventAdmin eventAdmin;
    @Reference
    private ServiceUserMapper serviceUserMapper;
    @Reference
    ResourceAccessSecurityTracker resourceAccessSecurityTracker;
    volatile ResourceProviderTracker resourceProviderTracker;
    volatile ResourceChangeListenerWhiteboard changeListenerWhiteboard;
    private volatile ComponentContext componentContext;
    private int defaultVanityPathRedirectStatus;
    private boolean enableVanityPath = true;
    private boolean enableOptimizeAliasResolution = true;
    private long maxCachedVanityPathEntries = -1L;
    private boolean maxCachedVanityPathEntriesStartup = true;
    private int vanityBloomFilterMaxBytes = 1024000;
    private boolean vanityPathPrecedence = false;
    private boolean logResourceResolverClosing = false;
    private String[] vanityPathWhiteList;
    private String[] vanityPathBlackList;
    private final FactoryPreconditions preconds = new FactoryPreconditions();
    private volatile FactoryRegistration factoryRegistration;
    private final Object coordinator = new Object();
    private final List<BG_OP> operations = new ArrayList<BG_OP>();
    private String[] requiredResourceProviders;

    public ResourceDecoratorTracker getResourceDecoratorTracker() {
        return this.resourceDecoratorTracker;
    }

    public ResourceAccessSecurityTracker getResourceAccessSecurityTracker() {
        return this.resourceAccessSecurityTracker;
    }

    public EventAdmin getEventAdmin() {
        return this.eventAdmin;
    }

    public BidiMap getVirtualURLMap() {
        return this.virtualURLMap;
    }

    public Mapping[] getMappings() {
        return this.mappings;
    }

    public String[] getSearchPath() {
        return this.searchPath;
    }

    public boolean isMangleNamespacePrefixes() {
        return this.mangleNamespacePrefixes;
    }

    public String getMapRoot() {
        return this.mapRoot;
    }

    public int getDefaultVanityPathRedirectStatus() {
        return this.defaultVanityPathRedirectStatus;
    }

    public boolean isVanityPathEnabled() {
        return this.enableVanityPath;
    }

    public boolean isOptimizeAliasResolutionEnabled() {
        return this.enableOptimizeAliasResolution;
    }

    public String[] getVanityPathWhiteList() {
        return this.vanityPathWhiteList;
    }

    public String[] getVanityPathBlackList() {
        return this.vanityPathBlackList;
    }

    public boolean hasVanityPathPrecedence() {
        return this.vanityPathPrecedence;
    }

    public long getMaxCachedVanityPathEntries() {
        return this.maxCachedVanityPathEntries;
    }

    public boolean isMaxCachedVanityPathEntriesStartup() {
        return this.maxCachedVanityPathEntriesStartup;
    }

    public int getVanityBloomFilterMaxBytes() {
        return this.vanityBloomFilterMaxBytes;
    }

    public boolean shouldLogResourceResolverClosing() {
        return this.logResourceResolverClosing;
    }

    @Activate
    protected void activate(ComponentContext componentContext) {
        ArrayList<String> prefixList;
        this.componentContext = componentContext;
        Dictionary properties = componentContext.getProperties();
        TreeBidiMap virtuals = new TreeBidiMap();
        String[] virtualList = PropertiesUtil.toStringArray(properties.get(PROP_VIRTUAL));
        for (int i = 0; virtualList != null && i < virtualList.length; ++i) {
            String[] parts = Mapping.split(virtualList[i]);
            virtuals.put((Object)parts[0], (Object)parts[2]);
        }
        this.virtualURLMap = virtuals;
        ArrayList<Mapping> maps = new ArrayList<Mapping>();
        String[] mappingList = (String[])properties.get(PROP_MAPPING);
        for (int i = 0; mappingList != null && i < mappingList.length; ++i) {
            maps.add(new Mapping(mappingList[i]));
        }
        Mapping[] tmp = maps.toArray(new Mapping[maps.size()]);
        Boolean directProp = (Boolean)properties.get(PROP_ALLOW_DIRECT);
        boolean bl = this.allowDirect = directProp != null ? directProp : true;
        if (this.allowDirect) {
            Mapping[] tmp2 = new Mapping[tmp.length + 1];
            tmp2[0] = Mapping.DIRECT;
            System.arraycopy(tmp, 0, tmp2, 1, tmp.length);
            this.mappings = tmp2;
        } else {
            this.mappings = tmp;
        }
        this.searchPath = PropertiesUtil.toStringArray(properties.get(PROP_PATH));
        if (this.searchPath != null && this.searchPath.length > 0) {
            for (int i = 0; i < this.searchPath.length; ++i) {
                if (!this.searchPath[i].startsWith("/")) {
                    this.searchPath[i] = "/" + this.searchPath[i];
                }
                if (this.searchPath[i].endsWith("/")) continue;
                int n = i;
                this.searchPath[n] = this.searchPath[n] + "/";
            }
        }
        if (this.searchPath == null) {
            this.searchPath = new String[]{"/"};
        }
        if (this.resourceProviderTracker == null) {
            this.resourceProviderTracker = new ResourceProviderTracker();
            this.changeListenerWhiteboard = new ResourceChangeListenerWhiteboard();
            this.changeListenerWhiteboard.activate(this.componentContext.getBundleContext(), this.resourceProviderTracker, this.searchPath);
            this.resourceProviderTracker.activate(this.componentContext.getBundleContext(), this.eventAdmin, new ResourceProviderTracker.ChangeListener(){

                @Override
                public void providerAdded() {
                    if (ResourceResolverFactoryActivator.this.factoryRegistration == null) {
                        ResourceResolverFactoryActivator.this.checkFactoryPreconditions(null);
                    }
                }

                @Override
                public void providerRemoved(String pid) {
                    if (ResourceResolverFactoryActivator.this.factoryRegistration != null) {
                        ResourceResolverFactoryActivator.this.checkFactoryPreconditions(pid);
                    }
                }
            });
        }
        this.mangleNamespacePrefixes = PropertiesUtil.toBoolean(properties.get(PROP_MANGLE_NAMESPACES), (boolean)false);
        this.mapRoot = PropertiesUtil.toString(properties.get(PROP_MAP_LOCATION), (String)"/etc/map");
        this.defaultVanityPathRedirectStatus = PropertiesUtil.toInteger(properties.get(PROP_DEFAULT_VANITY_PATH_REDIRECT_STATUS), (int)302);
        this.enableVanityPath = PropertiesUtil.toBoolean(properties.get(PROP_ENABLE_VANITY_PATH), (boolean)true);
        this.vanityPathWhiteList = null;
        String[] vanityPathPrefixes = PropertiesUtil.toStringArray(properties.get(PROP_ALLOWED_VANITY_PATH_PREFIX));
        if (vanityPathPrefixes != null) {
            prefixList = new ArrayList<String>();
            for (String value : vanityPathPrefixes) {
                if (value.trim().length() <= 0) continue;
                if (value.trim().endsWith("/")) {
                    prefixList.add(value.trim());
                    continue;
                }
                prefixList.add(value.trim() + "/");
            }
            if (prefixList.size() > 0) {
                this.vanityPathWhiteList = prefixList.toArray(new String[prefixList.size()]);
            }
        }
        this.vanityPathBlackList = null;
        vanityPathPrefixes = PropertiesUtil.toStringArray(properties.get(PROP_DENIED_VANITY_PATH_PREFIX));
        if (vanityPathPrefixes != null) {
            prefixList = new ArrayList();
            for (String value : vanityPathPrefixes) {
                if (value.trim().length() <= 0) continue;
                if (value.trim().endsWith("/")) {
                    prefixList.add(value.trim());
                    continue;
                }
                prefixList.add(value.trim() + "/");
            }
            if (prefixList.size() > 0) {
                this.vanityPathBlackList = prefixList.toArray(new String[prefixList.size()]);
            }
        }
        this.enableOptimizeAliasResolution = PropertiesUtil.toBoolean(properties.get(PROP_ENABLE_OPTIMIZE_ALIAS_RESOLUTION), (boolean)true);
        this.maxCachedVanityPathEntries = PropertiesUtil.toLong(properties.get(PROP_MAX_CACHED_VANITY_PATHS), (long)-1L);
        this.maxCachedVanityPathEntriesStartup = PropertiesUtil.toBoolean(properties.get(PROP_MAX_CACHED_VANITY_PATHS_STARTUP), (boolean)true);
        this.vanityBloomFilterMaxBytes = PropertiesUtil.toInteger(properties.get(PROP_VANITY_BLOOM_FILTER_MAX_BYTES), (int)1024000);
        this.vanityPathPrecedence = PropertiesUtil.toBoolean(properties.get(PROP_VANITY_PATH_PRECEDENCE), (boolean)false);
        this.logResourceResolverClosing = PropertiesUtil.toBoolean(properties.get(PROP_LOG_RESOURCE_RESOLVER_CLOSING), (boolean)false);
        BundleContext bc = componentContext.getBundleContext();
        this.requiredResourceProviders = PropertiesUtil.toStringArray(properties.get(PROP_REQUIRED_PROVIDERS));
        this.preconds.activate(bc, this.requiredResourceProviders, this.resourceProviderTracker);
        this.checkFactoryPreconditions(null);
        Thread t = new Thread(this);
        t.setDaemon(true);
        t.start();
    }

    @Deactivate
    protected void deactivate() {
        this.changeListenerWhiteboard.deactivate();
        this.resourceProviderTracker.deactivate();
        this.componentContext = null;
        this.preconds.deactivate();
        this.resourceDecoratorTracker.close();
        this.unregisterFactory();
        this.addOperation(BG_OP.STOP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterFactory() {
        FactoryRegistration local = null;
        ResourceResolverFactoryActivator resourceResolverFactoryActivator = this;
        synchronized (resourceResolverFactoryActivator) {
            if (this.factoryRegistration != null) {
                local = this.factoryRegistration;
                this.factoryRegistration = null;
            }
        }
        this.unregisterFactory(local);
    }

    private void unregisterFactory(FactoryRegistration local) {
        if (local != null) {
            if (local.factoryRegistration != null) {
                local.factoryRegistration.unregister();
            }
            if (local.runtimeRegistration != null) {
                local.runtimeRegistration.unregister();
            }
            if (local.commonFactory != null) {
                local.commonFactory.deactivate();
            }
        }
    }

    private void registerFactory(ComponentContext localContext) {
        final FactoryRegistration local = new FactoryRegistration();
        if (localContext != null) {
            Hashtable serviceProps = new Hashtable();
            ((Dictionary)serviceProps).put("service.vendor", localContext.getProperties().get("service.vendor"));
            ((Dictionary)serviceProps).put("service.description", localContext.getProperties().get("service.description"));
            local.commonFactory = new CommonResourceResolverFactoryImpl(this);
            local.commonFactory.activate(localContext.getBundleContext());
            local.factoryRegistration = localContext.getBundleContext().registerService(ResourceResolverFactory.class.getName(), (Object)new ServiceFactory(){

                public Object getService(Bundle bundle, ServiceRegistration registration) {
                    ResourceResolverFactoryImpl r = new ResourceResolverFactoryImpl(local.commonFactory, bundle, ResourceResolverFactoryActivator.this.serviceUserMapper);
                    return r;
                }

                public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
                }
            }, serviceProps);
            local.runtimeRegistration = localContext.getBundleContext().registerService(RuntimeService.class.getName(), (Object)this.getRuntimeService(), null);
            this.factoryRegistration = local;
        }
    }

    public RuntimeService getRuntimeService() {
        return new RuntimeServiceImpl(this.resourceProviderTracker);
    }

    private void checkFactoryPreconditions(String unavailableServicePid) {
        ComponentContext localContext = this.componentContext;
        if (localContext != null) {
            boolean result = this.preconds.checkPreconditions(unavailableServicePid);
            if (result && this.factoryRegistration == null) {
                this.registerFactory(localContext);
            } else if (!result && this.factoryRegistration != null) {
                this.unregisterFactory();
            }
        }
    }

    protected void bindResourceDecorator(ResourceDecorator decorator, Map<String, Object> props) {
        this.resourceDecoratorTracker.bindResourceDecorator(decorator, props);
    }

    protected void unbindResourceDecorator(ResourceDecorator decorator, Map<String, Object> props) {
        this.resourceDecoratorTracker.unbindResourceDecorator(decorator, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean isRunning = true;
        while (isRunning) {
            ArrayList<BG_OP> ops = new ArrayList<BG_OP>();
            Object object = this.coordinator;
            synchronized (object) {
                while (this.operations.isEmpty()) {
                    try {
                        this.coordinator.wait();
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                    }
                }
                ops.addAll(this.operations);
                this.operations.clear();
            }
            boolean bl = isRunning = !ops.contains((Object)BG_OP.STOP);
            if (isRunning && ops.lastIndexOf((Object)BG_OP.UNREGISTER_AND_CHECK) != -1) {
                this.unregisterFactory();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
                ops.clear();
                object = this.coordinator;
                synchronized (object) {
                    ops.addAll(this.operations);
                    this.operations.clear();
                }
                boolean bl2 = isRunning = !ops.contains((Object)BG_OP.STOP);
            }
            if (!isRunning) continue;
            this.checkFactoryPreconditions(null);
        }
        this.unregisterFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOperation(BG_OP op) {
        Object object = this.coordinator;
        synchronized (object) {
            this.operations.add(op);
            this.coordinator.notify();
        }
    }

    public ResourceProviderTracker getResourceProviderTracker() {
        return this.resourceProviderTracker;
    }

    protected void bindEventAdmin(EventAdmin eventAdmin) {
        this.eventAdmin = eventAdmin;
    }

    protected void unbindEventAdmin(EventAdmin eventAdmin) {
        if (this.eventAdmin == eventAdmin) {
            this.eventAdmin = null;
        }
    }

    protected void bindServiceUserMapper(ServiceUserMapper serviceUserMapper) {
        this.serviceUserMapper = serviceUserMapper;
    }

    protected void unbindServiceUserMapper(ServiceUserMapper serviceUserMapper) {
        if (this.serviceUserMapper == serviceUserMapper) {
            this.serviceUserMapper = null;
        }
    }

    protected void bindResourceAccessSecurityTracker(ResourceAccessSecurityTracker resourceAccessSecurityTracker) {
        this.resourceAccessSecurityTracker = resourceAccessSecurityTracker;
    }

    protected void unbindResourceAccessSecurityTracker(ResourceAccessSecurityTracker resourceAccessSecurityTracker) {
        if (this.resourceAccessSecurityTracker == resourceAccessSecurityTracker) {
            this.resourceAccessSecurityTracker = null;
        }
    }

    private static enum BG_OP {
        CHECK,
        UNREGISTER_AND_CHECK,
        STOP;

    }

    private static final class FactoryRegistration {
        public volatile ServiceRegistration factoryRegistration;
        public volatile ServiceRegistration runtimeRegistration;
        public volatile CommonResourceResolverFactoryImpl commonFactory;

        private FactoryRegistration() {
        }
    }
}

