/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl.picker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.resourcemerger.impl.StubResource;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(name="org.apache.sling.resourcemerger.picker.overriding", label="Apache Sling Overriding Resource Picker", description="This resource picker delivers merged resources based on the resource type hierarchy.", metatype=true, policy=ConfigurationPolicy.REQUIRE)
@Service
@Properties(value={@Property(name="merge.root", value={"/mnt/override"}, label="Root", description="Root path at which merged resources will be available."), @Property(name="merge.readOnly", boolValue={true}, label="Read Only", description="Specifies if the resources are read-only or can be modified.")})
public class OverridingResourcePicker
implements MergedResourcePicker {
    public static final String DEFAULT_ROOT = "/mnt/override";

    @Override
    public List<Resource> pickResources(ResourceResolver resolver, String relativePath) {
        String absPath = "/" + relativePath;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        Object currentTarget = resolver.getResource(absPath);
        if (currentTarget == null) {
            currentTarget = new StubResource(resolver, absPath);
        }
        resources.add((Resource)currentTarget);
        while (currentTarget != null) {
            InheritanceRootInfo info = new InheritanceRootInfo();
            this.findInheritanceRoot((Resource)currentTarget, info);
            if (info.resource == null) {
                currentTarget = null;
                continue;
            }
            Resource inheritanceRootResource = info.resource;
            String pathRelativeToInheritanceRoot = info.getPathRelativeToInheritanceRoot();
            String superType = inheritanceRootResource.getResourceSuperType();
            if (superType == null) {
                currentTarget = null;
                continue;
            }
            String superTypeChildPath = superType + pathRelativeToInheritanceRoot;
            Resource superTypeResource = resolver.getResource(superTypeChildPath);
            currentTarget = superTypeResource != null ? superTypeResource : new StubResource(resolver, superTypeChildPath);
            resources.add((Resource)currentTarget);
        }
        Collections.reverse(resources);
        return resources;
    }

    private void findInheritanceRoot(Resource target, InheritanceRootInfo info) {
        String superType = target.getResourceSuperType();
        if (superType != null) {
            info.resource = target;
        } else {
            Resource parent = target.getParent();
            if (parent != null) {
                info.addLevel(target.getName());
                this.findInheritanceRoot(parent, info);
            }
        }
    }

    private class InheritanceRootInfo {
        private Resource resource;
        private final StringBuilder pathRelativeToInheritanceRoot = new StringBuilder();

        private InheritanceRootInfo() {
        }

        private String getPathRelativeToInheritanceRoot() {
            return this.pathRelativeToInheritanceRoot.toString();
        }

        private void addLevel(String name) {
            this.pathRelativeToInheritanceRoot.insert(0, name).insert(0, '/');
        }
    }
}

