/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcemerger.impl;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.sling.api.resource.ResourceProviderFactory;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.apache.sling.resourcemerger.impl.MergingResourceProviderFactory;
import org.apache.sling.resourcemerger.spi.MergedResourcePicker;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@Component
public class MergedResourcePickerWhiteboard
implements ServiceTrackerCustomizer {
    private ServiceTracker tracker;
    private BundleContext bundleContext;
    private final Map<Long, ServiceRegistration> serviceRegistrations = new ConcurrentHashMap<Long, ServiceRegistration>();

    @Activate
    protected void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.tracker = new ServiceTracker(bundleContext, MergedResourcePicker.class.getName(), (ServiceTrackerCustomizer)this);
        this.tracker.open();
    }

    @Deactivate
    protected void deactivate() {
        this.tracker.close();
    }

    public Object addingService(ServiceReference reference) {
        MergedResourcePicker picker = (MergedResourcePicker)this.bundleContext.getService(reference);
        if (picker != null) {
            String mergeRoot = PropertiesUtil.toString((Object)reference.getProperty("merge.root"), null);
            if (mergeRoot != null) {
                MergingResourceProviderFactory providerFactory = new MergingResourceProviderFactory(mergeRoot, picker, PropertiesUtil.toBoolean((Object)reference.getProperty("merge.readOnly"), (boolean)true));
                Hashtable<String, Object> props = new Hashtable<String, Object>();
                ((Dictionary)props).put("provider.roots", mergeRoot);
                ((Dictionary)props).put("provider.ownsRoots", true);
                Long key = (Long)reference.getProperty("service.id");
                ServiceRegistration reg = this.bundleContext.registerService(ResourceProviderFactory.class.getName(), (Object)providerFactory, props);
                this.serviceRegistrations.put(key, reg);
            }
            return picker;
        }
        return null;
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        Long key = (Long)reference.getProperty("service.id");
        ServiceRegistration reg = this.serviceRegistrations.get(key);
        if (reg != null) {
            reg.unregister();
            this.bundleContext.ungetService(reference);
        }
    }
}

