/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.resourcebuilder.impl;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.resourcebuilder.api.ResourceBuilder;
import org.apache.sling.resourcebuilder.impl.MapArgsConverter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBuilderImpl
implements ResourceBuilder {
    @NotNull
    private final Resource originalParent;
    @NotNull
    private final ResourceResolver resourceResolver;
    @NotNull
    private Resource currentParent;
    private String intermediatePrimaryType;
    private boolean hierarchyMode;
    public static final String JCR_PRIMARYTYPE = "jcr:primaryType";
    public static final String JCR_MIMETYPE = "jcr:mimeType";
    public static final String JCR_LASTMODIFIED = "jcr:lastModified";
    public static final String JCR_DATA = "jcr:data";
    public static final String JCR_CONTENT = "jcr:content";
    public static final String NT_RESOURCE = "nt:resource";
    public static final String NT_FILE = "nt:file";
    public static final String CANNOT_RESTART = "Cannot reset the parent resource or resource resolver, please create a new builder using the ResourceBuilder service";
    @NotNull
    private final MimeTypeService mimeTypeService;

    public ResourceBuilderImpl(@NotNull Resource parent, @NotNull MimeTypeService mts) {
        this.mimeTypeService = mts;
        if (parent == null) {
            throw new IllegalArgumentException("Parent resource is null");
        }
        this.originalParent = parent;
        this.resourceResolver = this.originalParent.getResourceResolver();
        this.intermediatePrimaryType = "nt:unstructured";
        this.currentParent = parent;
        this.hierarchyMode = true;
    }

    @NotNull
    private ResourceBuilderImpl cloneResourceBuilder(@NotNull Resource newCurrentParent, @Nullable String newIntermediatePrimaryType, boolean newHierarchyMode) {
        ResourceBuilderImpl clone = new ResourceBuilderImpl(this.originalParent, this.mimeTypeService);
        clone.currentParent = newCurrentParent;
        clone.intermediatePrimaryType = newIntermediatePrimaryType;
        clone.hierarchyMode = newHierarchyMode;
        return clone;
    }

    @Override
    @NotNull
    public Resource getCurrentParent() {
        return this.currentParent;
    }

    @Override
    @NotNull
    public ResourceBuilder atParent() {
        return this.cloneResourceBuilder(this.originalParent, this.intermediatePrimaryType, true);
    }

    private boolean isAbsolutePath(String path) {
        return path.startsWith("/") && !path.contains("..");
    }

    private void checkRelativePath(String path) {
        if (path.startsWith("/")) {
            throw new IllegalArgumentException("Path is not relative:" + path);
        }
        if (path.contains("..")) {
            throw new IllegalArgumentException("Path contains invalid pattern '..': " + path);
        }
    }

    private String parentPath(String relativePath) {
        String parentPath = this.currentParent.getPath();
        String fullPath = parentPath.endsWith("/") ? parentPath + relativePath : parentPath + "/" + relativePath;
        return ResourceUtil.getParent((String)fullPath);
    }

    @Override
    @NotNull
    public ResourceBuilder resource(@NotNull String path, @NotNull Map<String, Object> properties) {
        String fullPath;
        String parentPath;
        Resource r = null;
        boolean absolutePath = this.isAbsolutePath(path);
        if (absolutePath) {
            parentPath = ResourceUtil.getParent((String)path);
            fullPath = path;
        } else {
            this.checkRelativePath(path);
            parentPath = this.parentPath(path);
            fullPath = this.currentParent.getPath() + "/" + path;
        }
        Resource myParent = this.ensureResourceExists(parentPath);
        try {
            r = this.currentParent.getResourceResolver().getResource(fullPath);
            if (r == null) {
                r = this.currentParent.getResourceResolver().create(myParent, ResourceUtil.getName((String)fullPath), properties);
            } else {
                ModifiableValueMap mvm = (ModifiableValueMap)r.adaptTo(ModifiableValueMap.class);
                if (mvm == null) {
                    throw new IllegalStateException("Cannot modify properties of " + r.getPath());
                }
                for (Map.Entry<String, Object> e : properties.entrySet()) {
                    mvm.put((Object)e.getKey(), e.getValue());
                }
            }
        }
        catch (PersistenceException pex) {
            throw new RuntimeException("PersistenceException while creating Resource " + fullPath, pex);
        }
        if (r == null) {
            throw new RuntimeException("Failed to get or create resource " + fullPath);
        }
        if (this.hierarchyMode || absolutePath) {
            return this.cloneResourceBuilder(r, this.intermediatePrimaryType, true);
        }
        return this;
    }

    @Override
    @NotNull
    public ResourceBuilder resource(@NotNull String path, Object ... properties) {
        if (properties == null || properties.length == 0) {
            return this.resource(path, (Map<String, Object>)ValueMap.EMPTY);
        }
        if (properties.length == 1 && properties[0] instanceof Map) {
            return this.resource(path, (Map)properties[0]);
        }
        return this.resource(path, MapArgsConverter.toMap(properties));
    }

    protected final Resource ensureResourceExists(String path) {
        if (path == null || path.length() == 0 || path.equals("/")) {
            return this.resourceResolver.getResource("/");
        }
        Resource resource = this.resourceResolver.getResource(path);
        if (resource != null) {
            return resource;
        }
        String parentPath = ResourceUtil.getParent((String)path);
        String name = ResourceUtil.getName((String)path);
        Resource parentResource = this.ensureResourceExists(parentPath);
        try {
            resource = this.resourceResolver.create(parentResource, name, MapArgsConverter.toMap(JCR_PRIMARYTYPE, this.intermediatePrimaryType));
            return resource;
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to create intermediate resource at " + path, ex);
        }
    }

    protected String getMimeType(String filename, String userSuppliedMimeType) {
        if (userSuppliedMimeType != null) {
            return userSuppliedMimeType;
        }
        return this.mimeTypeService.getMimeType(filename);
    }

    protected long getLastModified(long userSuppliedValue) {
        if (userSuppliedValue < 0L) {
            return System.currentTimeMillis();
        }
        return userSuppliedValue;
    }

    @Override
    @NotNull
    public ResourceBuilder file(@NotNull String relativePath, @NotNull InputStream data, @Nullable String mimeType, long lastModified) {
        this.checkRelativePath(relativePath);
        String name = ResourceUtil.getName((String)relativePath);
        if (data == null) {
            throw new IllegalArgumentException("Data is null for file " + name);
        }
        Resource file = null;
        ResourceResolver resolver = this.currentParent.getResourceResolver();
        String parentPath = this.parentPath(relativePath);
        Resource parent = this.ensureResourceExists(parentPath);
        try {
            String fullPath = this.currentParent.getPath() + "/" + name;
            if (resolver.getResource(fullPath) != null) {
                throw new IllegalStateException("Resource already exists:" + fullPath);
            }
            HashMap<String, String> fileProps = new HashMap<String, String>();
            fileProps.put(JCR_PRIMARYTYPE, NT_FILE);
            file = resolver.create(parent, name, fileProps);
            HashMap<String, Object> contentProps = new HashMap<String, Object>();
            contentProps.put(JCR_PRIMARYTYPE, NT_RESOURCE);
            contentProps.put(JCR_MIMETYPE, this.getMimeType(name, mimeType));
            contentProps.put(JCR_LASTMODIFIED, this.getLastModified(lastModified));
            contentProps.put(JCR_DATA, data);
            resolver.create(file, JCR_CONTENT, contentProps);
        }
        catch (PersistenceException pex) {
            throw new RuntimeException("Unable to create file under " + this.currentParent.getPath(), pex);
        }
        if (file == null) {
            throw new RuntimeException("Unable to get or created file resource " + relativePath + " under " + this.currentParent.getPath());
        }
        if (this.hierarchyMode) {
            return this.cloneResourceBuilder(file, this.intermediatePrimaryType, this.hierarchyMode);
        }
        return this;
    }

    @Override
    @NotNull
    public ResourceBuilder file(@NotNull String filename, @NotNull InputStream data) {
        return this.file(filename, data, null, -1L);
    }

    @Override
    @NotNull
    public ResourceBuilder withIntermediatePrimaryType(@Nullable String primaryType) {
        String intermediatePrimaryType = primaryType == null ? "nt:unstructured" : primaryType;
        return this.cloneResourceBuilder(this.currentParent, intermediatePrimaryType, this.hierarchyMode);
    }

    @Override
    @NotNull
    public ResourceBuilder siblingsMode() {
        return this.cloneResourceBuilder(this.currentParent, this.intermediatePrimaryType, false);
    }

    @Override
    @NotNull
    public ResourceBuilder hierarchyMode() {
        return this.cloneResourceBuilder(this.currentParent, this.intermediatePrimaryType, true);
    }

    @Override
    @NotNull
    public ResourceBuilder commit() {
        try {
            this.resourceResolver.commit();
        }
        catch (PersistenceException ex) {
            throw new RuntimeException("Unable to commit", ex);
        }
        return this;
    }
}

