/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.models.impl.model.ModelClass;
import org.apache.sling.models.spi.ImplementationPicker;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AdapterImplementations {
    private static final Logger log = LoggerFactory.getLogger(AdapterImplementations.class);
    private final ConcurrentMap<String, ConcurrentNavigableMap<String, ModelClass<?>>> adapterImplementations = new ConcurrentHashMap();
    private final ConcurrentMap<String, ModelClass<?>> modelClasses = new ConcurrentHashMap();
    private final ConcurrentMap<String, Class<?>> resourceTypeMappingsForResources = new ConcurrentHashMap();
    private final ConcurrentMap<String, Class<?>> resourceTypeMappingsForRequests = new ConcurrentHashMap();
    private final ConcurrentMap<Bundle, List<String>> resourceTypeRemovalListsForResources = new ConcurrentHashMap<Bundle, List<String>>();
    private final ConcurrentMap<Bundle, List<String>> resourceTypeRemovalListsForRequests = new ConcurrentHashMap<Bundle, List<String>>();
    private volatile ImplementationPicker[] sortedImplementationPickers = new ImplementationPicker[0];
    private volatile StaticInjectAnnotationProcessorFactory[] sortedStaticInjectAnnotationProcessorFactories = new StaticInjectAnnotationProcessorFactory[0];

    AdapterImplementations() {
    }

    public void setImplementationPickers(Collection<ImplementationPicker> implementationPickers) {
        this.sortedImplementationPickers = implementationPickers.toArray(new ImplementationPicker[implementationPickers.size()]);
    }

    public ImplementationPicker[] getImplementationPickers() {
        return this.sortedImplementationPickers;
    }

    public StaticInjectAnnotationProcessorFactory[] getStaticInjectAnnotationProcessorFactories() {
        return this.sortedStaticInjectAnnotationProcessorFactories;
    }

    public void setStaticInjectAnnotationProcessorFactories(Collection<StaticInjectAnnotationProcessorFactory> factories) {
        this.sortedStaticInjectAnnotationProcessorFactories = factories.toArray(new StaticInjectAnnotationProcessorFactory[factories.size()]);
        this.updateProcessorFactoriesInModelClasses();
    }

    private void updateProcessorFactoriesInModelClasses() {
        Iterator<ModelClass<?>> items = this.modelClasses.values().iterator();
        this.updateProcessorFactoriesInModelClasses(items);
        for (ConcurrentNavigableMap mapItem : this.adapterImplementations.values()) {
            this.updateProcessorFactoriesInModelClasses(mapItem.values().iterator());
        }
    }

    private void updateProcessorFactoriesInModelClasses(Iterator<ModelClass<?>> items) {
        while (items.hasNext()) {
            ModelClass<?> item = items.next();
            item.updateProcessorFactories(this.sortedStaticInjectAnnotationProcessorFactories);
        }
    }

    protected void addClassesAsAdapterAndImplementation(Class<?> ... modelClasses) {
        for (Class<?> modelClass : modelClasses) {
            this.addAll(modelClass, modelClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean addAll(Class<?> implType, Class<?> ... adapterTypes) {
        ModelClass modelClass = null;
        try {
            modelClass = new ModelClass(implType, this.sortedStaticInjectAnnotationProcessorFactories);
        }
        catch (Exception e) {
            log.warn("Unable to reflect on " + implType.getName(), (Throwable)e);
            return false;
        }
        catch (NoClassDefFoundError e) {
            log.warn("Unable to reflect on " + implType.getName(), (Throwable)e);
            return false;
        }
        for (Class<?> adapterType : adapterTypes) {
            String key = adapterType.getName();
            if (adapterType == implType) {
                this.modelClasses.put(key, modelClass);
                continue;
            }
            ConcurrentMap<String, ConcurrentNavigableMap<String, ModelClass<?>>> concurrentMap = this.adapterImplementations;
            synchronized (concurrentMap) {
                ConcurrentSkipListMap implementations = (ConcurrentSkipListMap)this.adapterImplementations.get(key);
                if (implementations == null) {
                    implementations = new ConcurrentSkipListMap();
                    this.adapterImplementations.put(key, implementations);
                }
                implementations.put(implType.getName(), modelClass);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String adapterTypeName, String implTypeName) {
        String key = adapterTypeName;
        if (StringUtils.equals((CharSequence)adapterTypeName, (CharSequence)implTypeName)) {
            this.modelClasses.remove(key);
        } else {
            ConcurrentMap<String, ConcurrentNavigableMap<String, ModelClass<?>>> concurrentMap = this.adapterImplementations;
            synchronized (concurrentMap) {
                ConcurrentNavigableMap implementations = (ConcurrentNavigableMap)this.adapterImplementations.get(key);
                if (implementations != null) {
                    implementations.remove(implTypeName);
                    if (implementations.isEmpty()) {
                        this.adapterImplementations.remove(key);
                    }
                }
            }
        }
    }

    public void removeAll() {
        this.modelClasses.clear();
        this.adapterImplementations.clear();
    }

    public <ModelType> ModelClass<ModelType> lookup(Class<ModelType> adapterType, Object adaptable) {
        String key = adapterType.getName();
        ModelClass modelClass = (ModelClass)this.modelClasses.get(key);
        if (modelClass != null) {
            return modelClass;
        }
        ConcurrentNavigableMap implementations = (ConcurrentNavigableMap)this.adapterImplementations.get(key);
        if (implementations == null || implementations.isEmpty()) {
            return null;
        }
        Collection implementationsCollection = implementations.values();
        ModelClass[] implementationWrappersArray = implementationsCollection.toArray(new ModelClass[implementationsCollection.size()]);
        Class[] implementationsArray = new Class[implementationsCollection.size()];
        for (int i = 0; i < implementationWrappersArray.length; ++i) {
            implementationsArray[i] = implementationWrappersArray[i].getType();
        }
        for (ImplementationPicker picker : this.sortedImplementationPickers) {
            Class implementation = picker.pick(adapterType, implementationsArray, adaptable);
            if (implementation == null) continue;
            for (int i = 0; i < implementationWrappersArray.length; ++i) {
                if (implementation != implementationWrappersArray[i].getType()) continue;
                return implementationWrappersArray[i];
            }
        }
        return null;
    }

    public <ModelType> boolean isModelClass(Class<ModelType> adapterType) {
        String key = adapterType.getName();
        ModelClass modelClass = (ModelClass)this.modelClasses.get(key);
        if (modelClass != null) {
            return true;
        }
        ConcurrentNavigableMap implementations = (ConcurrentNavigableMap)this.adapterImplementations.get(key);
        return implementations != null && !implementations.isEmpty();
    }

    public void registerModelToResourceType(Bundle bundle, String resourceType, Class<?> adaptableType, Class<?> clazz) {
        ConcurrentMap<Bundle, List<String>> resourceTypeRemovalLists;
        ConcurrentMap<String, Class<?>> map;
        if (resourceType.startsWith("/")) {
            log.warn("Registering model class {} for adaptable {} with absolute resourceType {}.", new Object[]{clazz, adaptableType, resourceType});
        }
        if (adaptableType == Resource.class) {
            map = this.resourceTypeMappingsForResources;
            resourceTypeRemovalLists = this.resourceTypeRemovalListsForResources;
        } else if (adaptableType == SlingHttpServletRequest.class) {
            map = this.resourceTypeMappingsForRequests;
            resourceTypeRemovalLists = this.resourceTypeRemovalListsForRequests;
        } else {
            log.warn("Found model class {} with resource type {} for adaptable {}. Unsupported type for resourceType binding.", new Object[]{clazz, resourceType, adaptableType});
            return;
        }
        Class<?> existingMapping = map.putIfAbsent(resourceType, clazz);
        if (existingMapping == null) {
            resourceTypeRemovalLists.putIfAbsent(bundle, new CopyOnWriteArrayList());
            ((List)resourceTypeRemovalLists.get(bundle)).add(resourceType);
        } else {
            log.warn("Skipped registering {} for resourceType {} under adaptable {} because of existing mapping to {}", new Object[]{clazz, resourceType, adaptableType, existingMapping});
        }
    }

    public void removeResourceTypeBindings(Bundle bundle) {
        List registeredResourceTypes = (List)this.resourceTypeRemovalListsForResources.remove(bundle);
        if (registeredResourceTypes != null) {
            for (String resourceType : registeredResourceTypes) {
                this.resourceTypeMappingsForResources.remove(resourceType);
            }
        }
        if ((registeredResourceTypes = (List)this.resourceTypeRemovalListsForRequests.remove(bundle)) != null) {
            for (String resourceType : registeredResourceTypes) {
                this.resourceTypeMappingsForRequests.remove(resourceType);
            }
        }
    }

    public Class<?> getModelClassForRequest(SlingHttpServletRequest request) {
        return AdapterImplementations.getModelClassForResource(request.getResource(), this.resourceTypeMappingsForRequests);
    }

    public Class<?> getModelClassForResource(Resource resource) {
        return AdapterImplementations.getModelClassForResource(resource, this.resourceTypeMappingsForResources);
    }

    protected static Class<?> getModelClassForResource(Resource resource, Map<String, Class<?>> map) {
        if (resource == null) {
            return null;
        }
        ResourceResolver resolver = resource.getResourceResolver();
        String originalResourceType = resource.getResourceType();
        Class<?> modelClass = AdapterImplementations.getClassFromResourceTypeMap(originalResourceType, map, resolver);
        if (modelClass != null) {
            return modelClass;
        }
        String resourceType = resolver.getParentResourceType(resource);
        while (resourceType != null) {
            modelClass = AdapterImplementations.getClassFromResourceTypeMap(resourceType, map, resolver);
            if (modelClass != null) {
                return modelClass;
            }
            resourceType = resolver.getParentResourceType(resourceType);
        }
        Resource resourceTypeResource = resolver.getResource(originalResourceType);
        if (resourceTypeResource != null && !resourceTypeResource.getPath().equals(resource.getPath())) {
            return AdapterImplementations.getModelClassForResource(resourceTypeResource, map);
        }
        return null;
    }

    private static Class<?> getClassFromResourceTypeMap(String resourceType, Map<String, Class<?>> map, ResourceResolver resolver) {
        if (resourceType == null) {
            return null;
        }
        Class<?> modelClass = map.get(resourceType);
        if (modelClass == null) {
            for (String searchPath : resolver.getSearchPath()) {
                if (resourceType.startsWith("/") ? resourceType.startsWith(searchPath) && (modelClass = map.get(resourceType.substring(searchPath.length()))) != null : (modelClass = map.get(searchPath + resourceType)) != null) break;
            }
        }
        return modelClass;
    }

    Map<String, Class<?>> getResourceTypeMappingsForRequests() {
        return Collections.unmodifiableMap(this.resourceTypeMappingsForRequests);
    }

    Map<String, Class<?>> getResourceTypeMappingsForResources() {
        return Collections.unmodifiableMap(this.resourceTypeMappingsForResources);
    }
}

