/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.remote.testrunner;

import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.junit.runner.Description;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SlingRemoteTest {
    private final Class<?> testClass;
    private final String description;
    private final String failure;
    public static final String DESCRIPTION = "description";
    public static final String FAILURE = "failure";

    SlingRemoteTest(Class<?> testClass, JSONObject json) throws JSONException {
        this.testClass = testClass;
        this.description = json.getString(DESCRIPTION);
        this.failure = json.has(FAILURE) ? json.getString(FAILURE) : null;
    }

    Description describe() {
        return Description.createTestDescription(this.testClass, (String)this.description);
    }

    void run() {
        if (this.failure != null && this.failure.trim().length() > 0) {
            throw new AssertionError((Object)this.failure);
        }
    }
}

