/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.junit.remote.httpclient;

import java.io.IOException;
import org.apache.http.ParseException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.sling.testing.tools.http.Request;
import org.apache.sling.testing.tools.http.RequestBuilder;
import org.apache.sling.testing.tools.http.RequestCustomizer;
import org.apache.sling.testing.tools.http.RequestExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteTestHttpClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final String junitServletUrl;
    private final String username;
    private final String password;
    private StringBuilder subpath;
    private boolean consumeContent;
    private RequestCustomizer requestCustomizer;
    private static final String SLASH = "/";
    private static final String DOT = ".";

    public RemoteTestHttpClient(String junitServletUrl, boolean consumeContent) {
        this(junitServletUrl, null, null, consumeContent);
    }

    public RemoteTestHttpClient(String junitServletUrl, String username, String password, boolean consumeContent) {
        if (junitServletUrl == null) {
            throw new IllegalArgumentException("JUnit servlet URL is null, cannot run tests");
        }
        this.junitServletUrl = junitServletUrl;
        this.consumeContent = consumeContent;
        this.username = username != null ? username : "admin";
        this.password = password != null ? password : "admin";
    }

    public void setRequestCustomizer(RequestCustomizer c) {
        this.requestCustomizer = c;
    }

    public RequestExecutor runTests(String testClassesSelector, String testMethodSelector, String extension) throws ClientProtocolException, IOException {
        RequestBuilder builder = new RequestBuilder(this.junitServletUrl);
        RequestExecutor executor = new RequestExecutor(new DefaultHttpClient()){

            protected void consumeEntity() throws ParseException, IOException {
                if (RemoteTestHttpClient.this.consumeContent) {
                    super.consumeEntity();
                }
            }
        };
        this.subpath = new StringBuilder();
        if (!this.junitServletUrl.endsWith(SLASH)) {
            this.subpath.append(SLASH);
        }
        this.subpath.append(testClassesSelector);
        if (testMethodSelector != null && testMethodSelector.length() > 0) {
            this.subpath.append(SLASH);
            this.subpath.append(testMethodSelector);
        }
        if (!extension.startsWith(DOT)) {
            this.subpath.append(DOT);
        }
        this.subpath.append(extension);
        this.log.info("Executing test remotely, path={} JUnit servlet URL={}", (Object)this.subpath, (Object)this.junitServletUrl);
        Request r = builder.buildPostRequest(this.subpath.toString()).withCredentials(this.username, this.password).withCustomizer(this.requestCustomizer);
        executor.execute(r).assertStatus(200);
        return executor;
    }

    public String getTestExecutionPath() {
        return this.subpath == null ? null : this.subpath.toString();
    }
}

