/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal.helper.jcr;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Service(value={PathMapper.class})
@Component(metatype=true, label="Apache Sling JCR Resource Provider Path Mapper", description="This service provides path mappings for JCR nodes.")
public class PathMapper {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    @Property(unbounded=PropertyUnbounded.ARRAY, label="Path mapping", description="Defines an obtional path mapping for a path.Each mapping entry is expressed as follow: <JCRPath>:<resourcePath>. As an example: /foo:/libs, this maps the JCR node /foo to the resource /libs. If the resource path is specified as '.',  the JCR tree is not visible in the resource tree. This should not be considered a security feature  as the nodes are still accessible through the JCR api. Mapping a JCR path to the root is not allowed. The mappings are evaluated as ordered in the configuration.")
    private static final String PATH_MAPPING = "path.mapping";
    private final List<Mapping> mappings = new ArrayList<Mapping>();

    @Activate
    private void activate(Map<String, Object> props) {
        this.mappings.clear();
        String[] config = PropertiesUtil.toStringArray((Object)props.get(PATH_MAPPING), null);
        if (config != null) {
            for (String mapping : config) {
                boolean valid = false;
                String[] parts = mapping.split(":");
                if (parts.length == 2) {
                    parts[0] = parts[0].trim();
                    parts[1] = parts[1].trim();
                    if (parts[0].startsWith("/") && (parts[1].startsWith("/") || parts[1].equals("."))) {
                        if (parts[0].endsWith("/")) {
                            parts[0] = parts[0].substring(0, parts[1].length() - 1);
                        }
                        if (parts[1].endsWith("/")) {
                            parts[1] = parts[1].substring(0, parts[1].length() - 1);
                        }
                        if (parts[0].length() > 1 && (parts[1].length() > 1 || parts[1].equals("."))) {
                            this.mappings.add(new Mapping(parts[0], parts[1]));
                            valid = true;
                        }
                    }
                }
                if (valid) continue;
                this.log.warn("Invalid mapping configuration (skipping): {}", (Object)mapping);
            }
        }
    }

    public String mapResourcePathToJCRPath(String resourcePath) {
        String jcrPath = resourcePath;
        if (resourcePath != null && !this.mappings.isEmpty()) {
            for (Mapping mapping : this.mappings) {
                if (mapping.resourcePath == null) {
                    if (!resourcePath.equals(mapping.jcrPath) && !resourcePath.startsWith(mapping.jcrPathPrefix)) continue;
                    jcrPath = null;
                    break;
                }
                if (resourcePath.equals(mapping.resourcePath)) {
                    jcrPath = mapping.jcrPath;
                    break;
                }
                if (!resourcePath.startsWith(mapping.resourcePathPrefix)) continue;
                jcrPath = mapping.jcrPathPrefix.concat(resourcePath.substring(mapping.resourcePathPrefix.length()));
                break;
            }
        }
        return jcrPath;
    }

    public String mapJCRPathToResourcePath(String jcrPath) {
        String resourcePath = jcrPath;
        if (jcrPath != null && !this.mappings.isEmpty()) {
            for (Mapping mapping : this.mappings) {
                if (mapping.resourcePath != null && (jcrPath.equals(mapping.resourcePath) || jcrPath.startsWith(mapping.resourcePathPrefix))) {
                    resourcePath = null;
                    break;
                }
                if (jcrPath.equals(mapping.jcrPath)) {
                    resourcePath = mapping.resourcePath;
                    break;
                }
                if (!jcrPath.startsWith(mapping.jcrPathPrefix)) continue;
                if (mapping.resourcePath == null) {
                    resourcePath = null;
                    break;
                }
                resourcePath = mapping.resourcePathPrefix.concat(jcrPath.substring(mapping.jcrPathPrefix.length()));
                break;
            }
        }
        return resourcePath;
    }

    private static final class Mapping {
        public final String jcrPath;
        public final String resourcePath;
        public final String jcrPathPrefix;
        public final String resourcePathPrefix;

        public Mapping(String path, String mappedPath) {
            this.jcrPath = path;
            this.jcrPathPrefix = path.concat("/");
            if (mappedPath.equals(".")) {
                this.resourcePath = null;
                this.resourcePathPrefix = null;
            } else {
                this.resourcePath = mappedPath;
                this.resourcePathPrefix = mappedPath.concat("/");
            }
        }
    }
}

