/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.jackrabbit.oak.plugins.observation.NodeObserver;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserver;
import org.apache.jackrabbit.oak.spi.commit.BackgroundObserverMBean;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;
import org.apache.jackrabbit.oak.spi.commit.Observer;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.JcrResourceChange;
import org.apache.sling.jcr.resource.internal.JcrResourceListener;
import org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper;
import org.apache.sling.spi.resource.provider.ProviderContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OakResourceListener
extends NodeObserver
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String mountPrefix;
    private final ServiceRegistration serviceRegistration;
    private final ServiceRegistration mbeanRegistration;
    private final PathMapper pathMapper;
    private final ProviderContext ctx;
    private final Session session;

    public OakResourceListener(String mountPrefix, ProviderContext ctx, BundleContext bundleContext, Executor executor, PathMapper pathMapper, final int observationQueueLength, SlingRepository repository) throws RepositoryException {
        super(JcrResourceListener.getAbsPath(pathMapper, ctx), new String[]{"jcr:primaryType", "sling:resourceType", "sling:resourceSuperType"});
        this.ctx = ctx;
        this.pathMapper = pathMapper;
        this.mountPrefix = mountPrefix;
        this.session = repository.loginAdministrative(repository.getDefaultWorkspace());
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.vendor", "The Apache Software Foundation");
        props.put("service.description", "Apache Sling JCR Observation Listener for Oak");
        BackgroundObserver observer = new BackgroundObserver((Observer)this, executor, observationQueueLength){

            protected void added(int queueSize) {
                if (queueSize == observationQueueLength) {
                    OakResourceListener.this.logger.warn("Revision queue for observer {} is full (max = {}). Further revisions will be compacted.", (Object)((Object)((Object)this)).getClass().getName(), (Object)observationQueueLength);
                }
            }
        };
        this.serviceRegistration = bundleContext.registerService(Observer.class.getName(), (Object)observer, props);
        Hashtable<String, ObjectName> mbeanProps = new Hashtable<String, ObjectName>(props);
        String objectName = String.format("org.apache.sling:type=%s,name=SlingResourceListener", "BackgroundObserverStats");
        try {
            ((Dictionary)mbeanProps).put("jmx.objectname", new ObjectName(objectName));
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
        this.mbeanRegistration = bundleContext.registerService(BackgroundObserverMBean.class.getName(), (Object)observer.getMBean(), mbeanProps);
    }

    @Override
    public void close() throws IOException {
        this.mbeanRegistration.unregister();
        this.serviceRegistration.unregister();
        this.session.logout();
    }

    protected void added(String path, Set<String> added, Set<String> deleted, Set<String> changed, Map<String, String> properties, CommitInfo commitInfo) {
        JcrResourceChange.Builder builder = this.toEventProperties(JcrResourceListener.stripNtFilePath(path, this.session), added, deleted, changed, commitInfo);
        if (this.ctx.getExcludedPaths().matches(builder.getPath()) != null) {
            return;
        }
        builder.setChangeType(ResourceChange.ChangeType.ADDED);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("added(path={}, added={}, deleted={}, changed={})", new Object[]{path, added, deleted, changed});
        }
        this.ctx.getObservationReporter().reportChanges(Collections.singletonList(builder.build()), false);
    }

    protected void deleted(String path, Set<String> added, Set<String> deleted, Set<String> changed, Map<String, String> properties, CommitInfo commitInfo) {
        JcrResourceChange.Builder builder = this.toEventProperties(path, added, deleted, changed, commitInfo);
        if (this.ctx.getExcludedPaths().matches(builder.getPath()) != null) {
            return;
        }
        builder.setChangeType(ResourceChange.ChangeType.REMOVED);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("deleted(path={}, added={}, deleted={}, changed={})", new Object[]{path, added, deleted, changed});
        }
        this.ctx.getObservationReporter().reportChanges(Collections.singletonList(builder.build()), false);
    }

    protected void changed(String path, Set<String> added, Set<String> deleted, Set<String> changed, Map<String, String> properties, CommitInfo commitInfo) {
        JcrResourceChange.Builder builder = this.toEventProperties(JcrResourceListener.stripNtFilePath(path, this.session), added, deleted, changed, commitInfo);
        if (this.ctx.getExcludedPaths().matches(builder.getPath()) != null) {
            return;
        }
        builder.setChangeType(ResourceChange.ChangeType.CHANGED);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("changed(path={}, added={}, deleted={}, changed={})", new Object[]{path, added, deleted, changed});
        }
        this.ctx.getObservationReporter().reportChanges(Collections.singletonList(builder.build()), false);
    }

    private JcrResourceChange.Builder toEventProperties(String path, Set<String> added, Set<String> deleted, Set<String> changed, CommitInfo commitInfo) {
        JcrResourceChange.Builder builder = new JcrResourceChange.Builder();
        String pathWithPrefix = JcrResourceListener.addMountPrefix(this.mountPrefix, path);
        builder.setPath(this.pathMapper.mapJCRPathToResourcePath(pathWithPrefix));
        if (added != null && added.size() > 0) {
            for (String propName : added) {
                builder.addAddedAttributeName(propName);
            }
        }
        if (changed != null && changed.size() > 0) {
            for (String propName : changed) {
                builder.addChangedAttributeName(propName);
            }
        }
        if (deleted != null && deleted.size() > 0) {
            for (String propName : deleted) {
                builder.addRemovedAttributeName(propName);
            }
        }
        builder.setUserId(commitInfo.getUserId());
        builder.setExternal(false);
        return builder;
    }
}

