/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.resource.internal;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.apache.commons.lang.StringUtils;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.path.Path;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.jcr.resource.internal.JcrResourceChange;
import org.apache.sling.jcr.resource.internal.helper.jcr.PathMapper;
import org.apache.sling.spi.resource.provider.ObserverConfiguration;
import org.apache.sling.spi.resource.provider.ProviderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrResourceListener
implements EventListener,
Closeable {
    private final Logger logger = LoggerFactory.getLogger(JcrResourceListener.class);
    private final String mountPrefix;
    private final boolean hasJackrabbitEventClass;
    private final Session session;
    private final PathMapper pathMapper;
    private final ProviderContext ctx;
    private final boolean includeExternal;

    public JcrResourceListener(ProviderContext ctx, String mountPrefix, PathMapper pathMapper, SlingRepository repository) throws RepositoryException {
        this.includeExternal = this.isIncludeExternal(ctx);
        this.pathMapper = pathMapper;
        this.mountPrefix = mountPrefix;
        this.ctx = ctx;
        boolean foundClass = false;
        try {
            this.getClass().getClassLoader().loadClass(JackrabbitEvent.class.getName());
            foundClass = true;
        }
        catch (Throwable t) {
            // empty catch block
        }
        this.hasJackrabbitEventClass = foundClass;
        this.session = repository.loginAdministrative(repository.getDefaultWorkspace());
        String absPath = JcrResourceListener.getAbsPath(pathMapper, ctx);
        int types = this.getTypes(ctx);
        this.session.getWorkspace().getObservationManager().addEventListener((EventListener)this, types, absPath, true, null, null, false);
    }

    private boolean isIncludeExternal(ProviderContext ctx) {
        for (ObserverConfiguration c : ctx.getObservationReporter().getObserverConfigurations()) {
            if (!c.includeExternal()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        try {
            this.session.getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        }
        catch (RepositoryException e) {
            this.logger.warn("Unable to remove session listener: " + this, (Throwable)e);
        }
        this.session.logout();
    }

    public void onEvent(EventIterator events) {
        HashMap<String, JcrResourceChange.Builder> addedEvents = new HashMap<String, JcrResourceChange.Builder>();
        HashMap<String, JcrResourceChange.Builder> changedEvents = new HashMap<String, JcrResourceChange.Builder>();
        HashMap<String, JcrResourceChange.Builder> removedEvents = new HashMap<String, JcrResourceChange.Builder>();
        while (events.hasNext()) {
            Event event = events.nextEvent();
            if (this.isExternal(event) && !this.includeExternal) continue;
            try {
                String eventPath = event.getPath();
                int type = event.getType();
                if (type == 4 || type == 8 || type == 16) {
                    int lastSlash = eventPath.lastIndexOf(47);
                    String nodePath = eventPath.substring(0, lastSlash);
                    String propName = eventPath.substring(lastSlash + 1);
                    JcrResourceChange.Builder builder = (JcrResourceChange.Builder)changedEvents.get(nodePath);
                    if (builder == null) {
                        builder = this.createResourceChange(event, nodePath, ResourceChange.ChangeType.CHANGED);
                        changedEvents.put(nodePath, builder);
                    }
                    this.updateResourceChanged(builder, event.getType(), propName);
                    continue;
                }
                if (type == 1) {
                    addedEvents.put(eventPath, this.createResourceChange(event, ResourceChange.ChangeType.ADDED));
                    continue;
                }
                if (type != 2) continue;
                addedEvents.remove(eventPath);
                removedEvents.put(eventPath, this.createResourceChange(event, ResourceChange.ChangeType.REMOVED));
            }
            catch (RepositoryException e) {
                this.logger.error("Error during modification: {}", (Throwable)e);
            }
        }
        ArrayList<ResourceChange> changes = new ArrayList<ResourceChange>();
        for (Map.Entry e : addedEvents.entrySet()) {
            String path = (String)e.getKey();
            if (changedEvents.containsKey(path)) {
                JcrResourceChange.Builder builder = (JcrResourceChange.Builder)changedEvents.remove(path);
                builder.setChangeType(ResourceChange.ChangeType.ADDED);
                changes.add(builder.build());
                continue;
            }
            changes.add(((JcrResourceChange.Builder)e.getValue()).build());
        }
        this.buildResourceChanges(changes, removedEvents);
        this.buildResourceChanges(changes, changedEvents);
        this.filterChanges(changes);
        this.ctx.getObservationReporter().reportChanges(changes, false);
    }

    private void buildResourceChanges(List<ResourceChange> result, Map<String, JcrResourceChange.Builder> builders) {
        for (Map.Entry<String, JcrResourceChange.Builder> e : builders.entrySet()) {
            result.add(e.getValue().build());
        }
    }

    private void updateResourceChanged(JcrResourceChange.Builder builder, int eventType, String propName) {
        switch (eventType) {
            case 4: {
                builder.addAddedAttributeName(propName);
                break;
            }
            case 16: {
                builder.addChangedAttributeName(propName);
                break;
            }
            case 8: {
                builder.addRemovedAttributeName(propName);
            }
        }
    }

    private JcrResourceChange.Builder createResourceChange(Event event, String path, ResourceChange.ChangeType changeType) throws RepositoryException {
        String userID;
        JcrResourceChange.Builder builder = new JcrResourceChange.Builder();
        String strippedPath = event.getType() == 2 ? path : JcrResourceListener.stripNtFilePath(path, this.session);
        String pathWithPrefix = JcrResourceListener.addMountPrefix(this.mountPrefix, strippedPath);
        builder.setPath(this.pathMapper.mapJCRPathToResourcePath(pathWithPrefix));
        builder.setChangeType(changeType);
        boolean isExternal = this.isExternal(event);
        builder.setExternal(isExternal);
        if (!isExternal && (userID = event.getUserID()) != null) {
            builder.setUserId(userID);
        }
        return builder;
    }

    private JcrResourceChange.Builder createResourceChange(Event event, ResourceChange.ChangeType changeType) throws RepositoryException {
        return this.createResourceChange(event, event.getPath(), changeType);
    }

    private boolean isExternal(Event event) {
        if (this.hasJackrabbitEventClass && event instanceof JackrabbitEvent) {
            JackrabbitEvent jEvent = (JackrabbitEvent)event;
            return jEvent.isExternal();
        }
        return false;
    }

    static String getAbsPath(PathMapper pathMapper, ProviderContext ctx) {
        HashSet<String> paths = new HashSet<String>();
        for (ObserverConfiguration c : ctx.getObservationReporter().getObserverConfigurations()) {
            HashSet<String> includePaths = new HashSet<String>();
            HashSet<String> excludePaths = new HashSet<String>();
            for (Path p : c.getExcludedPaths()) {
                excludePaths.add(pathMapper.mapResourcePathToJCRPath(p.getPath()));
            }
            for (Path p : c.getPaths()) {
                includePaths.add(pathMapper.mapResourcePathToJCRPath(p.getPath()));
            }
            includePaths.removeAll(excludePaths);
            paths.addAll(includePaths);
        }
        for (Path p : ctx.getExcludedPaths()) {
            paths.remove(pathMapper.mapResourcePathToJCRPath(p.getPath()));
        }
        return JcrResourceListener.getLongestCommonPrefix(paths);
    }

    private static String getLongestCommonPrefix(Set<String> paths) {
        String prefix = null;
        Iterator<String> it = paths.iterator();
        if (it.hasNext()) {
            prefix = it.next();
        }
        while (it.hasNext()) {
            prefix = JcrResourceListener.getCommonPrefix(prefix, it.next());
        }
        return StringUtils.defaultIfEmpty((String)prefix, (String)"/");
    }

    private static String getCommonPrefix(String s1, String s2) {
        int length = Math.min(s1.length(), s2.length());
        StringBuilder prefix = new StringBuilder(length);
        for (int i = 0; i < length && s1.charAt(i) == s2.charAt(i); ++i) {
            prefix.append(s1.charAt(i));
        }
        return prefix.toString();
    }

    private int getTypes(ProviderContext ctx) {
        int result = 0;
        for (ObserverConfiguration c : ctx.getObservationReporter().getObserverConfigurations()) {
            for (ResourceChange.ChangeType t : c.getChangeTypes()) {
                switch (t) {
                    case ADDED: {
                        result |= 1;
                        break;
                    }
                    case REMOVED: {
                        result |= 2;
                        break;
                    }
                    case CHANGED: {
                        result |= 4;
                        result |= 0x10;
                        result |= 8;
                        break;
                    }
                }
            }
        }
        return result;
    }

    static String addMountPrefix(String mountPrefix, String path) {
        String result = mountPrefix == null || mountPrefix.isEmpty() || "/".equals(mountPrefix) ? path : mountPrefix + path;
        return result;
    }

    private void filterChanges(List<ResourceChange> changes) {
        Iterator<ResourceChange> it = changes.iterator();
        while (it.hasNext()) {
            String path = it.next().getPath();
            if (this.ctx.getExcludedPaths().matches(path) == null) continue;
            it.remove();
        }
    }

    static String stripNtFilePath(String path, Session session) {
        if (!path.endsWith("/jcr:content")) {
            return path;
        }
        try {
            Node node;
            try {
                node = session.getNode(path);
            }
            catch (PathNotFoundException e) {
                session.refresh(false);
                node = session.getNode(path);
            }
            Node parent = node.getParent();
            if (parent.isNodeType("nt:file")) {
                return parent.getPath();
            }
            return path;
        }
        catch (RepositoryException e) {
            return path;
        }
    }
}

