/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.jcr.contentparser.impl;

import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.jcr.contentparser.ParseException;
import org.apache.sling.jcr.contentparser.ParserOptions;

class ParserHelper {
    static final String JCR_PRIMARYTYPE = "jcr:primaryType";
    static final String ECMA_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z";
    static final Locale DATE_FORMAT_LOCALE = Locale.US;
    private final ParserOptions options;
    private final DateFormat calendarFormat;

    public ParserHelper(ParserOptions options) {
        this.options = options;
        this.calendarFormat = options.isDetectCalendarValues() ? new SimpleDateFormat(ECMA_DATE_FORMAT, DATE_FORMAT_LOCALE) : null;
    }

    public void ensureDefaultPrimaryType(Map<String, Object> map) {
        String defaultPrimaryType = this.options.getDefaultPrimaryType();
        if (defaultPrimaryType != null && !map.containsKey(JCR_PRIMARYTYPE)) {
            map.put(JCR_PRIMARYTYPE, defaultPrimaryType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Calendar tryParseCalendar(String value) {
        if (this.options.isDetectCalendarValues() && !StringUtils.isBlank((CharSequence)value)) {
            DateFormat dateFormat = this.calendarFormat;
            synchronized (dateFormat) {
                try {
                    Date date = this.calendarFormat.parse(value);
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime(date);
                    return calendar;
                }
                catch (java.text.ParseException parseException) {
                }
            }
        }
        return null;
    }

    public boolean ignoreProperty(String propertyName) {
        return this.ignoreNames(this.options.getIgnorePropertyNames(), propertyName);
    }

    public boolean ignoreResource(String resourceName) {
        return this.ignoreNames(this.options.getIgnoreResourceNames(), resourceName);
    }

    private boolean ignoreNames(Set<String> names, String name) {
        return names != null && names.contains(name);
    }

    public String cleanupPropertyName(String propertyName) {
        Set<String> prefixes = this.options.getRemovePropertyNamePrefixes();
        if (prefixes != null) {
            for (String prefix : prefixes) {
                if (!StringUtils.startsWith((CharSequence)propertyName, (CharSequence)prefix)) continue;
                return StringUtils.substringAfter((String)propertyName, (String)prefix);
            }
        }
        return propertyName;
    }

    public Object convertSingleTypeArray(Object[] values) {
        if (values.length == 0) {
            return values;
        }
        Class<?> itemType = null;
        for (Object value : values) {
            if (value == null) {
                throw new ParseException("Multivalue array must not contain null values.");
            }
            if (value instanceof Map || value instanceof JsonObject) {
                throw new ParseException("Multivalue array must not contain maps/objects.");
            }
            if (itemType == null) {
                itemType = value.getClass();
                continue;
            }
            if (itemType == value.getClass()) continue;
            throw new ParseException("Multivalue array must not contain values with different types (" + itemType.getName() + ", " + value.getClass().getName() + ").");
        }
        Object convertedArray = Array.newInstance(itemType, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(convertedArray, i, values[i]);
        }
        return convertedArray;
    }

    public String concatenatePath(String parentPath, String name) {
        if (StringUtils.endsWith((CharSequence)parentPath, (CharSequence)"/")) {
            return parentPath + name;
        }
        return parentPath + "/" + name;
    }
}

