/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.log;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.engine.impl.log.FileRequestLog;
import org.apache.sling.engine.impl.log.RequestLoggerRequest;
import org.apache.sling.engine.impl.log.RequestLoggerResponse;
import org.apache.sling.engine.impl.log.RequestLoggerService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.propertytypes.ServiceDescription;
import org.osgi.service.component.propertytypes.ServiceRanking;
import org.osgi.service.component.propertytypes.ServiceVendor;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardContextSelect;
import org.osgi.service.http.whiteboard.propertytypes.HttpWhiteboardFilterPattern;
import org.slf4j.LoggerFactory;

@Component(configurationPolicy=ConfigurationPolicy.IGNORE, service={Filter.class})
@HttpWhiteboardContextSelect(value="(osgi.http.whiteboard.context.name=org.apache.sling)")
@HttpWhiteboardFilterPattern(value={"/"})
@ServiceRanking(value=32768)
@ServiceDescription(value="Request Logger Filter")
@ServiceVendor(value="The Apache Software Foundation")
public final class RequestLoggerFilter
implements Filter {
    private static final RequestLoggerService[] NONE = new RequestLoggerService[0];
    private RequestLoggerService[] requestEntry = NONE;
    private RequestLoggerService[] requestExit = NONE;

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        RequestLoggerRequest rlreq = new RequestLoggerRequest((HttpServletRequest)request);
        RequestLoggerResponse rlres = new RequestLoggerResponse((HttpServletResponse)response);
        this.log(this.requestEntry, rlreq, rlres);
        try {
            chain.doFilter((ServletRequest)rlreq, (ServletResponse)rlres);
        }
        finally {
            rlres.requestEnd();
            this.log(this.requestExit, rlreq, rlres);
        }
    }

    public void destroy() {
        FileRequestLog.dispose();
    }

    @Reference(cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC)
    private void bindRequestLoggerService(RequestLoggerService requestLoggerService) {
        if (requestLoggerService.isOnEntry()) {
            this.requestEntry = this.addService(this.requestEntry, requestLoggerService);
        } else {
            this.requestExit = this.addService(this.requestExit, requestLoggerService);
        }
    }

    private void unbindRequestLoggerService(RequestLoggerService requestLoggerService) {
        if (requestLoggerService.isOnEntry()) {
            this.requestEntry = this.removeService(this.requestEntry, requestLoggerService);
        } else {
            this.requestExit = this.removeService(this.requestExit, requestLoggerService);
        }
    }

    private RequestLoggerService[] addService(RequestLoggerService[] list, RequestLoggerService requestLoggerService) {
        if (list.length == 0) {
            return new RequestLoggerService[]{requestLoggerService};
        }
        RequestLoggerService[] newList = new RequestLoggerService[list.length + 1];
        System.arraycopy(list, 0, newList, 0, list.length);
        newList[list.length] = requestLoggerService;
        return newList;
    }

    private RequestLoggerService[] removeService(RequestLoggerService[] list, RequestLoggerService requestLoggerService) {
        RequestLoggerService[] newList = NONE;
        for (int i = 0; i < list.length; ++i) {
            if (list[i] != requestLoggerService) continue;
            newList = new RequestLoggerService[list.length - 1];
            if (i > 0) {
                System.arraycopy(list, 0, newList, 0, i);
            }
            if (i >= list.length - 1) continue;
            System.arraycopy(list, i + 1, newList, 0, newList.length - i);
        }
        return newList.length > 0 ? newList : NONE;
    }

    private void log(RequestLoggerService[] services, RequestLoggerRequest request, RequestLoggerResponse response) {
        for (RequestLoggerService service : services) {
            try {
                service.log(request, response);
            }
            catch (Exception e) {
                LoggerFactory.getLogger(this.getClass()).debug("log: RequestLoggerService failed logging", (Throwable)e);
            }
        }
    }
}

