/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.threads.impl;

import java.util.concurrent.ThreadFactory;
import org.apache.sling.commons.threads.ThreadPoolConfig;

public final class ExtendedThreadFactory
implements ThreadFactory {
    private final boolean isDaemon;
    private final int priority;
    private final ThreadFactory factory;

    public ExtendedThreadFactory(ThreadFactory factory, ThreadPoolConfig.ThreadPriority priority, boolean isDaemon) {
        this.isDaemon = isDaemon;
        if (priority == null) {
            throw new IllegalStateException("Prioriy must not be null.");
        }
        switch (priority) {
            case NORM: {
                this.priority = 5;
                break;
            }
            case MIN: {
                this.priority = 1;
                break;
            }
            case MAX: {
                this.priority = 10;
                break;
            }
            default: {
                this.priority = 5;
            }
        }
        this.factory = factory;
    }

    public Thread newThread(Runnable command) {
        Thread thread = this.factory.newThread(command);
        thread.setPriority(this.priority);
        thread.setDaemon(this.isDaemon);
        return thread;
    }
}

