/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.mime.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.PropertyUnbounded;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.commons.mime.MimeTypeProvider;
import org.apache.sling.commons.mime.MimeTypeService;
import org.apache.sling.commons.mime.internal.MimeTypeWebConsolePlugin;
import org.apache.sling.commons.osgi.OsgiUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=true, label="%mime.service.name", description="%mime.service.description")
@Service(value={MimeTypeService.class})
@Property(name="service.description", value={"Apache Sling MIME Type Service"})
@Reference(name="MimeTypeProvider", referenceInterface=MimeTypeProvider.class, cardinality=ReferenceCardinality.OPTIONAL_MULTIPLE, policy=ReferencePolicy.DYNAMIC)
public class MimeTypeServiceImpl
implements MimeTypeService,
BundleListener {
    public static final String CORE_MIME_TYPES = "/META-INF/core_mime.types";
    public static final String MIME_TYPES = "/META-INF/mime.types";
    @Property(unbounded=PropertyUnbounded.ARRAY)
    private static final String PROP_MIME_TYPES = "mime.types";
    @Reference(cardinality=ReferenceCardinality.OPTIONAL_UNARY, policy=ReferencePolicy.DYNAMIC)
    private volatile LogService logService;
    private Map<String, String> mimeTab = new HashMap<String, String>();
    private Map<String, String> extensionMap = new HashMap<String, String>();
    private MimeTypeProvider[] typeProviders;
    private List<MimeTypeProvider> typeProviderList = new ArrayList<MimeTypeProvider>();
    private ServiceRegistration webConsolePluginService;

    @Override
    public String getMimeType(String name) {
        if (name == null) {
            return null;
        }
        String ext = name.substring(name.lastIndexOf(46) + 1);
        String type = this.mimeTab.get(ext = ext.toLowerCase());
        if (type == null) {
            MimeTypeProvider[] mtp = this.getMimeTypeProviders();
            for (int i = 0; type == null && i < mtp.length; ++i) {
                type = mtp[i].getMimeType(ext);
            }
        }
        return type;
    }

    @Override
    public String getExtension(String mimeType) {
        if (mimeType == null) {
            return null;
        }
        String ext = this.extensionMap.get(mimeType = mimeType.toLowerCase());
        if (ext == null) {
            MimeTypeProvider[] mtp = this.getMimeTypeProviders();
            for (int i = 0; ext == null && i < mtp.length; ++i) {
                ext = mtp[i].getExtension(mimeType);
            }
        }
        return ext;
    }

    @Override
    public void registerMimeType(String mimeType, String ... extensions) {
        if (mimeType == null || mimeType.length() == 0 || extensions == null || extensions.length == 0) {
            return;
        }
        mimeType = mimeType.toLowerCase();
        String defaultExtension = this.extensionMap.get(mimeType);
        for (String extension : extensions) {
            if (extension == null || extension.length() <= 0) continue;
            String oldMimeType = this.mimeTab.get(extension = extension.toLowerCase());
            if (oldMimeType == null) {
                this.log(4, "registerMimeType: Add mapping " + extension + "=" + mimeType, null);
                this.mimeTab.put(extension, mimeType);
                if (defaultExtension != null) continue;
                defaultExtension = extension;
                continue;
            }
            this.log(3, "registerMimeType: Ignoring mapping " + extension + "=" + mimeType + ": Mapping " + extension + "=" + oldMimeType + " already exists", null);
        }
        if (defaultExtension != null) {
            this.extensionMap.put(mimeType, defaultExtension);
        }
    }

    @Override
    public void registerMimeType(InputStream mimeTabStream) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(mimeTabStream, "ISO-8859-1"));
        while ((line = br.readLine()) != null) {
            if (line.startsWith("#")) continue;
            this.registerMimeType(line);
        }
    }

    protected void activate(ComponentContext context) {
        context.getBundleContext().addBundleListener((BundleListener)this);
        Bundle bundle = context.getBundleContext().getBundle();
        this.registerMimeType(bundle.getEntry(CORE_MIME_TYPES));
        this.registerMimeType(bundle.getEntry(MIME_TYPES));
        Bundle[] bundles = context.getBundleContext().getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            if ((bundles[i].getState() & 0x3C) == 0 || bundles[i].getBundleId() == bundle.getBundleId()) continue;
            this.registerMimeType(bundles[i].getEntry(MIME_TYPES));
        }
        String[] configTypes = OsgiUtil.toStringArray(context.getProperties().get(PROP_MIME_TYPES));
        if (configTypes != null) {
            for (String configType : configTypes) {
                this.registerMimeType(configType);
            }
        }
        try {
            MimeTypeWebConsolePlugin plugin = new MimeTypeWebConsolePlugin(this);
            Hashtable<String, String> props = new Hashtable<String, String>();
            ((Dictionary)props).put("felix.webconsole.label", "mimetypes");
            ((Dictionary)props).put("felix.webconsole.title", "MIME Types");
            ((Dictionary)props).put("felix.webconsole.css", "mimetypes/res/jquery.treeTable.css");
            this.webConsolePluginService = context.getBundleContext().registerService("javax.servlet.Servlet", (Object)plugin, props);
        }
        catch (Throwable t) {
            // empty catch block
        }
    }

    protected void deactivate(ComponentContext context) {
        context.getBundleContext().removeBundleListener((BundleListener)this);
        if (this.webConsolePluginService != null) {
            this.webConsolePluginService.unregister();
            this.webConsolePluginService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindMimeTypeProvider(MimeTypeProvider mimeTypeProvider) {
        List<MimeTypeProvider> list = this.typeProviderList;
        synchronized (list) {
            this.typeProviderList.add(mimeTypeProvider);
            this.typeProviders = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindMimeTypeProvider(MimeTypeProvider mimeTypeProvider) {
        List<MimeTypeProvider> list = this.typeProviderList;
        synchronized (list) {
            this.typeProviderList.remove(mimeTypeProvider);
            this.typeProviders = null;
        }
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 32) {
            this.registerMimeType(event.getBundle().getEntry(MIME_TYPES));
        }
    }

    Map<String, String> getMimeMap() {
        return this.mimeTab;
    }

    Map<String, String> getExtensionMap() {
        return this.extensionMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MimeTypeProvider[] getMimeTypeProviders() {
        MimeTypeProvider[] list = this.typeProviders;
        if (list == null) {
            List<MimeTypeProvider> list2 = this.typeProviderList;
            synchronized (list2) {
                this.typeProviders = this.typeProviderList.toArray(new MimeTypeProvider[this.typeProviderList.size()]);
                list = this.typeProviders;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMimeType(URL mimetypes) {
        if (mimetypes != null) {
            InputStream ins = null;
            try {
                ins = mimetypes.openStream();
                this.registerMimeType(ins);
            }
            catch (IOException ioe) {
                this.log(2, "An error occurred reading " + mimetypes, ioe);
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void registerMimeType(String line) {
        String[] parts = line.split("\\s+");
        if (parts.length > 1) {
            String[] extensions = new String[parts.length - 1];
            System.arraycopy(parts, 1, extensions, 0, extensions.length);
            this.registerMimeType(parts[0], extensions);
        }
    }

    private void log(int level, String message, Throwable t) {
        LogService log = this.logService;
        if (log != null) {
            log.log(level, message, t);
        } else {
            PrintStream out = level == 1 ? System.err : System.out;
            out.println(message);
            if (t != null) {
                t.printStackTrace(out);
            }
        }
    }

    protected void bindLogService(LogService logService) {
        this.logService = logService;
    }

    protected void unbindLogService(LogService logService) {
        if (this.logService == logService) {
            this.logService = null;
        }
    }
}

