/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.caconfig.management.impl.console;

import caconfigimpl.org.apache.sling.commons.osgi.Order;
import caconfigimpl.org.apache.sling.commons.osgi.ServiceUtil;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.inventory.Format;
import org.apache.felix.inventory.InventoryPrinter;
import org.apache.sling.caconfig.management.impl.console.ConfigurationMetadataPrinter;
import org.apache.sling.caconfig.management.impl.console.ConfigurationOverridePrinter;
import org.apache.sling.caconfig.management.impl.console.ConfigurationPersistenceStrategyPrinter;
import org.apache.sling.caconfig.management.impl.console.ServiceConfigurationPrinter;
import org.apache.sling.caconfig.resource.spi.CollectionInheritanceDecider;
import org.apache.sling.caconfig.resource.spi.ConfigurationResourceResolvingStrategy;
import org.apache.sling.caconfig.resource.spi.ContextPathStrategy;
import org.apache.sling.caconfig.spi.ConfigurationInheritanceStrategy;
import org.apache.sling.caconfig.spi.ConfigurationMetadataProvider;
import org.apache.sling.caconfig.spi.ConfigurationOverrideProvider;
import org.apache.sling.caconfig.spi.ConfigurationPersistenceStrategy2;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(service={InventoryPrinter.class}, property={"service.description=Apache Sling Context-Aware Configuration Resolver Console Inventory Printer", "felix.inventory.printer.name=slingcaconfig", "felix.inventory.printer.title=Sling Context-Aware Configuration", "felix.inventory.printer.format=TEXT"})
public class CAConfigInventoryPrinter
implements InventoryPrinter {
    public static final String NAME = "slingcaconfig";
    public static final String TITLE = "Sling Context-Aware Configuration";
    private BundleContext bundleContext;

    @Activate
    private void activate(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void print(PrintWriter pw, Format format, boolean isZip) {
        if (format != Format.TEXT) {
            return;
        }
        this.printSPISection(pw, ContextPathStrategy.class, "Context Path Strategies", new ServiceConfigurationPrinter[0]);
        this.printSPISection(pw, ConfigurationResourceResolvingStrategy.class, "Configuration Resource Resolving Strategies", new ServiceConfigurationPrinter[0]);
        this.printSPISection(pw, CollectionInheritanceDecider.class, "Collection Inheritance Deciders", new ServiceConfigurationPrinter[0]);
        this.printSPISection(pw, ConfigurationInheritanceStrategy.class, "Configuration Inheritance Strategies", new ServiceConfigurationPrinter[0]);
        this.printSPISection(pw, ConfigurationPersistenceStrategy2.class, "Configuration Persistance Strategies", new ConfigurationPersistenceStrategyPrinter());
        this.printSPISection(pw, ConfigurationMetadataProvider.class, "Configuration Metadata Providers", new ConfigurationMetadataPrinter());
        this.printSPISection(pw, ConfigurationOverrideProvider.class, "Configuration Override Providers", new ConfigurationOverridePrinter());
    }

    @SafeVarargs
    private final <T> void printSPISection(PrintWriter pw, Class<T> clazz, String title, ServiceConfigurationPrinter<T> ... serviceConfigPrinters) {
        Collection<ServiceReference<T>> serviceReferences = this.getServiceReferences(clazz);
        pw.println(title);
        pw.println(StringUtils.repeat((char)'-', (int)title.length()));
        if (serviceReferences.isEmpty()) {
            pw.println("(none)");
        } else {
            for (ServiceReference<T> serviceReference : serviceReferences) {
                pw.print("- ");
                pw.print(this.getServiceClassName(serviceReference));
                pw.print(" [");
                pw.print(this.getServiceRanking(serviceReference));
                if (!this.isEnabled(serviceReference)) {
                    pw.print(", disabled");
                }
                pw.print("]");
                pw.println();
                for (ServiceConfigurationPrinter<T> serviceConfigPrinter : serviceConfigPrinters) {
                    serviceConfigPrinter.printConfiguration(pw, serviceReference, this.bundleContext);
                }
            }
        }
        pw.println();
    }

    private <T> Collection<ServiceReference<T>> getServiceReferences(Class<T> clazz) {
        try {
            TreeMap<Comparable<Object>, ServiceReference> sortedServices = new TreeMap<Comparable<Object>, ServiceReference>();
            Collection serviceReferences = this.bundleContext.getServiceReferences(clazz, null);
            for (ServiceReference serviceReference : serviceReferences) {
                HashMap<String, Object> props = new HashMap<String, Object>();
                for (String property : serviceReference.getPropertyKeys()) {
                    props.put(property, serviceReference.getProperty(property));
                }
                sortedServices.put(ServiceUtil.getComparableForServiceRanking(props, Order.DESCENDING), serviceReference);
            }
            return sortedServices.values();
        }
        catch (InvalidSyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private <T> String getServiceClassName(ServiceReference<T> serviceReference) {
        Object service = this.bundleContext.getService(serviceReference);
        String serviceClassName = service.getClass().getName();
        this.bundleContext.ungetService(serviceReference);
        return serviceClassName;
    }

    private <T> int getServiceRanking(ServiceReference<T> serviceReference) {
        Integer serviceRanking = (Integer)serviceReference.getProperty("service.ranking");
        if (serviceRanking == null) {
            return 0;
        }
        return serviceRanking;
    }

    private <T> boolean isEnabled(ServiceReference<T> serviceReference) {
        Object enabledObject = serviceReference.getProperty("enabled");
        if (enabledObject != null) {
            if (enabledObject instanceof Boolean) {
                return (Boolean)enabledObject;
            }
            return BooleanUtils.toBoolean((String)enabledObject.toString());
        }
        return true;
    }
}

